/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.xel.zel;

import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Binder;
import org.zkoss.bind.DependsOn;
import org.zkoss.bind.NotifyChange;
import org.zkoss.bind.Property;
import org.zkoss.bind.impl.BindContextUtil;
import org.zkoss.bind.impl.LoadFormBindingImpl;
import org.zkoss.bind.impl.LoadPropertyBindingImpl;
import org.zkoss.bind.impl.PropertyImpl;
import org.zkoss.bind.sys.BindEvaluatorX;
import org.zkoss.bind.sys.Binding;
import org.zkoss.bind.xel.zel.BindELResolver;
import org.zkoss.xel.ExpressionX;
import org.zkoss.xel.XelContext;
import org.zkoss.xel.zel.XelELContext;
import org.zkoss.zel.ELResolver;
import org.zkoss.zel.VariableMapper;
import org.zkoss.zel.impl.parser.AstBracketSuffix;
import org.zkoss.zel.impl.parser.AstDotSuffix;
import org.zkoss.zel.impl.parser.AstValue;
import org.zkoss.zel.impl.parser.Node;
import org.zkoss.zk.ui.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindELContext
extends XelELContext {
    public BindELContext(XelContext xelc) {
        super(xelc);
    }

    protected ELResolver newELResolver(XelContext xelc) {
        return new BindELResolver(xelc);
    }

    public VariableMapper getVariableMapper() {
        return super.getVariableMapper();
    }

    public Binding getBinding() {
        return (Binding)this.getXelContext().getAttribute("$BINDING$");
    }

    public boolean ignoreTracker() {
        return this.getBinding() == null || Boolean.TRUE.equals(this.getXelContext().getAttribute("$IGNORE_TRACKER$"));
    }

    public Object getAttribute(String name) {
        return this.getXelContext().getAttribute(name);
    }

    public Object setAttribute(String name, Object value) {
        return this.getXelContext().setAttribute(name, value);
    }

    public static Set<Property> getNotifys(Method m, Object base, String prop, Object value) {
        NotifyChange annt;
        LinkedHashSet<Property> notifys = new LinkedHashSet<Property>();
        NotifyChange notifyChange = annt = m == null ? null : m.getAnnotation(NotifyChange.class);
        if (annt != null) {
            String[] notifies = annt.value();
            if (notifies.length > 0) {
                for (String notify : notifies) {
                    PropertyImpl propx = new PropertyImpl(base, notify, value);
                    notifys.add(propx);
                }
            } else if (prop != null) {
                notifys.add(new PropertyImpl(base, prop, value));
            }
        }
        return notifys;
    }

    public static void addNotifys(Method m, Object base, String prop, Object value, BindContext ctx) {
        Set<Property> props = BindELContext.getNotifys(m, base, prop, value);
        BindELContext.addNotifys(props, ctx);
    }

    private static void addNotifys(Set<Property> props, BindContext ctx) {
        if (ctx == null) {
            return;
        }
        Set<Property> notifys = BindELContext.getNotifys(ctx);
        if (notifys == null) {
            notifys = new LinkedHashSet<Property>();
            ctx.setAttribute("$NOTIFYS$", notifys);
        }
        notifys.addAll(props);
    }

    private static Set<Property> getNotifys(BindContext ctx) {
        return (Set)ctx.getAttribute("$NOTIFYS$");
    }

    private static Set<Property> getValidates(BindContext ctx) {
        return (Set)ctx.getAttribute("$VALIDATES$");
    }

    private static void addValidates(Set<Property> props, BindContext ctx) {
        if (ctx == null) {
            return;
        }
        Set<Property> validates = BindELContext.getValidates(ctx);
        if (validates == null) {
            validates = new LinkedHashSet<Property>();
            ctx.setAttribute("$VALIDATES$", validates);
        }
        validates.addAll(props);
    }

    static String toNodeString(Node next, StringBuffer path) {
        if (next instanceof AstBracketSuffix) {
            String bracketString = BindELContext.toNodeString(next.jjtGetChild(0), new StringBuffer());
            path.append("[").append(bracketString).append("]");
        } else if (next instanceof AstValue) {
            int len = next.jjtGetNumChildren();
            for (int j = 0; j < len; ++j) {
                Node kid = next.jjtGetChild(j);
                BindELContext.toNodeString(kid, path);
            }
        } else if (next instanceof AstDotSuffix) {
            path.append(".").append(next.getImage());
        } else {
            path.append(next.getImage());
        }
        return path.toString();
    }

    public static boolean isBracket(String script) {
        return script.startsWith("[") && script.endsWith("]");
    }

    public static String appendFields(String prefix, String field) {
        return prefix + (BindELContext.isBracket(field) ? "" : Character.valueOf('.')) + field;
    }

    public static void addDependsOnTrackings(Method m, String basepath, List<String> srcpath, Binding binding, BindContext ctx) {
        String[] props;
        DependsOn annt = m.getAnnotation(DependsOn.class);
        if (annt != null && (props = annt.value()).length > 0) {
            if (binding instanceof LoadPropertyBindingImpl) {
                ((LoadPropertyBindingImpl)binding).addDependsOnTrackings(m, basepath, srcpath, props);
            } else if (binding instanceof LoadFormBindingImpl) {
                ((LoadFormBindingImpl)binding).addDependsOnTrackings(m, basepath, srcpath, props);
            }
        }
    }

    public static String pathToString(List<String> path) {
        StringBuffer sb = new StringBuffer();
        for (String prop : path) {
            sb.append(prop);
        }
        return sb.toString();
    }

    public static void addDependsOnTracking(Method m, String basepath, List<String> srcpath, String prop, Binding binding) {
        Component comp = binding.getComponent();
        Binder binder = binding.getBinder();
        BindEvaluatorX eval = binder.getEvaluatorX();
        String path = BindELContext.appendFields(basepath, prop);
        BindContext ctxparse = BindContextUtil.newBindContext(binder, binding, false, null, comp, null);
        ctxparse.setAttribute("$SRCPATH$", srcpath);
        ExpressionX expr = eval.parseExpressionX(ctxparse, path, Object.class);
        BindContext ctx = BindContextUtil.newBindContext(binder, binding, false, null, comp, null);
        eval.getValue(ctx, comp, expr);
    }
}

