/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import org.zkoss.io.FileWriter;
import org.zkoss.lang.Library;
import org.zkoss.util.Locales;

public class Files {
    public static final char DRIVE_SEPARATOR_CHAR = (char)(System.getProperty("os.name").indexOf("Windows") < 0 ? 0 : 58);
    public static int CP_PRESERVE = 1;
    public static int CP_UPDATE = 2;
    public static int CP_OVERWRITE = 4;
    public static int CP_SKIP_SVN = 4096;

    protected Files() {
    }

    public static final String correctSeparator(String flnm) {
        return File.separatorChar != '/' ? flnm.replace('/', File.separatorChar) : flnm;
    }

    public static final File getConfigDirectory() {
        String confdir = Library.getProperty("org.zkoss.io.conf.dir");
        if (confdir != null) {
            return new File(confdir);
        }
        String userdir = System.getProperty("user.dir", ".");
        File fl0 = new File(userdir, "conf");
        if (Files.exists(fl0) == null) {
            File fl = Files.exists(new File(userdir, "config"));
            if (fl != null) {
                return fl;
            }
            if (!".".equals(userdir)) {
                fl = Files.exists(new File(userdir, "../conf"));
                if (fl != null) {
                    return fl;
                }
                fl = Files.exists(new File(userdir, "../config"));
                if (fl != null) {
                    return fl;
                }
                fl = Files.exists(new File("./conf"));
                if (fl != null) {
                    return fl;
                }
                fl = Files.exists(new File("./config"));
                if (fl != null) {
                    return fl;
                }
            }
            if ((fl = Files.exists(new File("../conf"))) != null) {
                return fl;
            }
            fl = Files.exists(new File("../config"));
            if (fl != null) {
                return fl;
            }
        }
        return fl0;
    }

    private static final File exists(File fl) {
        return fl.exists() ? fl : null;
    }

    public static final byte[] readAll(InputStream in) throws IOException {
        int v;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[16384];
        while ((v = in.read(buf)) >= 0) {
            out.write(buf, 0, v);
        }
        return out.toByteArray();
    }

    public static final StringBuffer readAll(Reader reader) throws IOException {
        StringWriter writer = new StringWriter(16384);
        Files.copy(writer, reader);
        return writer.getBuffer();
    }

    public static final void copy(Writer writer, Reader reader) throws IOException {
        int v;
        char[] buf = new char[4096];
        while ((v = reader.read(buf)) >= 0) {
            if (v <= 0) continue;
            writer.write(buf, 0, v);
        }
    }

    public static final void copy(OutputStream out, InputStream in) throws IOException {
        int v;
        byte[] buf = new byte[8192];
        while ((v = in.read(buf)) >= 0) {
            if (v <= 0) continue;
            out.write(buf, 0, v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copy(File dst, Reader reader, String charset) throws IOException {
        File parent = dst.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        OutputStreamWriter writer = charset != null ? new FileWriter(dst, charset) : new java.io.FileWriter(dst);
        try {
            Files.copy(writer, reader);
        }
        finally {
            Files.close(reader);
            ((Writer)writer).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copy(File dst, InputStream in) throws IOException {
        File parent = dst.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dst));
        try {
            Files.copy(out, in);
        }
        finally {
            Files.close(in);
            ((OutputStream)out).close();
        }
    }

    public static final void copy(File dst, File src, int flags) throws IOException {
        if (!src.exists()) {
            throw new FileNotFoundException(src.toString());
        }
        if (dst.isDirectory()) {
            if (src.isDirectory()) {
                Files.copyDir(dst, src, flags);
            } else {
                Files.copyFile(new File(dst, src.getName()), src, flags);
            }
        } else if (dst.isFile()) {
            if (src.isDirectory()) {
                throw new IOException("Unable to copy a directory, " + src + ", to a file, " + dst);
            }
            Files.copyFile(dst, src, flags);
        } else if (src.isDirectory()) {
            Files.copyDir(dst, src, flags);
        } else {
            Files.copyFile(dst, src, flags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void copyFile(File dst, File src, int flags) throws IOException {
        assert (src.isFile());
        if (dst.equals(src)) {
            throw new IOException("Copy to the same file, " + src);
        }
        if ((flags & CP_OVERWRITE) == 0) {
            if ((flags & CP_UPDATE) != 0) {
                if (dst.lastModified() >= src.lastModified()) {
                    return;
                }
            } else if (dst.exists()) {
                throw new IOException("The destination already exists, " + dst);
            }
        }
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(src));
        try {
            Files.copy(dst, (InputStream)is);
        }
        finally {
            Files.close(is);
        }
        if ((flags & CP_PRESERVE) != 0) {
            dst.setLastModified(src.lastModified());
        }
    }

    private static final void copyDir(File dst, File src, int flags) throws IOException {
        if ((flags & CP_SKIP_SVN) != 0 && ".svn".equals(src.getName())) {
            return;
        }
        assert (src.isDirectory());
        File[] srcs = src.listFiles();
        for (int j = 0; j < srcs.length; ++j) {
            Files.copy(new File(dst, srcs[j].getName()), srcs[j], flags);
        }
    }

    public static final boolean deleteAll(File file) {
        if (file.isDirectory()) {
            File[] fls = file.listFiles();
            for (int j = 0; j < fls.length; ++j) {
                if (Files.deleteAll(fls[j])) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static final void close(InputStream strm) {
        if (strm != null) {
            try {
                strm.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static final void close(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static final void close(OutputStream strm) {
        if (strm != null) {
            try {
                strm.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static final void close(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static final String normalize(String parentPath, String childPath) {
        if (childPath == null || childPath.length() == 0) {
            return Files.normalize(parentPath);
        }
        if (parentPath == null || parentPath.length() == 0 || childPath.charAt(0) == '/') {
            return Files.normalize(childPath);
        }
        if (parentPath.charAt(parentPath.length() - 1) == '/') {
            return Files.normalize(parentPath + childPath);
        }
        return Files.normalize(parentPath + '/' + childPath);
    }

    public static final String normalize(String path) {
        int j;
        if (path == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(path);
        boolean slash = false;
        int len = sb.length();
        for (j = 0; j < len; ++j) {
            boolean curslash;
            boolean bl = curslash = sb.charAt(j) == '/';
            if (curslash && slash && j != 1) {
                sb.deleteCharAt(j);
                --j;
                --len;
            }
            slash = curslash;
        }
        if (sb.length() > 1 && slash) {
            sb.setLength(sb.length() - 1);
        }
        while (sb.length() >= 2 && sb.charAt(0) == '.' && sb.charAt(1) == '/') {
            sb.delete(0, 2);
        }
        j = 0;
        while ((j = sb.indexOf("/./", j)) >= 0) {
            sb.delete(j + 1, j + 3);
        }
        int len2 = sb.length();
        if (len2 >= 2 && sb.charAt(len2 - 1) == '.' && sb.charAt(len2 - 2) == '/') {
            if (len2 == 2) {
                return "/";
            }
            sb.delete(len2 - 2, len2);
        }
        int j2 = 0;
        while ((j2 = sb.indexOf("/../", j2)) >= 0) {
            j2 = Files.removeDotDot(sb, j2);
        }
        len2 = sb.length();
        if (len2 >= 3 && sb.charAt(len2 - 1) == '.' && sb.charAt(len2 - 2) == '.' && sb.charAt(len2 - 3) == '/') {
            if (len2 == 3) {
                return "/";
            }
            Files.removeDotDot(sb, len2 - 3);
        }
        return sb.length() == path.length() ? path : sb.toString();
    }

    private static int removeDotDot(StringBuffer sb, int j) {
        int k = j;
        while (--k >= 0 && sb.charAt(k) != '/') {
        }
        if (k + 3 == j && sb.charAt(k + 1) == '.' && sb.charAt(k + 2) == '.') {
            return j + 4;
        }
        sb.delete(j, j + 3);
        if (j == 0) {
            return 0;
        }
        if (k < 0) {
            sb.delete(0, j < sb.length() ? j + 1 : j);
            return 0;
        }
        if (j >= sb.length()) {
            ++k;
        }
        sb.delete(k, j);
        return k;
    }

    public static final void write(Writer out, StringBuffer sb) throws IOException {
        int len = sb.length();
        for (int j = 0; j < len; ++j) {
            out.write(sb.charAt(j));
        }
    }

    public static final String locate(String flnm) {
        int j = flnm.indexOf(42);
        if (j < 0) {
            return flnm;
        }
        String postfix = flnm.substring(j + 1);
        Locale locale = Locales.getCurrent();
        String[] secs = new String[]{locale.getLanguage(), locale.getCountry(), locale.getVariant()};
        StringBuffer sb = new StringBuffer(flnm.substring(0, j));
        int prefixlen = sb.length();
        j = secs.length;
        while (true) {
            if (--j >= 0 && secs[j].length() == 0) {
                continue;
            }
            sb.setLength(prefixlen);
            for (int k = 0; k <= j; ++k) {
                sb.append('_').append(secs[k]);
            }
            sb.append(postfix);
            flnm = sb.toString();
            if (j < 0 || new File(flnm).exists()) break;
        }
        return flnm;
    }
}

