/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.io;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.zkoss.io.Repeatable;

class RepeatableURLInputStream
extends InputStream
implements Repeatable {
    private final URL _url;
    private InputStream _in;

    RepeatableURLInputStream(URL url) {
        this._url = url;
    }

    public int read() throws IOException {
        if (this._in == null) {
            this._in = this._url.openStream();
            if (this._in == null) {
                throw new FileNotFoundException(this._url.toExternalForm());
            }
            this._in = new BufferedInputStream(this._in);
        }
        return this._in.read();
    }

    public void close() throws IOException {
        if (this._in != null) {
            this._in.close();
            this._in = null;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

