/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.device;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.zkoss.io.Files;
import org.zkoss.util.Locales;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.device.GenericDevice;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.http.Wpds;
import org.zkoss.zk.ui.util.Clients;

public class AjaxDevice
extends GenericDevice {
    public boolean isSupported(int func) {
        return func == 1;
    }

    public boolean isCacheable() {
        return false;
    }

    public Boolean isCompatible(String userAgent) {
        return (userAgent = userAgent.toLowerCase()).indexOf("mozilla") >= 0 || userAgent.indexOf("msie ") >= 0 || userAgent.indexOf("gecko/") >= 0 || userAgent.indexOf("safari") >= 0 || userAgent.indexOf("opera") >= 0 ? Boolean.TRUE : null;
    }

    public String getContentType() {
        return "text/html";
    }

    public String getDocType() {
        return "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">";
    }

    public String packageToPath(String pkg) {
        return "/js/" + pkg + ".wpd";
    }

    public String toAbsolutePath(String path) {
        char cc = path.length() > 0 ? path.charAt(0) : (char)'\u0000';
        return cc != '/' && cc != '~' ? "/js/" + path : path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadMessages(Locale locale) throws IOException {
        if (locale == null) {
            locale = Locales.getCurrent();
        }
        StringBuffer sb = new StringBuffer(4096);
        Locale oldl = Locales.setThreadLocal((Locale)locale);
        try {
            Execution exec = Executions.getCurrent();
            sb.append(AjaxDevice.loadJS(exec, "~./js/zk/lang/msgzk*.js"));
            sb.append(Wpds.outLocaleJavaScript());
            sb.append(AjaxDevice.loadJS(exec, "~./js/zul/lang/msgzul*.js"));
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            Locales.setThreadLocal((Locale)oldl);
            throw throwable;
        }
        Locales.setThreadLocal((Locale)oldl);
        Clients.response("zk.reload", new AuScript(null, sb.toString()));
    }

    private static String loadJS(Execution exec, String path) throws IOException {
        path = exec.locate(path);
        InputStream is = exec.getDesktop().getWebApp().getResourceAsStream(path);
        if (is == null) {
            throw new UiException("Unable to load " + path);
        }
        byte[] bs = Files.readAll((InputStream)is);
        Files.close((InputStream)is);
        return new String(bs, "UTF-8");
    }
}

