/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.scripting.util;

import java.util.LinkedList;
import java.util.List;
import org.zkoss.lang.Objects;
import org.zkoss.xel.Function;
import org.zkoss.zk.scripting.Interpreter;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.ext.Scope;
import org.zkoss.zk.ui.ext.Scopes;

public abstract class GenericInterpreter
implements Interpreter {
    public static final Object UNDEFINED = new Object(){

        public String toString() {
            return "undefined";
        }
    };
    private final List<Object> _scopes = new LinkedList<Object>();
    private Page _owner;
    private String _zslang;

    protected GenericInterpreter() {
    }

    protected abstract void exec(String var1);

    protected boolean contains(String name) {
        return this.get(name) != null;
    }

    protected Object get(String name) {
        return null;
    }

    protected void set(String name, Object value) {
    }

    protected void unset(String name) {
    }

    protected boolean contains(Scope scope, String name) {
        return this.get(scope, name) != null;
    }

    protected Object get(Scope scope, String name) {
        return this.get(name);
    }

    protected void set(Scope scope, String name, Object value) {
        this.set(name, value);
    }

    protected void unset(Scope scope, String name) {
        this.unset(name);
    }

    protected void beforeInterpret(Scope scope) {
        this.beforeExec();
        this.push(scope);
    }

    protected void afterInterpret(Scope scope) {
        this.pop();
        this.afterExec();
    }

    protected void beforeExec() {
    }

    protected void afterExec() {
    }

    protected Object getFromNamespace(String name) {
        Scope scope = this.getCurrent();
        if (scope != null) {
            Object val;
            Execution exec = Executions.getCurrent();
            if (exec != null && exec != scope && (val = exec.getAttribute(name)) != null) {
                return val;
            }
            if (scope instanceof Component) {
                Component comp = (Component)scope;
                Object val2 = comp.getAttributeOrFellow(name, true);
                if (val2 != null || comp.hasAttributeOrFellow(name, true)) {
                    return val2;
                }
                Page page = comp.getPage();
                if (page != null && (val2 = page.getXelVariable(null, null, name, true)) != null) {
                    return val2;
                }
            } else if (scope instanceof Page) {
                Page page = (Page)scope;
                Object val3 = page.getAttributeOrFellow(name, true);
                if (val3 != null || page.hasAttributeOrFellow(name, true)) {
                    return val3;
                }
                val3 = page.getXelVariable(null, null, name, true);
                if (val3 != null) {
                    return val3;
                }
            } else {
                val = scope.getAttribute(name, true);
                if (val != null || scope.hasAttribute(name, true)) {
                    return val;
                }
            }
        }
        return GenericInterpreter.getImplicit(name);
    }

    protected static Object getImplicit(String name) {
        return Scopes.getImplicit(name, UNDEFINED);
    }

    protected Object getFromNamespace(Scope scope, String name, boolean recurse) {
        Object val;
        if (this.getCurrent() != null && ((val = scope.getAttribute(name, recurse)) != null || scope.hasAttribute(name, recurse))) {
            return val;
        }
        return GenericInterpreter.getImplicit(name);
    }

    public void init(Page owner, String zslang) {
        this._owner = owner;
        this._zslang = zslang;
    }

    public void destroy() {
        this._owner = null;
    }

    public Page getOwner() {
        return this._owner;
    }

    public String getLanguage() {
        return this._zslang;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interpret(String script, Scope scope) {
        String each = this._owner.getLanguageDefinition().getEachTimeScript(this._zslang);
        if (each != null) {
            script = each + '\n' + script;
        }
        this.beforeInterpret(scope);
        try {
            this.exec(script);
        }
        finally {
            this.afterInterpret(scope);
        }
    }

    public Class getClass(String clsnm) {
        return null;
    }

    public Function getFunction(String name, Class[] argTypes) {
        return null;
    }

    public Function getFunction(Scope scope, String name, Class[] argTypes) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsVariable(String name) {
        this.beforeExec();
        this.push(Objects.UNKNOWN);
        try {
            boolean bl = this.contains(name);
            return bl;
        }
        finally {
            this.pop();
            this.afterExec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getVariable(String name) {
        this.beforeExec();
        this.push(Objects.UNKNOWN);
        try {
            Object object = this.get(name);
            return object;
        }
        finally {
            this.pop();
            this.afterExec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setVariable(String name, Object value) {
        this.beforeExec();
        try {
            this.set(name, value);
        }
        finally {
            this.afterExec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unsetVariable(String name) {
        this.beforeExec();
        try {
            this.unset(name);
        }
        finally {
            this.afterExec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsVariable(Scope scope, String name) {
        this.beforeExec();
        this.push(Objects.UNKNOWN);
        try {
            boolean bl = this.contains(scope, name);
            return bl;
        }
        finally {
            this.pop();
            this.afterExec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getVariable(Scope scope, String name) {
        this.beforeExec();
        this.push(Objects.UNKNOWN);
        try {
            Object object = this.get(scope, name);
            return object;
        }
        finally {
            this.pop();
            this.afterExec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setVariable(Scope scope, String name, Object value) {
        this.beforeExec();
        try {
            this.set(scope, name, value);
        }
        finally {
            this.afterExec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unsetVariable(Scope scope, String name) {
        this.beforeExec();
        try {
            this.unset(scope, name);
        }
        finally {
            this.afterExec();
        }
    }

    private void push(Object scope) {
        this._scopes.add(0, scope);
    }

    private void pop() {
        this._scopes.remove(0);
    }

    protected Scope getCurrent() {
        if (!this._scopes.isEmpty()) {
            Object o = this._scopes.get(0);
            if (o == Objects.UNKNOWN) {
                return null;
            }
            if (o != null) {
                return (Scope)o;
            }
        }
        return Scopes.getCurrent(this._owner);
    }
}

