/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.zkoss.io.Serializables;
import org.zkoss.lang.Library;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Components;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.ext.Macro;
import org.zkoss.zk.ui.sys.ContentRenderer;

public class HtmlMacroComponent
extends HtmlBasedComponent
implements Macro {
    private transient Map<String, Object> _props;
    private String _uri;
    private Component[] _inlines;
    private String _tag = "span";

    public HtmlMacroComponent() {
        this.setAttribute("z$is", Boolean.TRUE);
        this.init();
    }

    private void init() {
        this._props = new LinkedHashMap<String, Object>();
        this._props.put("includer", this);
    }

    public String getWidgetClass() {
        return "zk.Macro";
    }

    public String getEnclosingTag() {
        return this._tag;
    }

    public void setEnclosingTag(String tag) {
        if (tag == null || tag.length() == 0) {
            throw new IllegalArgumentException();
        }
        if (!this._tag.equals(tag)) {
            this._tag = tag;
            this.smartUpdate("enclosingTag", this._tag);
        }
    }

    public void afterCompose() {
        this.compose();
    }

    protected void compose() {
        Execution exec = Executions.getCurrent();
        if (exec == null) {
            throw new IllegalStateException("No execution available");
        }
        if (this.isInline()) {
            if (this._inlines != null) {
                return;
            }
            this._inlines = exec.createComponents(this._uri != null ? this._uri : this.getDefinition().getMacroURI(), this._props);
        } else {
            if (!this.getChildren().isEmpty()) {
                return;
            }
            exec.createComponents(this._uri != null ? this._uri : this.getDefinition().getMacroURI(), (Component)this, this._props);
        }
        if (!"true".equals(Library.getProperty((String)"org.zkoss.zk.ui.macro.autowire.disabled"))) {
            Components.wireVariables(this, (Object)this, '$', true, true);
        }
        if (!"true".equals(Library.getProperty((String)"org.zkoss.zk.ui.macro.autoforward.disabled"))) {
            Components.addForwards(this, this, '$');
        }
    }

    public String getMacroURI() {
        return this._uri != null ? this._uri : this.getDefinition().getMacroURI();
    }

    public void setMacroURI(String uri) {
        if (!Objects.equals((Object)this._uri, (Object)uri)) {
            if (uri != null && uri.length() == 0) {
                throw new IllegalArgumentException("empty");
            }
            this._uri = uri;
            if (this.getParent() != null) {
                this.recreate();
            }
        }
    }

    public void recreate() {
        if (this._inlines != null) {
            for (int j = 0; j < this._inlines.length; ++j) {
                this._inlines[j].detach();
            }
            this._inlines = null;
        } else {
            this.getChildren().clear();
            this.invalidate();
        }
        this.compose();
    }

    public boolean isInline() {
        return this.getDefinition().isInlineMacro();
    }

    public void setParent(Component parent) {
        if (this.isInline()) {
            if (this._inlines == null) {
                this.compose();
            }
            for (int j = 0; j < this._inlines.length; ++j) {
                this._inlines[j].setParent(parent);
            }
        } else {
            super.setParent(parent);
        }
    }

    public boolean setInlineParent(Component parent, Component beforeSibling) {
        if (!this.isInline()) {
            throw new InternalError("inline only");
        }
        if (this._inlines == null) {
            this.compose();
        }
        boolean inserted = false;
        for (int j = 0; j < this._inlines.length; ++j) {
            if (!parent.insertBefore(this._inlines[j], beforeSibling)) continue;
            inserted = true;
        }
        return inserted;
    }

    public void setPage(Page page) {
        if (this.isInline()) {
            if (this._inlines == null) {
                this.compose();
            }
            for (int j = 0; j < this._inlines.length; ++j) {
                this._inlines[j].setPage(page);
            }
        } else {
            super.setPage(page);
        }
    }

    protected boolean isChildable() {
        return !this.isInline();
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        this._props.remove("includer");
        Serializables.smartWrite((ObjectOutputStream)s, this._props);
        this._props.put("includer", this);
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init();
        Serializables.smartRead((ObjectInputStream)s, this._props);
    }

    public Object clone() {
        HtmlMacroComponent clone = (HtmlMacroComponent)super.clone();
        clone.init();
        clone._props.putAll(this._props);
        clone._props.put("includer", clone);
        if (this._inlines != null) {
            clone._inlines = new Component[this._inlines.length];
            for (int j = 0; j < this._inlines.length; ++j) {
                clone._inlines[j] = (Component)this._inlines[j].clone();
            }
        }
        return clone;
    }

    public boolean hasDynamicProperty(String name) {
        return this._props.containsKey(name);
    }

    public Object getDynamicProperty(String name) {
        return this._props.get(name);
    }

    public void setDynamicProperty(String name, Object value) throws WrongValueException {
        this._props.put(name, value);
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (!"span".equals(this._tag)) {
            renderer.render("enclosingTag", this._tag);
        }
    }
}

