/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.http;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.zkoss.idom.Element;
import org.zkoss.idom.util.IDOMs;
import org.zkoss.lang.Classes;
import org.zkoss.util.logging.Log;
import org.zkoss.util.resource.Locator;
import org.zkoss.util.resource.ResourceCache;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.web.util.resource.Extendlet;
import org.zkoss.web.util.resource.ExtendletConfig;
import org.zkoss.web.util.resource.ExtendletContext;
import org.zkoss.web.util.resource.ExtendletLoader;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.http.Provider;
import org.zkoss.zk.ui.http.WebManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractExtendlet<V>
implements Extendlet {
    static final Log log = Log.lookup(AbstractExtendlet.class);
    ExtendletContext _webctx;
    ResourceCache<String, V> _cache;
    private ThreadLocal<Provider> _provider = new ThreadLocal();
    private Boolean _debugJS;

    AbstractExtendlet() {
    }

    public void setDebugJS(boolean debugJS) {
        this._debugJS = debugJS;
        if (this._cache != null) {
            this._cache.clear();
        }
    }

    public boolean isDebugJS() {
        if (this._debugJS == null) {
            WebApp wapp = this.getWebApp();
            if (wapp == null) {
                return true;
            }
            this._debugJS = wapp.getConfiguration().isDebugJS();
        }
        return this._debugJS;
    }

    Provider getProvider() {
        return this._provider.get();
    }

    void setProvider(Provider provider) {
        this._provider.set(provider);
    }

    WebApp getWebApp() {
        return this._webctx != null ? WebManager.getWebManager(this._webctx.getServletContext()).getWebApp() : null;
    }

    ServletContext getServletContext() {
        return this._webctx != null ? this._webctx.getServletContext() : null;
    }

    void init(ExtendletConfig config, ExtendletLoader<V> loader) {
        this._webctx = config.getExtendletContext();
        this._cache = new ResourceCache(loader, 16);
        this._cache.setMaxSize(1024);
        this._cache.setLifetime(3600000);
        int checkPeriod = loader.getCheckPeriod();
        this._cache.setCheckPeriod(checkPeriod >= 0 ? checkPeriod : 3600000);
    }

    static MethodInfo getMethodInfo(Element el) {
        Class cls;
        String clsnm = IDOMs.getRequiredAttributeValue((Element)el, (String)"class");
        String sig = IDOMs.getRequiredAttributeValue((Element)el, (String)"signature");
        try {
            cls = Classes.forNameByThread((String)clsnm);
        }
        catch (ClassNotFoundException ex) {
            log.error("Class not found: " + clsnm + ", " + el.getLocator());
            return null;
        }
        try {
            Method mtd = Classes.getMethodBySignature((Class)cls, (String)sig, null);
            if ((mtd.getModifiers() & 8) == 0) {
                log.error("Not a static method: " + mtd);
                return null;
            }
            Object[] args = new Object[mtd.getParameterTypes().length];
            for (int j = 0; j < args.length; ++j) {
                args[j] = el.getAttributeValue("arg" + j);
            }
            return new MethodInfo(mtd, args);
        }
        catch (ClassNotFoundException ex) {
            log.realCauseBriefly("Unable to load class when resolving " + sig + " " + el.getLocator(), (Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            log.error("Method not found in " + clsnm + ": " + sig + " " + el.getLocator());
        }
        return null;
    }

    String invoke(MethodInfo mi) {
        Provider provider = this.getProvider();
        Class<?>[] argTypes = mi.method.getParameterTypes();
        Object[] args = mi.arguments;
        if (provider != null) {
            for (int j = 0; j < args.length; ++j) {
                if (ServletRequest.class.isAssignableFrom(argTypes[j])) {
                    args[j] = provider.request;
                    continue;
                }
                if (ServletResponse.class.isAssignableFrom(argTypes[j])) {
                    args[j] = provider.response;
                    continue;
                }
                if (!ServletContext.class.isAssignableFrom(argTypes[j])) continue;
                args[j] = this.getServletContext();
            }
        }
        try {
            Object o = mi.method.invoke(null, args);
            return o instanceof String ? (String)o : "";
        }
        catch (Throwable ex) {
            log.error("Unable to invoke " + mi.method, ex);
            return "";
        }
    }

    public boolean getFeature(int feature) {
        return feature == 1;
    }

    InputStream getResourceAsStream(HttpServletRequest request, String path, boolean locate) throws IOException, ServletException {
        if (locate) {
            path = Servlets.locate((ServletContext)this._webctx.getServletContext(), (ServletRequest)request, (String)path, (Locator)this._webctx.getLocator());
        }
        if (this._cache.getCheckPeriod() >= 0) {
            try {
                URL url = this._webctx.getResource(path);
                if (url != null) {
                    return url.openStream();
                }
            }
            catch (Throwable ex) {
                log.warningBriefly("Unable to read from URL: " + path, ex);
            }
        }
        return this._webctx.getResourceAsStream(path);
    }

    URL getResource(String path) throws IOException {
        return this._webctx.getResource(path);
    }

    static class MethodInfo {
        final Method method;
        final Object[] arguments;

        MethodInfo(Method method, Object[] arguments) {
            this.method = method;
            this.arguments = arguments;
        }
    }
}

