/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.http;

import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.zkoss.lang.Library;
import org.zkoss.lang.Objects;
import org.zkoss.util.CollectionsX;
import org.zkoss.util.logging.Log;
import org.zkoss.util.resource.LabelLocator;
import org.zkoss.util.resource.Labels;
import org.zkoss.util.resource.Locator;
import org.zkoss.util.resource.XMLResourcesLocator;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.web.util.resource.ClassWebResource;
import org.zkoss.web.util.resource.Extendlet;
import org.zkoss.web.util.resource.ServletContextLocator;
import org.zkoss.web.util.resource.ServletLabelLocator;
import org.zkoss.web.util.resource.ServletRequestResolver;
import org.zkoss.xel.VariableResolver;
import org.zkoss.zk.device.Devices;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Richlet;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.WebApps;
import org.zkoss.zk.ui.http.DHtmlLayoutServlet;
import org.zkoss.zk.ui.http.SimpleWebApp;
import org.zkoss.zk.ui.http.TemporaryExecution;
import org.zkoss.zk.ui.http.WcsExtendlet;
import org.zkoss.zk.ui.http.WebManagerActivationListener;
import org.zkoss.zk.ui.http.WpdExtendlet;
import org.zkoss.zk.ui.http.ZumlExtendlet;
import org.zkoss.zk.ui.impl.AbstractWebApp;
import org.zkoss.zk.ui.impl.RequestInfoImpl;
import org.zkoss.zk.ui.impl.Utils;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.metainfo.PageDefinitions;
import org.zkoss.zk.ui.sys.ConfigParser;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.ExecutionsCtrl;
import org.zkoss.zk.ui.sys.RequestInfo;
import org.zkoss.zk.ui.sys.SessionsCtrl;
import org.zkoss.zk.ui.sys.UiFactory;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.sys.WebAppFactory;
import org.zkoss.zk.ui.sys.WebAppsCtrl;
import org.zkoss.zk.ui.util.Configuration;

public class WebManager {
    private static final Log log = Log.lookup(WebManager.class);
    static final String ATTR_WEB_MANAGER = "javax.zkoss.zk.ui.WebManager";
    static final String ATTR_DESKTOP = "javax.zkoss.zk.ui.desktop";
    private static final Map<ServletContext, List<WebManagerActivationListener>> _actListeners = new HashMap<ServletContext, List<WebManagerActivationListener>>();
    private final ServletContext _ctx;
    private final WebApp _wapp;
    private final String _updateURI;
    private final ClassWebResource _cwr;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebManager(ServletContext ctx, String updateURI) {
        String[] labellocs;
        if (log.debugable()) {
            log.debug("Starting WebManager at " + ctx);
        }
        if (ctx == null || updateURI == null) {
            throw new IllegalArgumentException("null");
        }
        if (WebManager.getWebManagerIfAny(ctx) != null) {
            throw new UiException("Only one Web manager is allowed in one context: " + ctx);
        }
        log.info("Starting ZK 6.0.0-RC " + WebApps.getEdition() + " (build: " + AbstractWebApp.loadBuild() + ')');
        this._ctx = ctx;
        this._updateURI = updateURI;
        this._ctx.setAttribute(ATTR_WEB_MANAGER, (Object)this);
        Servlets.setBrowserIdentifier((Servlets.BrowserIdentifier)new BrowserIdentifier());
        Configuration config = new Configuration();
        ConfigParser parser = new ConfigParser();
        try {
            parser.parseConfigXml(config);
        }
        catch (Throwable ex) {
            log.error("Unable to load metainfo/zk/config.xml", ex);
        }
        String XML = "metainfo/zk/zk.xml";
        try {
            XMLResourcesLocator loc = Utils.getXMLResourcesLocator();
            Enumeration en = loc.getResources(XML);
            while (en.hasMoreElements()) {
                URL cfgUrl = (URL)en.nextElement();
                try {
                    parser.parse(cfgUrl, config, (Locator)loc);
                }
                catch (Throwable ex) {
                    log.error("Unable to load " + cfgUrl, ex);
                }
            }
        }
        catch (Throwable ex) {
            log.error("Unable to load " + XML, ex);
        }
        XML = "/WEB-INF/zk.xml";
        try {
            URL cfgUrl = this._ctx.getResource(XML);
            if (cfgUrl != null) {
                parser.parse(cfgUrl, config, (Locator)new ServletContextLocator(this._ctx, true));
            }
        }
        catch (Throwable ex) {
            log.realCauseBriefly("Unable to load " + XML, ex);
        }
        XML = Library.getProperty((String)"org.zkoss.zk.config.path");
        if (XML != null && XML.length() > 0) {
            log.info("Parsing " + XML);
            InputStream is = null;
            try {
                is = Servlets.getResourceAsStream((ServletContext)this._ctx, (String)XML);
                if (is != null) {
                    parser.parse(is, config, (Locator)new ServletContextLocator(this._ctx, true));
                } else {
                    log.error("File not found: " + XML);
                }
            }
            catch (Throwable ex) {
                log.realCauseBriefly("Unable to load " + XML, ex);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable t) {}
                }
            }
        }
        this._cwr = ClassWebResource.getInstance((ServletContext)this._ctx, (String)this._updateURI);
        this._cwr.setCompress(new String[]{"js", "css", "html", "xml"});
        String s = Library.getProperty((String)"org.zkoss.web.util.resource.dir");
        if (s != null && s.length() > 0) {
            if (s.charAt(0) != '/') {
                s = '/' + s;
            }
            this._cwr.setExtraLocator((Locator)new ServletContextLocator(this._ctx, null, s));
        }
        if ((labellocs = config.getLabelLocations()).length == 0) {
            Labels.register((LabelLocator)new ServletLabelLocator(this._ctx));
        } else {
            for (int j = 0; j < labellocs.length; ++j) {
                Labels.register((LabelLocator)new ServletLabelLocator(this._ctx, labellocs[j]));
            }
        }
        Labels.setVariableResolver((VariableResolver)new ServletRequestResolver());
        Class cls = config.getWebAppFactoryClass();
        if (cls != null) {
            try {
                this._wapp = ((WebAppFactory)cls.newInstance()).newWebApp(this._ctx, config);
            }
            catch (Exception ex) {
                throw UiException.Aide.wrap((Throwable)ex, "Unable to construct " + cls);
            }
        } else {
            cls = config.getWebAppClass();
            if (cls != null) {
                try {
                    this._wapp = (WebApp)cls.newInstance();
                }
                catch (Exception ex) {
                    throw UiException.Aide.wrap((Throwable)ex, "Unable to construct " + cls);
                }
            } else {
                this._wapp = new SimpleWebApp();
            }
        }
        WebAppsCtrl.setCurrent(this._wapp);
        ((WebAppCtrl)((Object)this._wapp)).init(this._ctx, config);
        this._cwr.setEncodeURLPrefix(this.getCWRURLPrefix());
        this._cwr.setDebugJS(config.isDebugJS());
        this._cwr.addExtendlet("wpd", (Extendlet)new WpdExtendlet());
        this._cwr.addExtendlet("wcs", (Extendlet)new WcsExtendlet());
        ZumlExtendlet extlet = null;
        for (LanguageDefinition langdef : LanguageDefinition.getAll()) {
            List<String> exts = langdef.getExtensions();
            if (exts.isEmpty()) continue;
            if (extlet == null) {
                extlet = new ZumlExtendlet();
            }
            this._cwr.addExtendlet(exts.get(0), (Extendlet)extlet);
        }
        List<WebManagerActivationListener> listeners = _actListeners.remove(this._ctx);
        if (listeners != null) {
            Iterator it = CollectionsX.comodifiableIterator(listeners);
            while (it.hasNext()) {
                try {
                    ((WebManagerActivationListener)it.next()).didActivate(this);
                }
                catch (Throwable ex) {
                    log.realCause(ex);
                }
            }
        }
    }

    private String getCWRURLPrefix() {
        int code = this._wapp.getVersion().hashCode() ^ this._wapp.getBuild().hashCode() ^ WebApps.getEdition().hashCode();
        for (LanguageDefinition langdef : LanguageDefinition.getAll()) {
            for (Map.Entry<String, String> me : langdef.getJavaScriptModules().entrySet()) {
                code ^= Objects.hashCode((Object)me.getKey()) + Objects.hashCode((Object)me.getValue());
            }
            Iterator<Object> e = langdef.getMergedJavaScriptPackages("zk").iterator();
            while (e.hasNext()) {
                code ^= Objects.hashCode((Object)e.next());
            }
        }
        return Integer.toHexString(code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            ((WebAppCtrl)((Object)this._wapp)).destroy();
        }
        finally {
            this._ctx.removeAttribute(ATTR_WEB_MANAGER);
            WebAppsCtrl.setCurrent(null);
        }
    }

    public final ClassWebResource getClassWebResource() {
        return this._cwr;
    }

    public String getUpdateURI() {
        return this._updateURI;
    }

    public final WebApp getWebApp() {
        return this._wapp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void addActivationListener(ServletContext ctx, WebManagerActivationListener listener) {
        if (ctx == null || listener == null) {
            throw new IllegalArgumentException("null");
        }
        WebManager webman = WebManager.getWebManagerIfAny(ctx);
        if (webman != null) {
            listener.didActivate(webman);
            return;
        }
        Class<WebManager> clazz = WebManager.class;
        synchronized (WebManager.class) {
            List<WebManagerActivationListener> l = _actListeners.get(ctx);
            if (l == null) {
                l = new LinkedList<WebManagerActivationListener>();
                _actListeners.put(ctx, l);
            }
            l.add(listener);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public static final WebManager getWebManager(ServletContext ctx) {
        WebManager webman = WebManager.getWebManagerIfAny(ctx);
        if (webman == null) {
            throw new UiException("The Web manager not found. Make sure <load-on-startup> is specified for " + DHtmlLayoutServlet.class.getName());
        }
        return webman;
    }

    public static final WebManager getWebManager(WebApp wapp) {
        return WebManager.getWebManager((ServletContext)wapp.getNativeContext());
    }

    public static final WebManager getWebManagerIfAny(ServletContext ctx) {
        return (WebManager)ctx.getAttribute(ATTR_WEB_MANAGER);
    }

    public static final WebManager getWebManagerIfAny(WebApp wapp) {
        return WebManager.getWebManagerIfAny((ServletContext)wapp.getNativeContext());
    }

    public static final WebApp getWebApp(ServletContext ctx) {
        WebApp wapp;
        WebManager webman = WebManager.getWebManagerIfAny(ctx);
        WebApp webApp = wapp = webman != null ? webman.getWebApp() : null;
        if (wapp == null) {
            throw new UiException("The Web application not found. Make sure <load-on-startup> is specified for " + DHtmlLayoutServlet.class.getName());
        }
        return wapp;
    }

    public static final WebApp getWebAppIfAny(ServletContext ctx) {
        WebManager webman = WebManager.getWebManagerIfAny(ctx);
        return webman != null ? webman.getWebApp() : null;
    }

    public static final Session getSession(ServletContext ctx, HttpServletRequest request) {
        return WebManager.getSession(ctx, request.getSession(), request);
    }

    public static final Session getSession(ServletContext ctx, HttpServletRequest request, boolean create) {
        HttpSession hsess = request.getSession(create);
        return hsess != null ? WebManager.getSession(ctx, hsess, request) : null;
    }

    private static final Session getSession(ServletContext ctx, HttpSession hsess, HttpServletRequest request) {
        WebApp wapp = WebManager.getWebManager(ctx).getWebApp();
        Session sess = SessionsCtrl.getSession(wapp, hsess);
        return sess != null ? sess : SessionsCtrl.newSession(wapp, hsess, request);
    }

    static final void sessionDestroyed(HttpSession hsess) {
        WebApp wapp;
        Session sess;
        WebManager webman = WebManager.getWebManagerIfAny(hsess.getServletContext());
        if (webman != null && (sess = SessionsCtrl.getSession(wapp = webman.getWebApp(), hsess)) != null) {
            ((WebAppCtrl)((Object)wapp)).sessionDestroyed(sess);
        }
    }

    public Desktop getDesktop(Session sess, ServletRequest request, ServletResponse response, String path, boolean autocreate) {
        Desktop desktop = (Desktop)request.getAttribute(ATTR_DESKTOP);
        if (desktop == null && autocreate) {
            if (log.debugable()) {
                log.debug("Create desktop for " + path);
            }
            desktop = this.newDesktop(sess, request, response, path);
            request.setAttribute(ATTR_DESKTOP, (Object)desktop);
        }
        return desktop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Desktop newDesktop(Session sess, ServletRequest request, ServletResponse response, String path) {
        Locator loc = PageDefinitions.getLocator(this._wapp, path);
        Execution exec = ExecutionsCtrl.getCurrent();
        TemporaryExecution de = new TemporaryExecution(this._ctx, (HttpServletRequest)request, (HttpServletResponse)response, null);
        ExecutionsCtrl.setCurrent(de);
        try {
            Desktop desktop = ((WebAppCtrl)((Object)this._wapp)).getUiFactory().newDesktop(new RequestInfoImpl(this._wapp, sess, null, request, loc), this._updateURI, path);
            Desktop desktop2 = !de.isVoided() ? desktop : null;
            return desktop2;
        }
        finally {
            ExecutionsCtrl.setCurrent(exec);
        }
    }

    public static void setDesktop(HttpServletRequest request, Desktop desktop) {
        request.setAttribute(ATTR_DESKTOP, (Object)desktop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Page newPage(UiFactory uf, RequestInfo ri, PageDefinition pagedef, ServletResponse response, String path) {
        DesktopCtrl desktopCtrl = (DesktopCtrl)((Object)ri.getDesktop());
        Execution exec = ExecutionsCtrl.getCurrent();
        TemporaryExecution de = new TemporaryExecution((ServletContext)ri.getWebApp().getNativeContext(), (HttpServletRequest)ri.getNativeRequest(), (HttpServletResponse)response, ri.getDesktop());
        desktopCtrl.setExecution(de);
        ExecutionsCtrl.setCurrent(de);
        try {
            Page page = uf.newPage(ri, pagedef, path);
            return page;
        }
        finally {
            ExecutionsCtrl.setCurrent(exec);
            desktopCtrl.setExecution(exec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Page newPage(UiFactory uf, RequestInfo ri, Richlet richlet, ServletResponse response, String path) {
        DesktopCtrl desktopCtrl = (DesktopCtrl)((Object)ri.getDesktop());
        Execution exec = ExecutionsCtrl.getCurrent();
        TemporaryExecution de = new TemporaryExecution((ServletContext)ri.getWebApp().getNativeContext(), (HttpServletRequest)ri.getNativeRequest(), (HttpServletResponse)response, ri.getDesktop());
        desktopCtrl.setExecution(de);
        ExecutionsCtrl.setCurrent(de);
        try {
            Page page = uf.newPage(ri, richlet, path);
            return page;
        }
        finally {
            ExecutionsCtrl.setCurrent(exec);
            desktopCtrl.setExecution(exec);
        }
    }

    private static class BrowserIdentifier
    implements Servlets.BrowserIdentifier {
        private BrowserIdentifier() {
        }

        public boolean isBrowser(String userAgent, String type) {
            return Devices.isClient(userAgent, type);
        }
    }
}

