/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.zkoss.io.Serializables;
import org.zkoss.lang.ClassResolver;
import org.zkoss.lang.ImportedClassResolver;
import org.zkoss.lang.Library;
import org.zkoss.lang.Objects;
import org.zkoss.lang.SimpleClassResolver;
import org.zkoss.lang.Strings;
import org.zkoss.util.CollectionsX;
import org.zkoss.util.DualCollection;
import org.zkoss.util.logging.Log;
import org.zkoss.xel.ExpressionFactory;
import org.zkoss.xel.Function;
import org.zkoss.xel.FunctionMapper;
import org.zkoss.xel.FunctionMapperExt;
import org.zkoss.xel.VariableResolver;
import org.zkoss.xel.XelContext;
import org.zkoss.xel.XelException;
import org.zkoss.xel.util.Evaluators;
import org.zkoss.zk.au.out.AuSetTitle;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.scripting.HierachicalAware;
import org.zkoss.zk.scripting.Interpreter;
import org.zkoss.zk.scripting.InterpreterNotFoundException;
import org.zkoss.zk.scripting.Interpreters;
import org.zkoss.zk.scripting.SerializableAware;
import org.zkoss.zk.ui.AbstractPage;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Richlet;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.ext.Includer;
import org.zkoss.zk.ui.ext.Scope;
import org.zkoss.zk.ui.ext.ScopeListener;
import org.zkoss.zk.ui.ext.Scopes;
import org.zkoss.zk.ui.impl.SimpleScope;
import org.zkoss.zk.ui.metainfo.ComponentDefinition;
import org.zkoss.zk.ui.metainfo.ComponentDefinitionMap;
import org.zkoss.zk.ui.metainfo.DefinitionNotFoundException;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.metainfo.ZScript;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.ExecutionCtrl;
import org.zkoss.zk.ui.sys.ExecutionsCtrl;
import org.zkoss.zk.ui.sys.PageConfig;
import org.zkoss.zk.ui.sys.PageRenderer;
import org.zkoss.zk.ui.sys.UiEngine;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.Condition;
import org.zkoss.zk.ui.util.PageActivationListener;
import org.zkoss.zk.ui.util.PageSerializationListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageImpl
extends AbstractPage
implements Serializable {
    private static final Log log = Log.lookup(PageImpl.class);
    private static final long serialVersionUID = 20110726L;
    private transient Component _owner;
    private transient String _ownerUuid;
    private transient Desktop _desktop;
    private String _id = "";
    private String _uuid;
    private String _title = "";
    private String _style = "";
    private String _path;
    private String _zslang;
    private List<Object[]> _zsDeferred;
    private transient SimpleScope _attrs;
    private transient Map<String, List<EventListener<? extends Event>>> _listeners;
    private final ComponentDefinitionMap _compdefs;
    private transient LanguageDefinition _langdef;
    private String _hdbfr = "";
    private String _hdaft = "";
    private Collection<Object[]> _hdres;
    private String _rootAttrs = "";
    private String _contentType;
    private String _docType;
    private String _firstLine;
    private String _wgtcls;
    private Boolean _cacheable;
    private Boolean _autoTimeout;
    private Class<? extends ExpressionFactory> _expfcls;
    private transient Map<String, Interpreter> _ips;
    private final FunctionMapper _mapper = new PageFuncMapper();
    private transient List<FunctionMapper> _mappers;
    private transient List<VariableResolver> _resolvers;
    private ClassResolver _clsresolver;
    private boolean _clsresolverShared;
    private boolean _complete;
    private static Boolean dupListenerIgnored;
    private static Boolean _ie7compat;

    public PageImpl(PageDefinition pgdef) {
        this.constr(pgdef.getLanguageDefinition(), pgdef.getRequestPath(), pgdef.getZScriptLanguage());
        this._compdefs = pgdef.getComponentDefinitionMap();
        this._clsresolver = pgdef.getImportedClassResolver();
        this._clsresolverShared = true;
    }

    public PageImpl(LanguageDefinition langdef, ComponentDefinitionMap compdefs, String path, String zslang) {
        this.constr(langdef, path, zslang);
        this._compdefs = compdefs != null ? compdefs : new ComponentDefinitionMap(this._langdef.getComponentDefinitionMap().isCaseInsensitive());
        this._clsresolver = new SimpleClassResolver();
    }

    public PageImpl(Page ref) {
        this(ref.getLanguageDefinition(), ref.getComponentDefinitionMap(), ref.getRequestPath(), ref.getZScriptLanguage());
    }

    public PageImpl(Richlet richlet, String path) {
        this.constr(richlet.getLanguageDefinition(), path, null);
        this._compdefs = new ComponentDefinitionMap(this._langdef.getComponentDefinitionMap().isCaseInsensitive());
        this._clsresolver = new SimpleClassResolver();
    }

    private void constr(LanguageDefinition langdef, String path, String zslang) {
        this.init();
        this._langdef = langdef;
        this._path = path != null ? path : "";
        this._zslang = zslang != null ? zslang : "Java";
    }

    protected void init() {
        this._ips = new LinkedHashMap<String, Interpreter>(2);
        this._attrs = new SimpleScope(this);
    }

    private final UiEngine getUiEngine() {
        return ((WebAppCtrl)((Object)this._desktop.getWebApp())).getUiEngine();
    }

    private final Execution getExecution() {
        return this._desktop != null ? this._desktop.getExecution() : Executions.getCurrent();
    }

    @Override
    public final FunctionMapper getFunctionMapper() {
        return this._mapper;
    }

    @Override
    public boolean addFunctionMapper(FunctionMapper mapper) {
        if (mapper == null) {
            return false;
        }
        if (this._mappers == null) {
            this._mappers = new LinkedList<FunctionMapper>();
        } else if (this._mappers.contains(mapper)) {
            return false;
        }
        this._mappers.add(0, mapper);
        return true;
    }

    @Override
    public boolean removeFunctionMapper(FunctionMapper mapper) {
        return this._mappers != null && this._mappers.remove(mapper);
    }

    @Override
    public boolean hasFunctionMapper(FunctionMapper mapper) {
        return this._mappers != null && this._mappers.contains(mapper);
    }

    @Override
    public String getRequestPath() {
        return this._path;
    }

    @Override
    public final String getId() {
        return this._id;
    }

    @Override
    public final String getUuid() {
        return this._uuid;
    }

    @Override
    public void setId(String id) {
        if (this._desktop != null && this._desktop.getPages().contains(this)) {
            throw new UiException("ID cannot be changed after initialized");
        }
        this._id = id != null ? id : "";
    }

    @Override
    public String getTitle() {
        return this._title;
    }

    @Override
    public void setTitle(String title) {
        if (title == null) {
            title = "";
        }
        if (!this._title.equals(title)) {
            this._title = title;
            if (this._desktop != null) {
                Execution exec = this.getExecution();
                if (this._title.length() > 0) {
                    this._title = (String)exec.evaluate(this, this._title, String.class);
                    if (this._title == null) {
                        this._title = "";
                    }
                }
                if (exec.isAsyncUpdate(this)) {
                    this.getUiEngine().addResponse(new AuSetTitle(this._title));
                }
            }
        }
    }

    @Override
    public String getStyle() {
        return this._style;
    }

    @Override
    public void setStyle(String style) {
        if (style == null) {
            style = "";
        }
        if (!this._style.equals(style)) {
            this._style = style;
            if (this._desktop != null) {
                Execution exec = this.getExecution();
                if (this._style.length() > 0) {
                    this._style = (String)exec.evaluate(this, this._style, String.class);
                    if (this._style == null) {
                        this._style = "";
                    }
                }
            }
        }
    }

    @Override
    public Map<String, Object> getAttributes(int scope) {
        switch (scope) {
            case 3: {
                if (this._desktop == null) break;
                return this._desktop.getAttributes();
            }
            case 4: {
                if (this._desktop == null) break;
                return this._desktop.getSession().getAttributes();
            }
            case 5: {
                if (this._desktop != null) {
                    return this._desktop.getWebApp().getAttributes();
                }
            }
            case 2: {
                return this._attrs.getAttributes();
            }
            case 6: {
                Execution exec = this.getExecution();
                if (exec == null) break;
                return exec.getAttributes();
            }
        }
        return Collections.emptyMap();
    }

    @Override
    public Object getAttribute(String name, int scope) {
        return this.getAttributes(scope).get(name);
    }

    @Override
    public boolean hasAttribute(String name, int scope) {
        return this.getAttributes(scope).containsKey(name);
    }

    @Override
    public Object setAttribute(String name, Object value, int scope) {
        Map<String, Object> attrs = this.getAttributes(scope);
        if (attrs == Collections.EMPTY_MAP) {
            throw new IllegalStateException("This component doesn't belong to any ID space: " + this);
        }
        return attrs.put(name, value);
    }

    @Override
    public Object removeAttribute(String name, int scope) {
        Map<String, Object> attrs = this.getAttributes(scope);
        if (attrs == Collections.EMPTY_MAP) {
            throw new IllegalStateException("This component doesn't belong to any ID space: " + this);
        }
        return attrs.remove(name);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this._attrs.getAttributes();
    }

    @Override
    public Object getAttribute(String name) {
        return this._attrs.getAttribute(name);
    }

    @Override
    public boolean hasAttribute(String name) {
        return this._attrs.hasAttribute(name);
    }

    @Override
    public Object setAttribute(String name, Object value) {
        return this._attrs.setAttribute(name, value);
    }

    @Override
    public Object removeAttribute(String name) {
        return this._attrs.removeAttribute(name);
    }

    @Override
    public Object getAttribute(String name, boolean recurse) {
        Object val = this.getAttribute(name);
        return val != null || !recurse || this.hasAttribute(name) ? val : (this._desktop != null ? this._desktop.getAttribute(name, true) : null);
    }

    @Override
    public boolean hasAttribute(String name, boolean recurse) {
        return this.hasAttribute(name) || recurse && this._desktop != null && this._desktop.hasAttribute(name, true);
    }

    @Override
    public Object setAttribute(String name, Object value, boolean recurse) {
        if (recurse && !this.hasAttribute(name) && this._desktop != null && this._desktop.hasAttribute(name, true)) {
            return this._desktop.setAttribute(name, value, true);
        }
        return this.setAttribute(name, value);
    }

    @Override
    public Object removeAttribute(String name, boolean recurse) {
        if (recurse && !this.hasAttribute(name)) {
            if (this._desktop != null && this._desktop.hasAttribute(name, true)) {
                return this._desktop.removeAttribute(name, true);
            }
            return null;
        }
        return this.removeAttribute(name);
    }

    @Override
    public Object getAttributeOrFellow(String name, boolean recurse) {
        Object val = this.getAttribute(name);
        if (val != null || this.hasAttribute(name)) {
            return val;
        }
        val = this.getFellowIfAny(name);
        if (val != null) {
            return val;
        }
        return recurse && this._desktop != null ? this._desktop.getAttribute(name, true) : null;
    }

    @Override
    public boolean hasAttributeOrFellow(String name, boolean recurse) {
        return this.hasAttribute(name) || this.hasFellow(name) || recurse && this._desktop != null && this._desktop.hasAttribute(name, true);
    }

    @Override
    public boolean addScopeListener(ScopeListener listener) {
        return this._attrs.addScopeListener(listener);
    }

    @Override
    public boolean removeScopeListener(ScopeListener listener) {
        return this._attrs.removeScopeListener(listener);
    }

    @Override
    public void invalidate() {
        this.getUiEngine().addInvalidate(this);
    }

    @Override
    public boolean addClassResolver(ClassResolver resolver) {
        if (resolver == null) {
            return false;
        }
        if (!(resolver instanceof SimpleClassResolver)) {
            if (!(resolver instanceof ImportedClassResolver)) {
                throw new UnsupportedOperationException("Only ImportedClassResolver supported");
            }
            if (this._clsresolver instanceof SimpleClassResolver) {
                this._clsresolver = resolver;
                this._clsresolverShared = true;
            } else {
                ImportedClassResolver cur = (ImportedClassResolver)this._clsresolver;
                if (this._clsresolverShared) {
                    ImportedClassResolver newcr = new ImportedClassResolver();
                    newcr.addAll(cur);
                    this._clsresolver = newcr;
                    this._clsresolverShared = false;
                }
                cur.addAll((ImportedClassResolver)resolver);
            }
        }
        return true;
    }

    @Override
    public Class<?> resolveClass(String clsnm) throws ClassNotFoundException {
        try {
            return this._clsresolver.resolveClass(clsnm);
        }
        catch (ClassNotFoundException ex) {
            Class<?> cls = this.getZScriptClass(clsnm);
            if (cls != null) {
                return cls;
            }
            throw ex;
        }
    }

    @Override
    public Class<?> getZScriptClass(String clsnm) {
        for (Interpreter ip : this.getLoadedInterpreters()) {
            Class<?> cls = ip.getClass(clsnm);
            if (cls == null) continue;
            return cls;
        }
        return null;
    }

    @Override
    public Function getZScriptFunction(String name, Class[] argTypes) {
        for (Interpreter ip : this.getLoadedInterpreters()) {
            Function mtd = ip.getFunction(name, argTypes);
            if (mtd == null) continue;
            return mtd;
        }
        return null;
    }

    @Override
    public Function getZScriptFunction(Component comp, String name, Class[] argTypes) {
        for (Interpreter ip : this.getLoadedInterpreters()) {
            Function mtd = ip instanceof HierachicalAware ? ((HierachicalAware)((Object)ip)).getFunction(comp, name, argTypes) : ip.getFunction(name, argTypes);
            if (mtd == null) continue;
            return mtd;
        }
        return null;
    }

    @Override
    public Object getZScriptVariable(String name) {
        for (Interpreter ip : this.getLoadedInterpreters()) {
            Object val = ip.getVariable(name);
            if (val == null) continue;
            return val;
        }
        return null;
    }

    @Override
    public Object getZScriptVariable(Component comp, String name) {
        for (Interpreter ip : this.getLoadedInterpreters()) {
            Object val = ip instanceof HierachicalAware ? ((HierachicalAware)((Object)ip)).getVariable(comp, name) : ip.getVariable(name);
            if (val == null) continue;
            return val;
        }
        return null;
    }

    @Override
    public Object getXelVariable(String name) {
        return this.getXelVariable(null, null, name, false);
    }

    @Override
    public Object getXelVariable(XelContext ctx, Object base, Object name, boolean ignoreExec) {
        Execution exec;
        if (!ignoreExec && (exec = this.getExecution()) != null) {
            return Evaluators.resolveVariable((XelContext)ctx, (VariableResolver)exec.getVariableResolver(), (Object)base, (Object)name);
        }
        if (this._resolvers != null) {
            Iterator it = CollectionsX.comodifiableIterator(this._resolvers);
            while (it.hasNext()) {
                Object o = Evaluators.resolveVariable((XelContext)ctx, (VariableResolver)((VariableResolver)it.next()), (Object)base, (Object)name);
                if (o == null) continue;
                return o;
            }
        }
        return null;
    }

    @Override
    public boolean addVariableResolver(VariableResolver resolver) {
        if (resolver == null) {
            return false;
        }
        if (this._resolvers == null) {
            this._resolvers = new LinkedList<VariableResolver>();
        } else if (this._resolvers.contains(resolver)) {
            return false;
        }
        this._resolvers.add(0, resolver);
        return true;
    }

    @Override
    public boolean removeVariableResolver(VariableResolver resolver) {
        return this._resolvers != null && this._resolvers.remove(resolver);
    }

    @Override
    public boolean hasVariableResolver(VariableResolver resolver) {
        return this._resolvers != null && this._resolvers.contains(resolver);
    }

    @Override
    public boolean addEventListener(String evtnm, EventListener<? extends Event> listener) {
        List<EventListener<? extends Event>> l;
        if (evtnm == null || listener == null) {
            throw new IllegalArgumentException("null");
        }
        if (!Events.isValid(evtnm)) {
            throw new IllegalArgumentException("Invalid event name: " + evtnm);
        }
        if (this._listeners == null) {
            this._listeners = new HashMap<String, List<EventListener<? extends Event>>>(2);
        }
        if ((l = this._listeners.get(evtnm)) != null) {
            if (PageImpl.duplicateListenerIgnored()) {
                for (EventListener<? extends Event> li : l) {
                    if (!listener.equals(li)) continue;
                    return false;
                }
            }
        } else {
            l = new LinkedList<EventListener<? extends Event>>();
            this._listeners.put(evtnm, l);
        }
        l.add(listener);
        return true;
    }

    @Override
    public boolean removeEventListener(String evtnm, EventListener<? extends Event> listener) {
        List<EventListener<? extends Event>> ls;
        if (evtnm == null || listener == null) {
            throw new NullPointerException();
        }
        if (this._listeners != null && (ls = this._listeners.get(evtnm)) != null) {
            Iterator<EventListener<? extends Event>> it = ls.iterator();
            while (it.hasNext()) {
                EventListener<? extends Event> li = it.next();
                if (!listener.equals(li)) continue;
                if (ls.size() == 1) {
                    this._listeners.remove(evtnm);
                } else {
                    it.remove();
                }
                return true;
            }
        }
        return false;
    }

    private static boolean duplicateListenerIgnored() {
        if (dupListenerIgnored == null) {
            dupListenerIgnored = "true".equals(Library.getProperty((String)"org.zkoss.zk.ui.EventListener.duplicateIgnored"));
        }
        return dupListenerIgnored;
    }

    @Override
    public boolean isComplete() {
        return this._complete;
    }

    @Override
    public void setComplete(boolean complete) {
        this._complete = complete;
    }

    @Override
    public void preInit() {
        if (this._desktop != null) {
            throw new IllegalStateException("init twice");
        }
        Execution exec = Executions.getCurrent();
        this._desktop = exec.getDesktop();
        if (this._desktop == null) {
            throw new IllegalArgumentException("null desktop");
        }
        this._desktop.getWebApp().getConfiguration().init(this);
    }

    @Override
    public void init(PageConfig config) {
        String s;
        Execution exec = Executions.getCurrent();
        if (((ExecutionCtrl)((Object)exec)).isRecovering()) {
            String uuid = config.getUuid();
            String id = config.getId();
            if (uuid == null || id == null) {
                throw new IllegalArgumentException("both id and uuid are required in recovering");
            }
            this._uuid = uuid;
            this._id = id;
        } else {
            this._uuid = ((DesktopCtrl)((Object)this._desktop)).getNextUuid(this);
            if (this._id == null || this._id.length() == 0) {
                this._id = config.getId();
            }
            if (this._id != null) {
                this._id = (String)exec.evaluate(this, this._id, String.class);
            }
            if (this._id == null) {
                this._id = "";
            } else if (this._id.length() != 0) {
                String INVALID = ".&\\%";
                if (Strings.anyOf((String)this._id, (String)".&\\%", (int)0) < this._id.length()) {
                    throw new IllegalArgumentException("Invalid page ID: " + this._id + ". Invalid characters: " + ".&\\%");
                }
            }
        }
        ((DesktopCtrl)((Object)this._desktop)).addPage(this);
        if (this._title.length() == 0 && (s = config.getTitle()) != null) {
            this.setTitle(s);
        }
        if (this._style.length() == 0 && (s = config.getStyle()) != null) {
            this.setStyle(s);
        }
        if ((s = config.getBeforeHeadTags()) != null) {
            this._hdbfr = s;
        }
        if ((s = config.getAfterHeadTags()) != null) {
            this._hdaft = s;
        }
        this._hdres = config.getResponseHeaders();
        if (this._hdres.isEmpty()) {
            this._hdres = null;
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        try {
            if (this._ips != null) {
                ArrayList<Interpreter> ips = new ArrayList<Interpreter>(this._ips.values());
                this._ips.clear();
                this._ips = null;
                for (Interpreter ip : ips) {
                    try {
                        ip.destroy();
                    }
                    catch (Throwable ex) {
                        log.warning("Failed to destroy " + ip, ex);
                    }
                }
            }
        }
        catch (Throwable ex) {
            log.warning("Failed to clean up interpreters of " + this, ex);
        }
        this._desktop = null;
        this._owner = null;
        this._listeners = null;
        this._resolvers = null;
        this._mappers = null;
        this._attrs.getAttributes().clear();
    }

    @Override
    public boolean isAlive() {
        return this._ips != null;
    }

    @Override
    public String getBeforeHeadTags() {
        return this._hdbfr;
    }

    @Override
    public String getAfterHeadTags() {
        return this._hdaft;
    }

    @Override
    public void addBeforeHeadTags(String tags) {
        if (tags != null && tags.length() > 0) {
            this._hdbfr = this._hdbfr + '\n' + tags;
        }
    }

    @Override
    public void addAfterHeadTags(String tags) {
        if (tags != null && tags.length() > 0) {
            this._hdaft = this._hdaft + '\n' + tags;
        }
    }

    @Override
    public Collection<Object[]> getResponseHeaders() {
        if (this._hdres != null) {
            return this._hdres;
        }
        return Collections.emptyList();
    }

    @Override
    public String getRootAttributes() {
        return this._rootAttrs;
    }

    @Override
    public void setRootAttributes(String rootAttrs) {
        this._rootAttrs = rootAttrs != null ? rootAttrs : "";
    }

    @Override
    public String getContentType() {
        return this._contentType;
    }

    @Override
    public void setContentType(String contentType) {
        this._contentType = contentType;
    }

    @Override
    public String getWidgetClass() {
        return this._wgtcls;
    }

    @Override
    public void setWidgetClass(String wgtcls) {
        this._wgtcls = wgtcls != null && wgtcls.length() > 0 ? wgtcls : null;
    }

    @Override
    public String getDocType() {
        return this._docType;
    }

    @Override
    public void setDocType(String docType) {
        this._docType = docType;
    }

    @Override
    public String getFirstLine() {
        return this._firstLine;
    }

    @Override
    public void setFirstLine(String firstLine) {
        this._firstLine = firstLine;
    }

    @Override
    public Boolean getCacheable() {
        return this._cacheable;
    }

    @Override
    public void setCacheable(Boolean cacheable) {
        this._cacheable = cacheable;
    }

    @Override
    public Boolean getAutomaticTimeout() {
        return this._autoTimeout;
    }

    @Override
    public void setAutomaticTimeout(Boolean autoTimeout) {
        this._autoTimeout = autoTimeout;
    }

    @Override
    public final Desktop getDesktop() {
        return this._desktop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void redraw(Writer out) throws IOException {
        Execution exec;
        block14: {
            String ctl;
            exec = this.getExecution();
            boolean au = exec.isAsyncUpdate(null);
            if (!(au || exec.isIncluded() || (ctl = ExecutionsCtrl.getPageRedrawControl(exec)) != null && !"desktop".equals(ctl))) {
                boolean cacheable;
                if (!au && PageImpl.shallIE7Compatible()) {
                    try {
                        if (exec.isBrowser("ie8") && !exec.containsResponseHeader("X-UA-Compatible")) {
                            exec.setResponseHeader("X-UA-Compatible", "IE=EmulateIE7");
                        }
                    }
                    catch (Throwable ex) {
                        // empty catch block
                    }
                }
                boolean bl = cacheable = this._cacheable != null ? this._cacheable.booleanValue() : this._desktop.getDevice().isCacheable();
                if (!cacheable) {
                    exec.setResponseHeader("Pragma", "no-cache");
                    exec.addResponseHeader("Cache-Control", "no-cache");
                    exec.addResponseHeader("Cache-Control", "no-store");
                    exec.setResponseHeader("Expires", "-1");
                    exec.setAttribute("org.zkoss.zk.desktop.nocache", Boolean.TRUE);
                }
                if (this._hdres != null) {
                    for (Object[] vals : this._hdres) {
                        String nm = (String)vals[0];
                        Object val = vals[1];
                        boolean add = (Boolean)vals[2];
                        if (val instanceof Date) {
                            if (add) {
                                exec.addResponseHeader(nm, (Date)val);
                                continue;
                            }
                            exec.setResponseHeader(nm, (Date)val);
                            continue;
                        }
                        if (add) {
                            exec.addResponseHeader(nm, (String)val);
                            continue;
                        }
                        exec.setResponseHeader(nm, (String)val);
                    }
                }
            }
            PageRenderer renderer = (PageRenderer)exec.getAttribute("org.zkoss.zk.ui.page.renderer");
            Object oldrendering = exec.setAttribute("org.zkoss.zk.ui.page.rendering", Boolean.TRUE);
            try {
                (renderer != null ? renderer : this._langdef.getPageRenderer()).render(this, out);
                Object var12_13 = null;
                if (oldrendering == null) break block14;
                exec.setAttribute("org.zkoss.zk.ui.page.rendering", oldrendering);
                return;
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                if (oldrendering != null) {
                    exec.setAttribute("org.zkoss.zk.ui.page.rendering", oldrendering);
                    throw throwable;
                }
                exec.removeAttribute("org.zkoss.zk.ui.page.rendering");
                throw throwable;
            }
        }
        exec.removeAttribute("org.zkoss.zk.ui.page.rendering");
    }

    private static boolean shallIE7Compatible() {
        if (_ie7compat == null) {
            _ie7compat = "true".equals(Library.getProperty((String)"org.zkoss.zk.ui.EmulateIE7"));
        }
        return _ie7compat;
    }

    @Override
    public void interpret(String zslang, String script, Scope scope) {
        if (script != null && script.length() > 0) {
            this.getInterpreter(zslang).interpret(script, scope);
        }
    }

    @Override
    public Interpreter getInterpreter(String zslang) {
        Interpreter ip = this._ips.get(zslang = (zslang != null ? zslang : this._zslang).toLowerCase());
        if (ip == null) {
            if (!this._desktop.getWebApp().getConfiguration().isZScriptEnabled()) {
                throw new UiException("zscript is not allowed since <disable-zscript> is configured");
            }
            ip = Interpreters.newInterpreter(zslang, this);
            this._ips.put(zslang, ip);
            String script = this._langdef.getInitScript(zslang);
            if (script != null) {
                ip.interpret(script, this);
            }
        }
        this.evalDeferredZScripts(ip, zslang);
        return ip;
    }

    @Override
    public Collection<Interpreter> getLoadedInterpreters() {
        if (this._ips != null) {
            return this._ips.values();
        }
        return Collections.emptyList();
    }

    @Override
    public String getZScriptLanguage() {
        return this._zslang;
    }

    @Override
    public void setZScriptLanguage(String zslang) throws InterpreterNotFoundException {
        if (!Objects.equals((Object)zslang, (Object)this._zslang)) {
            if (!Interpreters.exists(zslang)) {
                throw new InterpreterNotFoundException(zslang, MZk.NOT_FOUND, zslang);
            }
            this._zslang = zslang;
        }
    }

    @Override
    public void addDeferredZScript(Component parent, ZScript zscript) {
        if (zscript != null) {
            if (this._zsDeferred == null) {
                this._zsDeferred = new LinkedList<Object[]>();
            }
            this._zsDeferred.add(new Object[]{parent, zscript});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evalDeferredZScripts(Interpreter ip, String zslang) {
        if (this._zsDeferred != null) {
            Iterator<Object[]> it = this._zsDeferred.iterator();
            while (it.hasNext()) {
                Object var10_9;
                Object[] zsInfo = it.next();
                ZScript zscript = (ZScript)zsInfo[1];
                String targetlang = zscript.getLanguage();
                if (targetlang == null) {
                    targetlang = this._zslang;
                }
                if (!targetlang.equalsIgnoreCase(zslang)) continue;
                it.remove();
                Component parent = (Component)zsInfo[0];
                if (parent != null && parent.getPage() != this) continue;
                Scope scope = Scopes.beforeInterpret(parent != null ? parent : this);
                try {
                    ip.interpret(zscript.getContent(this, parent), scope);
                    var10_9 = null;
                }
                catch (Throwable throwable) {
                    var10_9 = null;
                    Scopes.afterInterpret();
                    throw throwable;
                }
                Scopes.afterInterpret();
                {
                }
            }
            if (this._zsDeferred.isEmpty()) {
                this._zsDeferred = null;
            }
        }
    }

    private boolean isEffective(Condition cond, Component comp) {
        return comp != null ? cond.isEffective(comp) : cond.isEffective(this);
    }

    @Override
    public boolean isListenerAvailable(String evtnm) {
        if (this._listeners != null) {
            List<EventListener<? extends Event>> ls = this._listeners.get(evtnm);
            return ls != null && !ls.isEmpty();
        }
        return false;
    }

    @Override
    public Iterator<EventListener<? extends Event>> getListenerIterator(String evtnm) {
        List<EventListener<? extends Event>> l;
        if (this._listeners != null && (l = this._listeners.get(evtnm)) != null) {
            return CollectionsX.comodifiableIterator(l);
        }
        return CollectionsX.emptyIterator();
    }

    @Override
    public Iterable<EventListener<? extends Event>> getEventListeners(String evtnm) {
        List<EventListener<? extends Event>> l;
        if (this._listeners != null && (l = this._listeners.get(evtnm)) != null) {
            return new Iterable<EventListener<? extends Event>>(){

                @Override
                public Iterator<EventListener<? extends Event>> iterator() {
                    return CollectionsX.comodifiableIterator((Collection)l);
                }
            };
        }
        return CollectionsX.emptyIterable();
    }

    @Override
    public final Component getOwner() {
        return this._owner;
    }

    @Override
    public final void setOwner(Component comp) {
        if (this._owner != null) {
            throw new IllegalStateException("owner can be set only once");
        }
        this._owner = comp;
        if (this._owner instanceof Includer) {
            ((Includer)((Object)this._owner)).setChildPage(this);
        }
    }

    @Override
    public void sessionWillPassivate(Desktop desktop) {
        for (Component root = this.getFirstRoot(); root != null; root = root.getNextSibling()) {
            ((ComponentCtrl)((Object)root)).sessionWillPassivate(this);
        }
        this.willPassivate(this._attrs.getAttributes().values());
        this.willPassivate(this._attrs.getListeners());
        if (this._listeners != null) {
            Iterator it = CollectionsX.comodifiableIterator(this._listeners.values());
            while (it.hasNext()) {
                this.willPassivate((Collection)it.next());
            }
        }
        this.willPassivate(this._resolvers);
        this.willPassivate(this._mappers);
    }

    @Override
    public void sessionDidActivate(Desktop desktop) {
        this._desktop = desktop;
        if (this._ownerUuid != null) {
            this.setOwner(this._desktop.getComponentByUuid(this._ownerUuid));
            this._ownerUuid = null;
        }
        for (Component root = this.getFirstRoot(); root != null; root = root.getNextSibling()) {
            ((ComponentCtrl)((Object)root)).sessionDidActivate(this);
        }
        this.didActivate(this._attrs.getAttributes().values());
        this.didActivate(this._attrs.getListeners());
        if (this._listeners != null) {
            Iterator it = CollectionsX.comodifiableIterator(this._listeners.values());
            while (it.hasNext()) {
                this.didActivate((Collection)it.next());
            }
        }
        this.didActivate(this._resolvers);
        this.didActivate(this._mappers);
    }

    private void willPassivate(Collection c) {
        if (c != null) {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                this.willPassivate(it.next());
            }
        }
    }

    private void willPassivate(Object o) {
        if (o instanceof PageSerializationListener) {
            ((PageActivationListener)o).willPassivate(this);
        }
    }

    private void didActivate(Collection c) {
        if (c != null) {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                this.didActivate(it.next());
            }
        }
    }

    private void didActivate(Object o) {
        if (o instanceof PageSerializationListener) {
            ((PageActivationListener)o).didActivate(this);
        }
    }

    @Override
    public LanguageDefinition getLanguageDefinition() {
        return this._langdef;
    }

    @Override
    public ComponentDefinitionMap getComponentDefinitionMap() {
        return this._compdefs;
    }

    @Override
    public ComponentDefinition getComponentDefinition(String name, boolean recurse) {
        ComponentDefinition compdef = this._compdefs.get(name);
        if (!recurse || compdef != null) {
            return compdef;
        }
        try {
            return this._langdef.getComponentDefinition(name);
        }
        catch (DefinitionNotFoundException ex) {
            return null;
        }
    }

    @Override
    public ComponentDefinition getComponentDefinition(Class<? extends Component> cls, boolean recurse) {
        ComponentDefinition compdef = this._compdefs.get(cls);
        if (!recurse || compdef != null) {
            return compdef;
        }
        try {
            return this._langdef.getComponentDefinition(cls);
        }
        catch (DefinitionNotFoundException ex) {
            return null;
        }
    }

    @Override
    public Class<? extends ExpressionFactory> getExpressionFactoryClass() {
        return this._expfcls;
    }

    @Override
    public void setExpressionFactoryClass(Class<? extends ExpressionFactory> expfcls) {
        if (expfcls != null && !ExpressionFactory.class.isAssignableFrom(expfcls)) {
            throw new IllegalArgumentException(expfcls + " must implement " + ExpressionFactory.class);
        }
        this._expfcls = expfcls;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this._langdef != null ? this._langdef.getName() : null);
        s.writeObject(this._owner != null ? this._owner.getUuid() : null);
        Map<String, Object> attrs = this._attrs.getAttributes();
        this.willSerialize(attrs.values());
        Serializables.smartWrite((ObjectOutputStream)s, attrs);
        List<ScopeListener> lns = this._attrs.getListeners();
        this.willSerialize(lns);
        Serializables.smartWrite((ObjectOutputStream)s, lns);
        if (this._listeners != null) {
            for (Map.Entry<String, List<EventListener<? extends Event>>> entry : this._listeners.entrySet()) {
                s.writeObject(entry.getKey());
                List<EventListener<? extends Event>> ls = entry.getValue();
                this.willSerialize(ls);
                Serializables.smartWrite((ObjectOutputStream)s, ls);
            }
        }
        s.writeObject(null);
        this.willSerialize(this._resolvers);
        Serializables.smartWrite((ObjectOutputStream)s, this._resolvers);
        this.willSerialize(this._mappers);
        Serializables.smartWrite((ObjectOutputStream)s, this._mappers);
        for (Map.Entry<String, Object> entry : this._ips.entrySet()) {
            Interpreter ip = (Interpreter)entry.getValue();
            if (!(ip instanceof SerializableAware)) continue;
            s.writeObject(entry.getKey());
            ((SerializableAware)((Object)ip)).write(s, null);
        }
        s.writeObject(null);
    }

    private void willSerialize(Collection c) {
        if (c != null) {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                this.willSerialize(it.next());
            }
        }
    }

    private void willSerialize(Object o) {
        if (o instanceof PageSerializationListener) {
            ((PageSerializationListener)o).willSerialize(this);
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        String zslang;
        String evtnm;
        s.defaultReadObject();
        this.init();
        String langnm = (String)s.readObject();
        if (langnm != null) {
            this._langdef = LanguageDefinition.lookup(langnm);
        }
        this._ownerUuid = (String)s.readObject();
        Map<String, Object> attrs = this._attrs.getAttributes();
        Serializables.smartRead((ObjectInputStream)s, attrs);
        List<ScopeListener> lns = this._attrs.getListeners();
        Serializables.smartRead((ObjectInputStream)s, lns);
        while ((evtnm = (String)s.readObject()) != null) {
            if (this._listeners == null) {
                this._listeners = new HashMap<String, List<EventListener<? extends Event>>>();
            }
            List<EventListener<? extends Event>> ls = Serializables.smartRead((ObjectInputStream)s, (List)null);
            this._listeners.put(evtnm, ls);
        }
        this._resolvers = Serializables.smartRead((ObjectInputStream)s, this._resolvers);
        this._mappers = Serializables.smartRead((ObjectInputStream)s, this._mappers);
        while ((zslang = (String)s.readObject()) != null) {
            ((SerializableAware)((Object)this.getInterpreter(zslang))).read(s);
        }
        this.didDeserialize(attrs.values());
        this.didDeserialize(lns);
        this.didDeserialize(this._resolvers);
        this.didDeserialize(this._mappers);
        if (this._listeners != null) {
            for (List<EventListener<? extends Event>> ls : this._listeners.values()) {
                this.didDeserialize(ls);
            }
        }
    }

    private void didDeserialize(Collection c) {
        if (c != null) {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                this.didDeserialize(it.next());
            }
        }
    }

    private void didDeserialize(Object o) {
        if (o instanceof PageSerializationListener) {
            ((PageSerializationListener)o).didDeserialize(this);
        }
    }

    public String toString() {
        return "[Page " + (this._id.length() > 0 ? this._id : this._uuid) + ']';
    }

    private static <E> Collection<E> combine(Collection<E> first, Collection<E> second) {
        return DualCollection.combine(first != null && !first.isEmpty() ? first : null, second != null && !second.isEmpty() ? second : null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PageFuncMapper
    implements FunctionMapper,
    FunctionMapperExt,
    Serializable {
        private PageFuncMapper() {
        }

        public Function resolveFunction(String prefix, String name) throws XelException {
            if (PageImpl.this._mappers != null) {
                Iterator it = CollectionsX.comodifiableIterator((Collection)PageImpl.this._mappers);
                while (it.hasNext()) {
                    Function f = ((FunctionMapper)it.next()).resolveFunction(prefix, name);
                    if (f == null) continue;
                    return f;
                }
            }
            return null;
        }

        public Collection<String> getClassNames() {
            Collection coll = null;
            if (PageImpl.this._mappers != null) {
                Iterator it = CollectionsX.comodifiableIterator((Collection)PageImpl.this._mappers);
                while (it.hasNext()) {
                    FunctionMapper mapper = (FunctionMapper)it.next();
                    if (!(mapper instanceof FunctionMapperExt)) continue;
                    coll = PageImpl.combine(coll, ((FunctionMapperExt)mapper).getClassNames());
                }
            }
            if (coll != null) {
                return coll;
            }
            return Collections.emptyList();
        }

        public Class resolveClass(String name) throws XelException {
            if (PageImpl.this._mappers != null) {
                Iterator it = CollectionsX.comodifiableIterator((Collection)PageImpl.this._mappers);
                while (it.hasNext()) {
                    Class c;
                    FunctionMapper mapper = (FunctionMapper)it.next();
                    if (!(mapper instanceof FunctionMapperExt) || (c = ((FunctionMapperExt)mapper).resolveClass(name)) == null) continue;
                    return c;
                }
            }
            return null;
        }
    }
}

