/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.metainfo;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.metainfo.Annotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationMap
implements Cloneable,
Serializable {
    private Map<String, Map<String, Annotation>> _annots;

    public boolean isEmpty() {
        return this._annots == null || this._annots.isEmpty();
    }

    public Annotation getAnnotation(String annotName) {
        return this.getAnnotation0(null, annotName);
    }

    public Annotation getAnnotation(String propName, String annotName) {
        if (propName == null || propName.length() == 0) {
            throw new IllegalArgumentException("The property name is required");
        }
        return this.getAnnotation0(propName, annotName);
    }

    public Collection<Annotation> getAnnotations() {
        return this.getAnnotations0(null);
    }

    public Collection<Annotation> getAnnotations(String propName) {
        if (propName == null || propName.length() == 0) {
            throw new IllegalArgumentException("The property name is required");
        }
        return this.getAnnotations0(propName);
    }

    public List<String> getAnnotatedPropertiesBy(String annotName) {
        LinkedList<String> list = new LinkedList<String>();
        if (this._annots != null) {
            for (Map.Entry<String, Map<String, Annotation>> me : this._annots.entrySet()) {
                Map<String, Annotation> ans;
                String propName = me.getKey();
                if (propName == null || !(ans = me.getValue()).containsKey(annotName)) continue;
                list.add(propName);
            }
        }
        return list;
    }

    public List<String> getAnnotatedProperties() {
        LinkedList<String> list = new LinkedList<String>();
        if (this._annots != null) {
            for (String propName : this._annots.keySet()) {
                if (propName == null) continue;
                list.add(propName);
            }
        }
        return list;
    }

    public void addAll(AnnotationMap src) {
        if (src != null && !src.isEmpty()) {
            this.initAnnots();
            for (Map.Entry<String, Map<String, Annotation>> me : src._annots.entrySet()) {
                String propName = me.getKey();
                Map<String, Annotation> ans = this._annots.get(propName);
                if (ans == null) {
                    ans = new LinkedHashMap<String, Annotation>(4);
                    this._annots.put(propName, ans);
                }
                AnnotationMap.addAllAns(ans, me.getValue());
            }
        }
    }

    public static void addAllAns(Map<String, Annotation> ans, Map<String, Annotation> srcans) {
        for (Map.Entry<String, Annotation> me : srcans.entrySet()) {
            String annotName = me.getKey();
            AnnotImpl ai = (AnnotImpl)ans.get(annotName);
            if (ai == null) {
                ai = new AnnotImpl(annotName);
                ans.put(annotName, ai);
            }
            ai.addAttributes(((AnnotImpl)me.getValue())._attrs);
        }
    }

    public void addAnnotation(String annotName, Map<String, Object> annotAttrs) {
        this.addAnnotation0(null, annotName, annotAttrs);
    }

    public void addAnnotation(String propName, String annotName, Map<String, Object> annotAttrs) {
        if (propName == null || propName.length() == 0) {
            throw new IllegalArgumentException("The property name is required");
        }
        this.addAnnotation0(propName, annotName, annotAttrs);
    }

    private Annotation getAnnotation0(String propName, String annotName) {
        Map<String, Annotation> ans;
        if (this._annots != null && (ans = this._annots.get(propName)) != null) {
            return ans.get(annotName);
        }
        return null;
    }

    private Collection<Annotation> getAnnotations0(String propName) {
        Map<String, Annotation> ans;
        if (this._annots != null && (ans = this._annots.get(propName)) != null) {
            return ans.values();
        }
        return Collections.emptyList();
    }

    private void addAnnotation0(String propName, String annotName, Map<String, Object> annotAttrs) {
        AnnotImpl ai;
        this.initAnnots();
        Map<String, Annotation> ans = this._annots.get(propName);
        if (ans == null) {
            ans = new LinkedHashMap<String, Annotation>(4);
            this._annots.put(propName, ans);
        }
        if ((ai = (AnnotImpl)ans.get(annotName)) == null) {
            ai = new AnnotImpl(annotName);
            ans.put(annotName, ai);
        }
        ai.addAttributes(annotAttrs);
    }

    private void initAnnots() {
        if (this._annots == null) {
            this._annots = new LinkedHashMap<String, Map<String, Annotation>>(4);
        }
    }

    public Object clone() {
        AnnotationMap clone;
        try {
            clone = (AnnotationMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        if (this._annots != null) {
            clone._annots = new LinkedHashMap<String, Map<String, Annotation>>(this._annots);
            for (Map.Entry<String, Map<String, Annotation>> me : clone._annots.entrySet()) {
                LinkedHashMap<String, Annotation> ans = new LinkedHashMap<String, Annotation>(4);
                AnnotationMap.addAllAns(ans, me.getValue());
                me.setValue(ans);
            }
        }
        return clone;
    }

    public String toString() {
        return "[annot:" + this._annots + ']';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnnotImpl
    implements Annotation {
        private final String _name;
        private Map<String, Object> _attrs;

        private AnnotImpl(String name) {
            this._name = name;
        }

        private void addAttribute(String name, Object value) {
            if (name == null || name.length() == 0) {
                name = "value";
            }
            if (value == null) {
                value = "";
            }
            if (this._attrs == null) {
                this._attrs = new LinkedHashMap<String, Object>(4);
            }
            this._attrs.put(name, value);
        }

        private void addAttributes(Map<String, Object> attrs) {
            if (attrs != null) {
                for (Map.Entry<String, Object> me : attrs.entrySet()) {
                    this.addAttribute(me.getKey(), me.getValue());
                }
            }
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public Map<String, Object> getAttributes() {
            if (this._attrs != null) {
                return this._attrs;
            }
            return Collections.emptyMap();
        }

        @Override
        public String getAttribute(String name) {
            if (this._attrs != null) {
                Object val = this._attrs.get(name);
                if (val instanceof String[]) {
                    String[] vs = (String[])val;
                    return vs.length > 0 ? vs[0] : null;
                }
                return (String)val;
            }
            return null;
        }

        @Override
        public String[] getAttributeValues(String name) {
            if (this._attrs != null) {
                Object val = this._attrs.get(name);
                if (val instanceof String[]) {
                    return (String[])val;
                }
                if (val != null) {
                    return new String[]{(String)val};
                }
            }
            return null;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer().append('@').append(this._name).append('(');
            if (this._attrs != null) {
                boolean first = true;
                for (Map.Entry<String, Object> me : this._attrs.entrySet()) {
                    if (!first) {
                        sb.append(", ");
                    }
                    sb.append((Object)me.getKey()).append('=').append(Objects.toString((Object)me.getValue()));
                    first = false;
                }
            }
            return sb.append(')').toString();
        }
    }
}

