/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.select.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.select.impl.Attribute;
import org.zkoss.zk.ui.select.impl.BasicPseudoClassDefs;
import org.zkoss.zk.ui.select.impl.ComponentMatchCtx;
import org.zkoss.zk.ui.select.impl.Parser;
import org.zkoss.zk.ui.select.impl.PseudoClass;
import org.zkoss.zk.ui.select.impl.PseudoClassDef;
import org.zkoss.zk.ui.select.impl.Selector;
import org.zkoss.zk.ui.select.impl.SimpleSelectorSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentLocalProperties {
    public static boolean match(Component component, String selector) {
        return ComponentLocalProperties.match(component, selector, null);
    }

    public static boolean match(Component component, String selector, Map<String, PseudoClassDef> defs) {
        List<Selector> selectorList = new Parser().parse(selector);
        ComponentMatchCtx ctx = new ComponentMatchCtx(component, selectorList);
        for (Selector s : selectorList) {
            if (s.size() > 1 || !ComponentLocalProperties.match(ctx, (SimpleSelectorSequence)s.get(0), defs)) continue;
            return true;
        }
        return false;
    }

    static boolean match(ComponentMatchCtx context, SimpleSelectorSequence seq, Map<String, PseudoClassDef> defs) {
        Component comp = context.getComponent();
        return ComponentLocalProperties.matchType(comp, seq.getType()) && ComponentLocalProperties.matchID(comp, seq.getId()) && ComponentLocalProperties.matchClasses(comp, seq.getClasses()) && ComponentLocalProperties.matchAttributes(comp, seq.getAttributes()) && ComponentLocalProperties.matchPseudoClasses(context, seq.getPseudoClasses(), defs);
    }

    static boolean matchID(Component component, String id) {
        if (id == null) {
            return true;
        }
        return id.equals(component.getId());
    }

    static boolean matchType(Component component, String type) {
        if (type == null) {
            return true;
        }
        return component.getDefinition().getName().equals(type);
    }

    static boolean matchClasses(Component component, Set<String> classes) {
        if (classes == null || classes.isEmpty()) {
            return true;
        }
        if (!(component instanceof HtmlBasedComponent)) {
            return false;
        }
        String scls = ((HtmlBasedComponent)component).getSclass();
        String zcls = ((HtmlBasedComponent)component).getZclass();
        for (String c : classes) {
            if (scls != null && (scls.matches("(?:^|.*\\s)" + c + "(?:\\s.*|$)") || Objects.equals((Object)zcls, (Object)c))) continue;
            return false;
        }
        return true;
    }

    static boolean matchAttributes(Component component, List<Attribute> attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return true;
        }
        for (Attribute attr : attributes) {
            if (ComponentLocalProperties.matchValue(ComponentLocalProperties.getValue(component, attr.getName()), attr)) continue;
            return false;
        }
        return true;
    }

    static boolean matchPseudoClasses(ComponentMatchCtx context, List<PseudoClass> pseudoClasses, Map<String, PseudoClassDef> defs) {
        if (pseudoClasses == null || pseudoClasses.isEmpty()) {
            return true;
        }
        for (PseudoClass pc : pseudoClasses) {
            PseudoClassDef def = ComponentLocalProperties.getPseudoClassDef(defs, pc.getName());
            if (def == null) {
                throw new UiException("Pseudo class definition not found: " + pc.getName());
            }
            String[] param = pc.getParameter();
            if (!(param == null ? !def.accept(context, new String[0]) : !def.accept(context, pc.getParameter()))) continue;
            return false;
        }
        return true;
    }

    private static Object getValue(Component component, String name) {
        try {
            return component.getClass().getMethod("get" + ComponentLocalProperties.capitalize(name), new Class[0]).invoke((Object)component, new Object[0]);
        }
        catch (NoSuchMethodException e) {
        }
        catch (SecurityException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        try {
            return component.getClass().getMethod("is" + ComponentLocalProperties.capitalize(name), new Class[0]).invoke((Object)component, new Object[0]);
        }
        catch (NoSuchMethodException e) {
        }
        catch (SecurityException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return component.getAttribute(name);
    }

    private static String capitalize(String str) {
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    private static PseudoClassDef getPseudoClassDef(Map<String, PseudoClassDef> defs, String className) {
        PseudoClassDef def = null;
        if (defs != null && !defs.isEmpty()) {
            def = defs.get(className);
        }
        if (def != null) {
            return def;
        }
        return BasicPseudoClassDefs.getDefinition(className);
    }

    private static Object parseData(String source, Class<?> expectedType) {
        if (expectedType.equals(Integer.class)) {
            return new Integer(source);
        }
        if (expectedType.equals(Boolean.class)) {
            return new Boolean(source);
        }
        if (expectedType.equals(Double.class)) {
            return new Double(source);
        }
        return source;
    }

    private static boolean matchValue(Object value, Attribute attr) {
        switch (attr.getOperator()) {
            case BEGIN_WITH: {
                return value != null && value.toString().startsWith(attr.getValue());
            }
            case END_WITH: {
                return value != null && value.toString().endsWith(attr.getValue());
            }
            case CONTAIN: {
                return value != null && value.toString().contains(attr.getValue());
            }
        }
        try {
            Object attrValue = ComponentLocalProperties.parseData(attr.getValue(), attr.isQuoted() ? String.class : value.getClass());
            return Objects.equals((Object)value, (Object)attrValue);
        }
        catch (Exception e) {
            return false;
        }
    }
}

