/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.select.impl;

import java.util.List;
import java.util.Map;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.select.impl.ComponentLocalProperties;
import org.zkoss.zk.ui.select.impl.PseudoClassDef;
import org.zkoss.zk.ui.select.impl.Selector;
import org.zkoss.zk.ui.select.impl.SimpleSelectorSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentMatchCtx {
    private ComponentMatchCtx _parent;
    private Component _comp;
    private boolean[][] _qualified;
    private int _compChildIndex = -1;

    ComponentMatchCtx(Component component, List<Selector> selectorList) {
        this._comp = component;
        this._qualified = new boolean[selectorList.size()][];
        for (Selector selector : selectorList) {
            this._qualified[selector.getSelectorIndex()] = new boolean[selector.size()];
        }
        this._compChildIndex = this.getComponentIndex();
    }

    ComponentMatchCtx(Component component, ComponentMatchCtx parent) {
        this._comp = component;
        int selectorListSize = parent._qualified.length;
        this._qualified = new boolean[selectorListSize][];
        for (int i = 0; i < selectorListSize; ++i) {
            this._qualified[i] = new boolean[parent._qualified[i].length];
        }
        this._parent = parent;
        this._compChildIndex = 0;
    }

    void moveToNextSibling() {
        this._comp = this._comp.getNextSibling();
        ++this._compChildIndex;
    }

    public ComponentMatchCtx getParent() {
        return this._parent;
    }

    public Component getComponent() {
        return this._comp;
    }

    public int getComponentChildIndex() {
        if (this._compChildIndex > -1) {
            return this._compChildIndex;
        }
        Component parent = this._comp.getParent();
        return parent == null ? -1 : parent.getChildren().indexOf(this._comp);
    }

    public int getComponentSiblingSize() {
        Component parent = this._comp.getParent();
        return parent == null ? this._comp.getPage().getRoots().size() : parent.getChildren().size();
    }

    public boolean isQualified(int selectorIndex, int position) {
        return this._qualified[selectorIndex][position];
    }

    void setQualified(int selectorIndex, int position) {
        this.setQualified(selectorIndex, position, true);
    }

    void setQualified(int selectorIndex, int position, boolean qualified) {
        this._qualified[selectorIndex][position] = qualified;
    }

    public boolean isMatched() {
        for (int i = 0; i < this._qualified.length; ++i) {
            if (!this.isMatched(i)) continue;
            return true;
        }
        return false;
    }

    public boolean isMatched(int selectorIndex) {
        boolean[] quals = this._qualified[selectorIndex];
        return quals[quals.length - 1];
    }

    public boolean match(SimpleSelectorSequence seq, Map<String, PseudoClassDef> defs) {
        return ComponentLocalProperties.match(this, seq, defs);
    }

    private int getComponentIndex() {
        Component curr = this._comp;
        int index = -1;
        while (curr != null) {
            curr = curr.getPreviousSibling();
            ++index;
        }
        return index;
    }
}

