/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.sys;

import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.ui.UiException;

public class ComponentRedraws {
    private static final Log log = Log.lookup(ComponentRedraws.class);
    private static final ThreadLocal<Context> _ctx = new ThreadLocal();

    public static final int beforeRedraw(boolean includingPage) {
        int order;
        Context ctx = _ctx.get();
        if (ctx == null) {
            ctx = new Context();
            _ctx.set(ctx);
            order = -1;
        } else if (ctx.states.isEmpty()) {
            order = -1;
        } else {
            order = (Integer)ctx.states.get(0);
            ctx.states.set(0, new Integer(order + 1));
        }
        ctx.states.add(0, new Integer(includingPage ? -1 : 0));
        return order;
    }

    public static final Writer getScriptBuffer() {
        return _ctx.get().out;
    }

    public static final String afterRedraw() {
        try {
            Context ctx = _ctx.get();
            ctx.states.remove(0);
            if (ctx.states.isEmpty()) {
                _ctx.set(null);
                return ctx.out.getBuffer().toString();
            }
        }
        catch (Throwable ex) {
            _ctx.set(null);
            throw UiException.Aide.wrap(ex);
        }
        return "";
    }

    private static class Context {
        private final List<Integer> states = new LinkedList<Integer>();
        private final StringWriter out = new StringWriter();

        private Context() {
        }
    }
}

