/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.sys;

import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Library;
import org.zkoss.lang.Objects;
import org.zkoss.util.Cache;
import org.zkoss.util.Maps;
import org.zkoss.util.MultiCache;
import org.zkoss.util.Pair;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.ComponentNotFoundException;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Path;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.metainfo.AnnotationMap;
import org.zkoss.zk.ui.metainfo.ComponentDefinition;
import org.zkoss.zk.ui.metainfo.ComponentInfo;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.sys.JavaScriptValue;
import org.zkoss.zk.xel.ExValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentsCtrl {
    private static final ThreadLocal<Object> _compdef = new ThreadLocal();
    private static Cache<Pair<Class<?>, String>, Object> _evtmtds = new MultiCache(Library.getIntProperty((String)"org.zkoss.zk.ui.event.methods.cache.number", (int)97), Library.getIntProperty((String)"org.zkoss.zk.ui.event.methods.cache.maxSize", (int)30), 14400000);
    public static final ComponentDefinition DUMMY = new ComponentDefinition(){

        @Override
        public LanguageDefinition getLanguageDefinition() {
            return null;
        }

        @Override
        public String getName() {
            return "[anonymous]";
        }

        @Override
        public String getTextAs() {
            return null;
        }

        @Override
        public boolean isMacro() {
            return false;
        }

        @Override
        public String getMacroURI() {
            return null;
        }

        @Override
        public boolean isInlineMacro() {
            return false;
        }

        @Override
        public boolean isNative() {
            return false;
        }

        @Override
        public boolean isBlankPreserved() {
            return false;
        }

        @Override
        public Object getImplementationClass() {
            return Component.class;
        }

        public void setImplementationClass(Class cls) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setImplementationClass(String clsnm) {
            throw new UnsupportedOperationException();
        }

        public Class resolveImplementationClass(Page page, String clsnm) throws ClassNotFoundException {
            return Component.class;
        }

        @Override
        public boolean isInstance(Component comp) {
            return comp != null;
        }

        @Override
        public Component newInstance(Page page, String clsnm) {
            throw new UnsupportedOperationException();
        }

        public Component newInstance(Class cls) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addMold(String name, String widgetClass) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getWidgetClass(Component comp, String moldName) {
            return null;
        }

        @Override
        public String getDefaultWidgetClass(Component comp) {
            return null;
        }

        @Override
        public void setDefaultWidgetClass(String widgetClass) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasMold(String name) {
            return false;
        }

        @Override
        public Collection<String> getMoldNames() {
            return Collections.emptyList();
        }

        @Override
        public void addProperty(String name, String value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void applyProperties(Component comp) {
        }

        @Override
        public void applyAttributes(Component comp) {
        }

        @Override
        public Map<String, Object> evalProperties(Map<String, Object> propmap, Page owner, Component parent) {
            return propmap != null ? propmap : new HashMap(2);
        }

        @Override
        public AnnotationMap getAnnotationMap() {
            return null;
        }

        @Override
        public String getApply() {
            return null;
        }

        @Override
        public ExValue[] getParsedApply() {
            return null;
        }

        @Override
        public void setApply(String apply) {
            throw new UnsupportedOperationException();
        }

        @Override
        public URL getDeclarationURL() {
            return null;
        }

        @Override
        public ComponentDefinition clone(LanguageDefinition langdef, String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object clone() {
            throw new UnsupportedOperationException();
        }
    };

    public static final String toAutoId(String prefix, int val) {
        return ComponentsCtrl.encodeId(new StringBuffer(16).append(prefix), val);
    }

    public static final String encodeId(StringBuffer sb, int val) {
        if (val < 0 && (val -= Integer.MIN_VALUE) < 0) {
            val = -val;
        }
        do {
            int v = val % 37;
            val /= 37;
            if (v-- == 0) {
                sb.append('_');
                continue;
            }
            if (v < 10) {
                sb.append((char)(48 + v));
                continue;
            }
            sb.append((char)(v + 87));
        } while (val != 0);
        return sb.toString();
    }

    public static final boolean isAutoUuid(String id) {
        char cc;
        if (id == null) {
            return true;
        }
        if (id.length() < 5) {
            return false;
        }
        return !(!ComponentsCtrl.isLower(id.charAt(0)) || !ComponentsCtrl.isUpper(cc = id.charAt(1)) && !ComponentsCtrl.isDigit(cc) || !ComponentsCtrl.isUpper(cc = id.charAt(2)) && !ComponentsCtrl.isLower(cc) && !ComponentsCtrl.isDigit(cc) || !ComponentsCtrl.isUpper(id.charAt(3)));
    }

    private static boolean isUpper(char cc) {
        return cc >= 'A' && cc <= 'Z';
    }

    private static boolean isLower(char cc) {
        return cc >= 'a' && cc <= 'z';
    }

    private static boolean isDigit(char cc) {
        return cc >= '0' && cc <= '9';
    }

    public static void checkUuid(String uuid) {
        int j;
        if (uuid == null || (j = uuid.length()) == 0) {
            throw new UiException("uuid cannot be null or empty");
        }
        while (--j >= 0) {
            char cc = uuid.charAt(j);
            if (cc >= 'a' && cc <= 'z' || cc >= 'A' && cc <= 'Z' || cc >= '0' && cc <= '9' || cc == '_') continue;
            throw new UiException("Illegal character, " + cc + ", not allowed in uuid, " + uuid);
        }
    }

    public static final boolean isReservedAttribute(String name) {
        return name != null && !"use".equals(name) && !"if".equals(name) && !"unless".equals(name) && !"apply".equals(name) && !"forEach".equals(name);
    }

    public static final Object getCurrentInfo() {
        return _compdef.get();
    }

    public static final void setCurrentInfo(ComponentDefinition compdef) {
        _compdef.set(compdef);
    }

    public static void setCurrentInfo(ComponentInfo compInfo) {
        _compdef.set(compInfo);
    }

    public static Object[] parseEventExpression(Component comp, String evtexpr, Component defaultComp, boolean deferred) throws ComponentNotFoundException {
        Object target;
        String evtnm;
        int j = evtexpr.lastIndexOf(46);
        if (j >= 0) {
            evtnm = evtexpr.substring(j + 1).trim();
            String path = evtexpr.substring(0, j);
            if (path.length() > 0) {
                target = null;
                if (path.indexOf("${") >= 0) {
                    Object v = Executions.evaluate(comp, path, Object.class);
                    if (v instanceof Component) {
                        target = (Component)v;
                    } else {
                        if (v == null) {
                            throw new ComponentNotFoundException("EL evaluated to null: " + path);
                        }
                        path = Objects.toString((Object)v);
                    }
                }
                if (target == null) {
                    if ("self".equals(path = path.trim())) {
                        path = ".";
                    }
                    Object object = deferred ? path : (target = ".".equals(path) ? comp : Path.getComponent(comp.getSpaceOwner(), path));
                    if (target == null && comp instanceof IdSpace && comp.getParent() != null) {
                        target = Path.getComponent(comp.getParent().getSpaceOwner(), path);
                    }
                }
            } else {
                target = defaultComp;
            }
        } else {
            evtnm = evtexpr.trim();
            target = defaultComp;
        }
        if (!Events.isValid(evtnm)) {
            throw new UiException("Not an event name: " + evtnm);
        }
        return new Object[]{target, evtnm};
    }

    public static final void applyForward(Component comp, String forward) {
        if (forward == null) {
            return;
        }
        LinkedHashMap fwds = new LinkedHashMap();
        Maps.parseMultiple(fwds, (String)forward, (char)',', (char)'\'', (boolean)true, (boolean)true);
        for (Map.Entry me : fwds.entrySet()) {
            String orgEvent = (String)me.getKey();
            if (orgEvent != null && !Events.isValid(orgEvent)) {
                throw new UiException("Not an event name: " + orgEvent);
            }
            Collection conds = (Collection)me.getValue();
            for (String cond : conds) {
                ComponentsCtrl.applyForward0(comp, orgEvent, cond);
            }
        }
    }

    private static final void applyForward0(Component comp, String orgEvent, String cond) {
        Object[] result;
        Object target;
        int len;
        if (cond == null || (len = cond.length()) == 0) {
            cond = orgEvent;
            len = cond.length();
        }
        Object data = null;
        block0: for (int j = 0; j < len; ++j) {
            int k;
            char cc = cond.charAt(j);
            if (cc == '\\') {
                ++j;
                continue;
            }
            if (cc == '{') {
                k = j + 1;
                int depth = 0;
                while (true) {
                    if (k >= len) {
                        j = k;
                        continue block0;
                    }
                    char c2 = cond.charAt(k);
                    if (c2 == '{') {
                        ++depth;
                    } else if (c2 == '}' && --depth < 0) {
                        j = k;
                        continue block0;
                    }
                    ++k;
                }
            }
            if (cc != '(' || (k = cond.lastIndexOf(41)) <= j) continue;
            data = Executions.evaluate(comp, cond.substring(j + 1, k), Object.class);
            cond = cond.substring(0, j);
            break;
        }
        if ((target = (result = ComponentsCtrl.parseEventExpression(comp, cond, null, true))[0]) instanceof String) {
            comp.addForward(orgEvent, (String)target, (String)result[1], data);
        } else {
            comp.addForward(orgEvent, (Component)target, (String)result[1], data);
        }
    }

    public static final Method getEventMethod(Class<?> cls, String evtnm) {
        Pair key = new Pair(cls, (Object)evtnm);
        Object o = _evtmtds.get((Object)key);
        if (o != null) {
            return o == Objects.UNKNOWN ? null : (Method)o;
        }
        Method mtd = null;
        try {
            mtd = Classes.getCloseMethodBySubclass(cls, (String)evtnm, (Class[])new Class[]{Event.class});
        }
        catch (NoSuchMethodException ex) {
            try {
                mtd = cls.getMethod(evtnm, new Class[0]);
            }
            catch (NoSuchMethodException e2) {
                // empty catch block
            }
        }
        _evtmtds.put((Object)key, mtd != null ? mtd : Objects.UNKNOWN);
        return mtd;
    }

    public static final void setEventMethodCache(Cache cache) {
        if (cache == null) {
            throw new IllegalArgumentException();
        }
        _evtmtds = cache;
    }

    public static final Collection<JavaScriptValue> redraw(Collection<? extends Component> comps) {
        try {
            StringWriter out = new StringWriter(8192);
            LinkedList<JavaScriptValue> js = new LinkedList<JavaScriptValue>();
            for (Component component : comps) {
                ((ComponentCtrl)((Object)component)).redraw(out);
                StringBuffer sb = out.getBuffer();
                js.add(new JavaScriptValue(sb.toString()));
                sb.setLength(0);
            }
            return js;
        }
        catch (IOException ex) {
            throw new InternalError();
        }
    }
}

