/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkex.zul;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zkex.zul.ListModelSharer;
import org.zkoss.zkex.zul.impl.Operation;
import org.zkoss.zkex.zul.impl.OperationQueue;
import org.zkoss.zkex.zul.impl.OperationQueueListener;
import org.zkoss.zkex.zul.impl.OperationThread;
import org.zkoss.zul.AbstractListModel;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.event.ListDataEvent;
import org.zkoss.zul.event.ListDataListener;

public class SimpleListModelSharer
implements ListModelSharer {
    private static final Log log = Log.lookup((Class)SimpleListModelSharer.class);
    private static final int OP_ADD = 1;
    private static final int OP_REMOVE = 2;
    private static final int OP_SET = 3;
    private List _proxys = Collections.synchronizedList(new LinkedList());
    private List _innerData;
    private ListModel _srcModel;
    private ListDataListener _srcListener;

    public SimpleListModelSharer(ListModel model) {
        this._srcModel = model;
        this.init();
    }

    private void init() {
        this._innerData = Collections.synchronizedList(new LinkedList());
        int size = this._srcModel.getSize();
        for (int i = 0; i < size; ++i) {
            this._innerData.add(this._srcModel.getElementAt(i));
        }
        this._srcListener = new ListDataListener(){

            public void onChange(ListDataEvent event) {
                SimpleListModelSharer.this.onListDataChange(event);
            }
        };
        this._srcModel.addListDataListener(this._srcListener);
    }

    private void onListDataChange(ListDataEvent event) {
        int index1;
        int type = event.getType();
        ListModel model = event.getModel();
        if (this._srcModel != model) {
            return;
        }
        int index0 = event.getIndex0();
        int min = index0 > (index1 = event.getIndex1()) ? index1 : index0;
        int max = index0 > index1 ? index0 : index1;
        switch (type) {
            case 0: {
                int start = min < 0 ? 0 : min;
                int end = max < 0 ? this._srcModel.getSize() : max;
                for (int i = start; i <= end; ++i) {
                    Object obj = this._srcModel.getElementAt(i);
                    this._innerData.set(i, obj);
                    this.putToQueue(3, new Object[]{new Integer(i), obj});
                }
                break;
            }
            case 1: {
                int start = min < 0 ? 0 : min;
                int end = max < 0 ? this._srcModel.getSize() : max;
                for (int i = start; i <= end; ++i) {
                    Object obj = this._srcModel.getElementAt(i);
                    this._innerData.add(i, obj);
                    this.putToQueue(1, new Object[]{new Integer(i), obj});
                }
                break;
            }
            case 2: {
                int end;
                int start = min < 0 ? 0 : min;
                for (int i = end = max < 0 ? this._srcModel.getSize() : max; i >= start; --i) {
                    this._innerData.remove(i);
                    this.putToQueue(2, new Object[]{new Integer(i)});
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unknow Event Type:" + type);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListModel getProxy(Desktop desktop) {
        ProxyModel proxy;
        if (log.debugable()) {
            log.debug("create proxy model for:" + desktop);
        }
        List list = this._proxys;
        synchronized (list) {
            proxy = new ProxyModel(this._innerData);
            QueueListener oql = new QueueListener(desktop, proxy);
            proxy.setOperationQueueListener(oql);
            OperationQueue queue = OperationThread.getQueue(desktop);
            queue.addListener(oql);
            proxy.setQueue(queue);
            this._proxys.add(proxy);
        }
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getProxyCount() {
        List list = this._proxys;
        synchronized (list) {
            return this._proxys.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyProxy(Desktop desktop, ListModel model, boolean rmQueueListener) {
        if (!(model instanceof ProxyModel)) {
            throw new IllegalArgumentException("Not a created proxy model:" + model.getClass());
        }
        List list = this._proxys;
        synchronized (list) {
            if (this._proxys.remove(model)) {
                if (log.debugable()) {
                    log.debug("destory proxy model for:" + desktop);
                }
                ((ProxyModel)model).clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putToQueue(int op, Object[] parms) {
        List list = this._proxys;
        synchronized (list) {
            Iterator iter = this._proxys.iterator();
            while (iter.hasNext()) {
                ProxyModel model = (ProxyModel)((Object)iter.next());
                ListModelOperation lmop = new ListModelOperation(op, parms, model);
                OperationQueue queue = model.getQueue();
                if (queue == null) continue;
                queue.put(lmop);
            }
        }
    }

    private static class ProxyModel
    extends AbstractListModel {
        private OperationQueue _queue;
        private OperationQueueListener _oqListener;
        List _proxyedData;

        OperationQueue getQueue() {
            return this._queue;
        }

        void setQueue(OperationQueue queue) {
            this._queue = queue;
        }

        ProxyModel(Collection c) {
            this._proxyedData = Collections.synchronizedList(new LinkedList(c));
        }

        void clear() {
            if (this._queue != null && this._oqListener != null) {
                this._queue.removeListener(this._oqListener);
            }
            this._queue = null;
            this._oqListener = null;
            this._proxyedData.clear();
            this.clearSelection();
        }

        void add(int index, Object element) {
            this._proxyedData.add(index, element);
            this.fireEvent(1, index, index);
        }

        Object remove(int index) {
            Object obj = this._proxyedData.remove(index);
            this.removeSelection(obj);
            this.fireEvent(2, index, index);
            return obj;
        }

        Object set(int index, Object element) {
            Object obj = this._proxyedData.set(index, element);
            this.fireEvent(0, index, index);
            return obj;
        }

        void setOperationQueueListener(OperationQueueListener oql) {
            this._oqListener = oql;
        }

        public Object getElementAt(int index) {
            return this._proxyedData.get(index);
        }

        public int getSize() {
            return this._proxyedData.size();
        }
    }

    private class ListModelOperation
    implements Operation {
        int _op;
        Object[] _parms;
        ProxyModel _model;

        ListModelOperation(int op, Object[] parms, ProxyModel model) {
            this._op = op;
            this._parms = parms;
            this._model = model;
        }

        public void execute(Desktop _desktop) {
            switch (this._op) {
                case 1: {
                    this._model.add((Integer)this._parms[0], this._parms[1]);
                    break;
                }
                case 2: {
                    this._model.remove((Integer)this._parms[0]);
                    break;
                }
                case 3: {
                    this._model.set((Integer)this._parms[0], this._parms[1]);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknow operation:" + this._op);
                }
            }
        }

        public void failToExecute(Desktop _desktop) {
            SimpleListModelSharer.this.destroyProxy(_desktop, (ListModel)this._model, true);
        }
    }

    private class QueueListener
    implements OperationQueueListener {
        Desktop _desktop;
        ProxyModel _proxy;

        QueueListener(Desktop desktop, ProxyModel proxy) {
            this._desktop = desktop;
            this._proxy = proxy;
        }

        public void queueUnavailable(Desktop desktop) {
            if (this._desktop == desktop) {
                SimpleListModelSharer.this.destroyProxy(desktop, (ListModel)this._proxy, false);
            }
        }
    }
}

