/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkex.zul.impl;

import org.zkoss.util.logging.Log;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.DesktopUnavailableException;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zkex.zul.impl.Operation;
import org.zkoss.zkex.zul.impl.OperationQueue;

public class OperationThread
extends Thread {
    private static final String DESKTOP_KEY = "zkex:opthread";
    private boolean _running = true;
    private OperationQueue _queue;
    private Desktop _desktop;
    private long _activateTimeout = 10000L;
    private long _waitTimeout = 10000L;
    private int _maxFailCount = 4;
    private static final Log log = Log.lookup((Class)OperationThread.class);

    OperationThread(Desktop desktop) {
        this._desktop = desktop;
        this._queue = new OperationQueue();
        this.setName("OPThread-" + desktop.getId());
    }

    OperationQueue getQueue() {
        return this._queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OperationQueue getQueue(Desktop desktop) {
        if (desktop == null) {
            throw new NullPointerException("desktop is null");
        }
        Desktop desktop2 = desktop;
        synchronized (desktop2) {
            if (!desktop.isAlive()) {
                throw new IllegalStateException("desktop not alive:" + desktop);
            }
            OperationThread t = (OperationThread)desktop.getAttribute(DESKTOP_KEY);
            if (t == null) {
                t = new OperationThread(desktop);
                if (log.debugable()) {
                    log.debug("staring a Operation Thread for desktop:" + desktop + ",name=" + t.getName());
                }
                desktop.setAttribute(DESKTOP_KEY, (Object)t);
                t.start();
            }
            return t.getQueue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyWith(Desktop desktop) {
        if (desktop == null) {
            throw new NullPointerException("desktop is null");
        }
        if (log.debugable()) {
            log.debug("destory a Operation Thread for desktop:" + desktop);
        }
        Desktop desktop2 = desktop;
        synchronized (desktop2) {
            if (desktop.isAlive()) {
                OperationThread t = (OperationThread)desktop.getAttribute(DESKTOP_KEY);
                desktop.removeAttribute(DESKTOP_KEY);
                if (t != null && t.isRunning()) {
                    t.terminate();
                }
            }
        }
    }

    public boolean isRunning() {
        return this._running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        this._running = false;
        OperationQueue operationQueue = this._queue;
        synchronized (operationQueue) {
            this._queue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            int failCount = 0;
            while (this._running) {
                if (!this._desktop.isAlive()) {
                    throw new DesktopUnavailableException("Desktop is not alive" + this._desktop);
                }
                if (this._queue.hasElement()) {
                    boolean r = false;
                    try {
                        r = Executions.activate((Desktop)this._desktop, (long)this._activateTimeout);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (!r) {
                        if (++failCount < this._maxFailCount) continue;
                        throw new DesktopUnavailableException("Fail to Activate Desktop:" + this._desktop + " after " + failCount + " times");
                    }
                    failCount = 0;
                    Operation op = null;
                    try {
                        while (this._queue.hasElement()) {
                            op = this._queue.next();
                            op.execute(this._desktop);
                        }
                    }
                    catch (Exception x) {
                        if (op != null) {
                            op.failToExecute(this._desktop);
                        }
                        throw x;
                    }
                    finally {
                        Executions.deactivate((Desktop)this._desktop);
                    }
                }
                try {
                    OperationQueue r = this._queue;
                    synchronized (r) {
                        if (this._running && !this._queue.hasElement()) {
                            this._queue.wait(this._waitTimeout);
                        }
                    }
                }
                catch (InterruptedException e) {
                }
            }
        }
        catch (DesktopUnavailableException x) {
            if (log.debugable()) {
                log.debug("Desktop not available:" + x.getMessage());
            }
            while (this._queue.hasElement()) {
                Operation op = this._queue.next();
                op.failToExecute(this._desktop);
            }
        }
        catch (Exception x) {
            log.warning((Throwable)x);
            while (this._queue.hasElement()) {
                Operation op = this._queue.next();
                if (op == null) continue;
                op.failToExecute(this._desktop);
            }
        }
        finally {
            this._running = false;
            OperationThread.destroyWith(this._desktop);
            this._queue.fireQueueUnavailable(this._desktop);
            this._queue.clearListener();
            this._desktop = null;
            this._queue = null;
            if (log.debugable()) {
                log.debug("end of a Operation Thread, name=" + this.getName());
            }
        }
    }
}

