/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.au.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.zkoss.io.Files;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zkmax.au.http.SmartAuWriter;

class Compress
implements Serializable {
    final byte[] data;

    private Compress(byte[] data) {
        this.data = data;
    }

    static Object compress(byte[] data) {
        if (data.length > 1000) {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(8192);
                GZIPOutputStream zs = new GZIPOutputStream(bos);
                zs.write(data);
                Files.close((OutputStream)zs);
                Files.close((OutputStream)bos);
                byte[] bs = bos.toByteArray();
                if (bs.length + 16 < data.length) {
                    return new Compress(bs);
                }
            }
            catch (Throwable ex) {
                SmartAuWriter.log.warningBriefly("Ignored: unable to compress", ex);
            }
        }
        return data;
    }

    byte[] uncompress() {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(this.data);
            GZIPInputStream zs = new GZIPInputStream(bis);
            byte[] bs = Files.readAll((InputStream)zs);
            Files.close((InputStream)zs);
            Files.close((InputStream)bis);
            return bs;
        }
        catch (IOException ex) {
            throw new UiException((Throwable)ex);
        }
    }
}

