/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.ui.event.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.AuService;
import org.zkoss.zk.au.out.AuEchoGlobal;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.EventQueue;
import org.zkoss.zk.ui.event.impl.DesktopEventQueue;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zk.ui.util.DesktopCleanup;

public class GroupEventQueue
implements EventQueue {
    private static final Log log = Log.lookup((Class)GroupEventQueue.class);
    private static final String CMD_PUBLISH = "z_groupeq_publish";
    private static final String CMD_CLOSE = "z_groupeq_close";
    private final Map _infs = new HashMap();
    private final Map _evts = new HashMap();

    public void publish(Event event) {
        if (event == null) {
            throw new IllegalArgumentException();
        }
        this.publishToCurrent(event);
        this.globalEcho(CMD_PUBLISH, event);
    }

    public void subscribe(EventListener listener) {
        this.getDesktopEventQueue(true).subscribe(listener);
    }

    public void subscribe(EventListener listener, EventListener callback) {
        this.getDesktopEventQueue(true).subscribe(listener, callback);
    }

    public void subscribe(EventListener listener, boolean async) {
        this.getDesktopEventQueue(true).subscribe(listener, async);
    }

    public boolean unsubscribe(EventListener listener) {
        DesktopEventQueue que = this.getDesktopEventQueue(false);
        if (que != null && que.unsubscribe(listener)) {
            if (que.isIdle()) {
                this.closeCurrent(true);
            }
            return true;
        }
        return false;
    }

    public boolean isSubscribed(EventListener listener) {
        DesktopEventQueue que = this.getDesktopEventQueue(false);
        return que != null && que.isSubscribed(listener);
    }

    public void close() {
        this.closeCurrent(true);
        this.globalEcho(CMD_CLOSE, null);
    }

    private static Execution getExecution() {
        Execution exec = Executions.getCurrent();
        if (exec == null) {
            throw new IllegalStateException("Execution required");
        }
        return exec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DesktopEventQueue getDesktopEventQueue(boolean autoCreate) {
        QueueInfo qi;
        Desktop desktop = GroupEventQueue.getExecution().getDesktop();
        Map map = this._infs;
        synchronized (map) {
            qi = (QueueInfo)this._infs.get(desktop);
            if (qi == null && autoCreate) {
                qi = new QueueInfo(desktop, new EQService(), new EQCleanup());
                this._infs.put(desktop, qi);
            }
        }
        return qi.queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void globalEcho(String cmd, Event evt) {
        Desktop curdt = GroupEventQueue.getExecution().getDesktop();
        LinkedList<Desktop> dts = new LinkedList<Desktop>();
        Map map = this._infs;
        synchronized (map) {
            Iterator it = this._infs.keySet().iterator();
            while (it.hasNext()) {
                Desktop dt = (Desktop)it.next();
                if (dt == curdt) continue;
                dts.add(dt);
                if (evt == null) continue;
                Map map2 = this._evts;
                synchronized (map2) {
                    LinkedList<Event> evts = (LinkedList<Event>)this._evts.get(dt);
                    if (evts == null) {
                        evts = new LinkedList<Event>();
                        this._evts.put(dt, evts);
                    }
                    evts.add(evt);
                }
            }
        }
        if (!dts.isEmpty()) {
            Clients.response(null, (AuResponse)new AuEchoGlobal(cmd, null, dts));
        }
    }

    private void publishToCurrent(Event event) {
        DesktopEventQueue que = this.getDesktopEventQueue(false);
        if (que != null) {
            que.publish(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeCurrent(boolean unlisten) {
        QueueInfo qi;
        Desktop desktop = GroupEventQueue.getExecution().getDesktop();
        Map map = this._evts;
        synchronized (map) {
            this._evts.remove(desktop);
        }
        Map map2 = this._infs;
        synchronized (map2) {
            qi = (QueueInfo)this._infs.remove(desktop);
        }
        if (qi != null) {
            try {
                qi.queue.close();
            }
            catch (Throwable t) {
                log.warningBriefly("Failed to close " + qi.queue, t);
            }
            if (unlisten) {
                qi.unlisten(desktop);
            }
        }
    }

    private static class QueueInfo {
        private final DesktopEventQueue queue = new DesktopEventQueue();
        private final AuService _svc;
        private final DesktopCleanup _clean;

        private QueueInfo(Desktop desktop, AuService svc, DesktopCleanup clean) {
            this._svc = svc;
            desktop.addListener((Object)this._svc);
            this._clean = clean;
            desktop.addListener((Object)this._clean);
        }

        private void unlisten(Desktop desktop) {
            desktop.removeListener((Object)this._svc);
            desktop.removeListener((Object)this._clean);
        }
    }

    private class EQCleanup
    implements DesktopCleanup {
        private EQCleanup() {
        }

        public void cleanup(Desktop desktop) throws Exception {
            GroupEventQueue.this.closeCurrent(false);
        }
    }

    private class EQService
    implements AuService {
        private EQService() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean service(AuRequest request, boolean everError) {
            String nm = request.getCommand();
            if (GroupEventQueue.CMD_PUBLISH.equals(nm)) {
                List evts;
                Map map = GroupEventQueue.this._evts;
                synchronized (map) {
                    evts = (List)GroupEventQueue.this._evts.remove(request.getDesktop());
                }
                if (evts != null) {
                    Iterator it = evts.iterator();
                    while (it.hasNext()) {
                        GroupEventQueue.this.publishToCurrent((Event)it.next());
                    }
                }
                return true;
            }
            if (GroupEventQueue.CMD_CLOSE.equals(nm)) {
                GroupEventQueue.this.closeCurrent(true);
                return true;
            }
            return false;
        }
    }
}

