/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkmax.zul.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.ListIterator;
import java.util.Set;
import org.zkoss.lang.Strings;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Sessions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Deferrable;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.sys.ComponentsCtrl;
import org.zkoss.zk.ui.sys.UiEngine;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listgroup;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.ListitemRenderer;
import org.zkoss.zul.event.DataLoadingEvent;
import org.zkoss.zul.event.ListDataEvent;
import org.zkoss.zul.ext.Paginal;
import org.zkoss.zul.impl.ListboxDataLoader;
import org.zkoss.zul.impl.Padding;

public class LiveListboxDataLoader
extends ListboxDataLoader {
    private transient EventListener _dataLoadingListener;
    private transient EventListener _onTopPadListener;
    private transient int _offset;
    private transient int _limit = 40;
    private transient int _oldTotalSize;
    private transient boolean _renderAll;

    public void init(Component owner, int offset, int limit) {
        super.init(owner, offset, limit);
        this._offset = offset;
        this._limit = limit;
        this.addDataLoadingListener(owner);
        this.addOnTopPadListener(owner);
    }

    public void reset() {
        this.removeDataLoadingListener(this.getOwner());
        this.removeOnTopPadListener(this.getOwner());
    }

    public int getOffset() {
        return this._offset;
    }

    public int getLimit() {
        Listbox listbox = this.getListbox();
        return listbox != null && this.inPagingMold() ? listbox.getPaginal().getPageSize() : this._limit;
    }

    private Listbox getListbox() {
        return (Listbox)this.getOwner();
    }

    public void doListDataChange(ListDataEvent event) {
        if (!this.isCropper()) {
            super.doListDataChange(event);
        } else {
            this.doLiveListDataChange(event);
        }
        this.updateModelSize();
    }

    private void doLiveListDataChange(ListDataEvent event) {
        int newsz = event.getModel().getSize();
        int oldsz = this._oldTotalSize;
        int endindex = this._offset + this._limit - 1;
        this._oldTotalSize = newsz;
        int min = event.getIndex0();
        int max = event.getIndex1();
        switch (event.getType()) {
            case 1: {
                int cnt = newsz - oldsz;
                if (cnt <= 0) {
                    throw new UiException("Adding causes a smaller list?");
                }
                if (min > endindex) break;
                this.syncModel(-1, -1);
                break;
            }
            case 2: {
                int cnt = oldsz - newsz;
                if (cnt <= 0) {
                    throw new UiException("Removal causes a larger list? oldsz:" + oldsz + ", newsz:" + newsz);
                }
                if (min >= 0) {
                    max = min + cnt - 1;
                } else if (max < 0) {
                    min = 0;
                    max = cnt - 1;
                }
                if (max > oldsz - 1) {
                    max = oldsz - 1;
                }
                if (min > endindex) break;
                int fillsz = newsz - (max > endindex ? max : endindex);
                if (fillsz < cnt) {
                    min = this._offset - (cnt -= fillsz);
                    if (min < 0) {
                        min = 0;
                    }
                    if (min != this._offset) {
                        this.syncModel(min, this._limit);
                        break;
                    }
                    this.syncModel(-1, -1);
                    break;
                }
                this.syncModel(-1, -1);
                break;
            }
            case 7: {
                Listbox listbox = this.getListbox();
                ((Padding)listbox.getExtraCtrl()).setHeight(-1);
                this.syncModel(-1, -1);
                listbox.invalidate();
                break;
            }
            default: {
                this.syncData(min, max < 0 ? -1 : max - min + 1);
            }
        }
    }

    private void syncData(int offset, int limit) {
        if (!this.isCropper() || this._renderAll) {
            super.syncModel(offset, limit);
        } else {
            this.loadModel(-1, -1);
        }
    }

    private void updateModelSize() {
        Listbox listbox = this.getListbox();
        ListModel model = listbox.getModel();
        if (model != null) {
            this._oldTotalSize = model.getSize();
        }
        if (this.inPagingMold()) {
            Paginal pgi = listbox.getPaginal();
            pgi.setTotalSize(this.getTotalSize());
        }
    }

    public void syncModel(int offset, int limit) {
        this.updateModelSize();
        if (!this.isCropper() || this._renderAll) {
            super.syncModel(offset, limit);
        } else {
            this.loadModel(offset, limit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadModel(int offset, int limit) {
        int min = limit < 0 ? (this._offset < 0 ? 0 : this._offset) : (offset < 0 ? 0 : offset);
        int pgsz = limit < 0 ? this._limit : limit;
        Listbox listbox = this.getListbox();
        ListModel model = listbox.getModel();
        int tsz = model.getSize();
        int max = min + pgsz - 1;
        if (this.inPagingMold()) {
            Paginal pgi = listbox.getPaginal();
            pgsz = pgi.getPageSize();
            max = min + pgsz - 1;
            if (max >= tsz) {
                max = tsz - 1;
                min = max - max % pgsz;
            } else {
                min -= min % pgsz;
            }
        }
        if (min != this._offset || pgsz != this._limit || limit < 0 || offset < 0) {
            listbox.setAttribute("org.zkoss.zul.loadingModel", (Object)Boolean.TRUE);
            try {
                listbox.getItems().clear();
                this._offset = min;
                this._limit = pgsz;
                ListitemRenderer renderer = (ListitemRenderer)this.getRealRenderer();
                while (min <= max && min < tsz) {
                    Listitem row = this.newUnloadedItem(renderer, min);
                    listbox.insertBefore((Component)row, null);
                    ++min;
                }
            }
            finally {
                listbox.setAttribute("org.zkoss.zul.loadingModel", null);
            }
        }
    }

    private void loadModelAndRenderItems(int offset, int limit) {
        Listbox listbox = this.getListbox();
        ListModel model = listbox.getModel();
        if (model != null && !this._renderAll) {
            this.loadModel(offset, limit);
        } else {
            this._offset = offset;
            this._limit = limit;
        }
        int pgsz = limit;
        int ofs = offset;
        LinkedHashSet<Object> items = new LinkedHashSet<Object>();
        if (model != null) {
            if (!this._renderAll) {
                Iterator it = listbox.getItems().iterator();
                while (it.hasNext()) {
                    Listitem row = (Listitem)it.next();
                    items.add(row);
                }
            } else {
                ListIterator it = listbox.getItems().listIterator(offset);
                while (it.hasNext() && limit > 0) {
                    Listitem row = (Listitem)it.next();
                    items.add(row);
                    --limit;
                }
            }
        } else {
            Component item = (Component)listbox.getItems().get(0);
            while (item != null && pgsz != 0) {
                Listgroup g;
                if (item.isVisible() && item instanceof Listitem && --ofs < 0) {
                    --pgsz;
                    items.add(item);
                }
                if (item instanceof Listgroup && !(g = (Listgroup)item).isOpen()) {
                    int len = g.getItemCount();
                    for (int j = 0; j < len; ++j) {
                        item = (Listitem)item.getNextSibling();
                    }
                }
                if (item == null) continue;
                item = item.getNextSibling();
            }
        }
        listbox.renderItems(items);
        this.updateModelInfo();
    }

    private void smartUpdate(Component comp, String key, Object value) {
        ((WebAppCtrl)Sessions.getCurrent().getWebApp()).getUiEngine().addSmartUpdate(comp, key, value, false);
    }

    private void removeDataLoadingListener(Component owner) {
        if (this._dataLoadingListener != null) {
            owner.removeEventListener("onDataLoading", this._dataLoadingListener);
            this._dataLoadingListener = null;
        }
    }

    private void addDataLoadingListener(Component owner) {
        if (this._dataLoadingListener == null) {
            this._dataLoadingListener = new EventListener(){

                public void onEvent(Event event) {
                    Listitem sel;
                    Listbox listbox = (Listbox)event.getTarget();
                    if (LiveListboxDataLoader.this.inPagingMold()) {
                        return;
                    }
                    DataLoadingEvent evt = (DataLoadingEvent)event;
                    int offset = evt.getOffset();
                    int limit = evt.getLimit();
                    LiveListboxDataLoader.this.smartUpdate((Component)listbox, "_scrolling", Boolean.TRUE);
                    LiveListboxDataLoader.this.loadModelAndRenderItems(offset, limit);
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("offset", new Integer(LiveListboxDataLoader.this.getOffset()));
                    if (!listbox.isMultiple() && (sel = listbox.getSelectedItem()) != null) {
                        map.put("sel", sel.getUuid());
                    }
                    LiveListboxDataLoader.this.smartUpdate((Component)listbox, "scrollPads_", map);
                }
            };
            owner.addEventListener("onDataLoading", this._dataLoadingListener);
        }
    }

    private void removeOnTopPadListener(Component owner) {
        if (this._onTopPadListener != null) {
            owner.removeEventListener("onTopPad", this._onTopPadListener);
            this._onTopPadListener = null;
        }
    }

    private void addOnTopPadListener(Component owner) {
        if (this._onTopPadListener == null) {
            this._onTopPadListener = new TopPadListener();
            owner.addEventListener("onTopPad", this._onTopPadListener);
        }
    }

    public void updateModelInfo() {
        boolean attached;
        Listbox listbox = this.getListbox();
        boolean bl = attached = listbox.getAttribute("zkoss.Listbox.attached") != null;
        if (!(this.inSelectMold() || attached || listbox.isInvalidated())) {
            UiEngine engine;
            Page page = listbox.getPage();
            UiEngine uiEngine = engine = page == null ? null : ((WebAppCtrl)page.getDesktop().getWebApp()).getUiEngine();
            if (engine != null) {
                Executions.getCurrent().setAttribute("zkoss.Listbox.updateModelInfo_" + listbox.getUuid(), (Object)Boolean.TRUE);
                engine.addSmartUpdate((Component)listbox, "itemsInvalid_", (Object)ComponentsCtrl.redraw((Collection)listbox.getItems()), false);
                engine.addSmartUpdate((Component)listbox, "_offset", (Object)new Integer(this.getOffset()), false);
                engine.addSmartUpdate((Component)listbox, "totalSize", (Object)new Integer(this.getTotalSize()), false);
            }
        }
    }

    public void setLoadAll(boolean b) {
        if (this._renderAll != b) {
            ListModel model;
            Listbox listbox;
            this._renderAll = b;
            if (b && (listbox = this.getListbox()) != null && (model = listbox.getModel()) != null) {
                this.syncModel(-1, -1);
            }
        }
    }

    public boolean isCropper() {
        Listbox listbox = this.getListbox();
        if (listbox != null) {
            String height = listbox.getHeight();
            boolean isVflex = listbox.isVflex();
            String vflex = listbox.getVflex();
            return !this.inSelectMold() && (isVflex || "min".equals(vflex) || !Strings.isBlank((String)height) || listbox.getRows() > 0 || this.inPagingMold() && listbox.getModel() != null || super.isCropper());
        }
        return false;
    }

    public Set getAvailableAtClient() {
        Listbox listbox = this.getListbox();
        if (listbox != null) {
            boolean everUpdateModelInfo;
            boolean attached = Executions.getCurrent().getAttribute("zkoss.Listbox.attached_" + listbox.getUuid()) != null;
            boolean bl = everUpdateModelInfo = Executions.getCurrent().getAttribute("zkoss.Listbox.updateModelInfo_" + listbox.getUuid()) != null;
            if (this.isCropper()) {
                ListModel model = listbox.getModel();
                if (model == null && this.inPagingMold()) {
                    return super.getAvailableAtClient();
                }
                if (everUpdateModelInfo && !attached && !listbox.isInvalidated()) {
                    if (model != null) {
                        return this.getAvailableAtClient(0, 0);
                    }
                    return this.getAvailableAtClient(this.getOffset(), this.getLimit());
                }
                return this.getAvailableAtClient(model != null && !this._renderAll ? 0 : this.getOffset(), this.getLimit());
            }
        }
        return null;
    }

    private static class TopPadListener
    implements EventListener,
    Deferrable {
        private TopPadListener() {
        }

        public void onEvent(Event event) throws Exception {
            ((Padding)((Listbox)event.getTarget()).getExtraCtrl()).setHeight(((Integer)event.getData()).intValue());
        }

        public boolean isDeferrable() {
            return true;
        }
    }
}

