/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.zkoss.io.Serializables;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.event.ListDataEvent;
import org.zkoss.zul.event.ListDataListener;
import org.zkoss.zul.ext.Selectable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractListModel<E>
implements ListModel<E>,
Selectable<E>,
Serializable {
    private transient List<ListDataListener> _listeners = new LinkedList<ListDataListener>();
    private Set<E> _selection = new HashSet();

    protected void fireEvent(int type, int index0, int index1) {
        ListDataEvent evt = new ListDataEvent(this, type, index0, index1);
        for (ListDataListener l : this._listeners) {
            l.onChange(evt);
        }
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        if (l == null) {
            throw new NullPointerException();
        }
        this._listeners.add(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this._listeners.remove(l);
    }

    @Override
    public Set<E> getSelection() {
        return Collections.unmodifiableSet(this._selection);
    }

    @Override
    public void addSelection(E obj) {
        this._selection.add(obj);
    }

    @Override
    public void removeSelection(Object obj) {
        this._selection.remove(obj);
    }

    @Override
    public void clearSelection() {
        this._selection.clear();
    }

    protected void removeAllSelection(Collection<?> c) {
        this._selection.removeAll(c);
    }

    protected void retainAllSelection(Collection<?> c) {
        this._selection.retainAll(c);
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Serializables.smartWrite((ObjectOutputStream)s, this._listeners);
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this._listeners = new LinkedList<ListDataListener>();
        Serializables.smartRead((ObjectInputStream)s, this._listeners);
    }
}

