/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.zkoss.io.Serializables;
import org.zkoss.lang.Objects;
import org.zkoss.zul.Tree;
import org.zkoss.zul.TreeModel;
import org.zkoss.zul.event.TreeDataEvent;
import org.zkoss.zul.event.TreeDataListener;
import org.zkoss.zul.ext.Openable;
import org.zkoss.zul.ext.Selectable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTreeModel<E>
implements TreeModel<E>,
Selectable<E>,
Openable<E>,
Serializable {
    private E _root;
    private transient List<TreeDataListener> _listeners = new LinkedList<TreeDataListener>();
    private Set<E> _selection = new HashSet();
    private Set<E> _openSet = new HashSet();

    public AbstractTreeModel(E root) {
        this._root = root;
    }

    @Override
    public E getRoot() {
        return this._root;
    }

    public void fireEvent(E node, int indexFrom, int indexTo, int evtType) {
        TreeDataEvent<E> evt = new TreeDataEvent<E>(this, evtType, node, indexFrom, indexTo);
        for (TreeDataListener l : this._listeners) {
            l.onChange(evt);
        }
    }

    @Override
    public int getIndexOfChild(E parent, E child) {
        int cnt = this.getChildCount(parent);
        for (int j = 0; j < cnt; ++j) {
            if (!Objects.equals(child, this.getChild(parent, j))) continue;
            return j;
        }
        return -1;
    }

    @Override
    public void addTreeDataListener(TreeDataListener l) {
        this._listeners.add(l);
    }

    @Override
    public void removeTreeDataListener(TreeDataListener l) {
        this._listeners.remove(l);
    }

    @Override
    public Set<E> getSelection() {
        return Collections.unmodifiableSet(this._selection);
    }

    @Override
    public void addSelection(E obj) {
        this._selection.add(obj);
    }

    @Override
    public void removeSelection(Object obj) {
        this._selection.remove(obj);
    }

    @Override
    public void clearSelection() {
        this._selection.clear();
    }

    protected void removeAllSelection(Collection<? extends E> c) {
        this._selection.removeAll(c);
    }

    protected void retainAllSelection(Collection<? extends E> c) {
        this._selection.retainAll(c);
    }

    @Override
    public void setOpen(E obj, boolean open) {
        if (open) {
            this._openSet.add(obj);
        } else {
            this._openSet.remove(obj);
        }
    }

    @Override
    public boolean isOpen(E obj) {
        return this._openSet.contains(obj);
    }

    @Override
    public void clearOpen() {
        this._openSet.clear();
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Serializables.smartWrite((ObjectOutputStream)s, this._listeners);
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this._listeners = new LinkedList<TreeDataListener>();
        Serializables.smartRead((ObjectInputStream)s, this._listeners);
    }

    @Override
    public int[] getPath(Object parent, Object lastNode) {
        return Tree.getPath(this, parent, lastNode);
    }
}

