/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.zkoss.lang.Library;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.Center;
import org.zkoss.zul.East;
import org.zkoss.zul.LayoutRegion;
import org.zkoss.zul.North;
import org.zkoss.zul.South;
import org.zkoss.zul.West;

public class Borderlayout
extends HtmlBasedComponent {
    public static final String NORTH = "north";
    public static final String SOUTH = "south";
    public static final String EAST = "east";
    public static final String WEST = "west";
    public static final String CENTER = "center";
    private transient North _north;
    private transient South _south;
    private transient West _west;
    private transient East _east;
    private transient Center _center;
    private boolean _animationDisabled = Borderlayout.isDefaultAnimationDisabled();
    private static Boolean _defAnimation;

    private static boolean isDefaultAnimationDisabled() {
        if (_defAnimation == null) {
            _defAnimation = Boolean.valueOf(Library.getProperty((String)"org.zkoss.zul.borderlayout.animation.disabed", (String)"false"));
        }
        return _defAnimation;
    }

    public boolean isAnimationDisabled() {
        return this._animationDisabled;
    }

    public void setAnimationDisabled(boolean animationDisabled) {
        if (this._animationDisabled != animationDisabled) {
            this._animationDisabled = animationDisabled;
            this.smartUpdate("_animationDisabled", animationDisabled);
        }
    }

    public North getNorth() {
        return this._north;
    }

    public South getSouth() {
        return this._south;
    }

    public West getWest() {
        return this._west;
    }

    public East getEast() {
        return this._east;
    }

    public Center getCenter() {
        return this._center;
    }

    public void resize() {
        this.smartUpdate("resize", true);
    }

    public void beforeChildAdded(Component child, Component refChild) {
        if (!(child instanceof LayoutRegion)) {
            throw new UiException("Unsupported child for Borderlayout: " + child);
        }
        if (child instanceof North) {
            if (this._north != null && child != this._north) {
                throw new UiException("Only one north child is allowed: " + (Object)((Object)this));
            }
        } else if (child instanceof South) {
            if (this._south != null && child != this._south) {
                throw new UiException("Only one south child is allowed: " + (Object)((Object)this));
            }
        } else if (child instanceof West) {
            if (this._west != null && child != this._west) {
                throw new UiException("Only one west child is allowed: " + (Object)((Object)this));
            }
        } else if (child instanceof East) {
            if (this._east != null && child != this._east) {
                throw new UiException("Only one east child is allowed: " + (Object)((Object)this));
            }
        } else if (child instanceof Center && this._center != null && child != this._center) {
            throw new UiException("Only one center child is allowed: " + (Object)((Object)this));
        }
        super.beforeChildAdded(child, refChild);
    }

    public boolean insertBefore(Component child, Component refChild) {
        if (child instanceof North) {
            if (!super.insertBefore(child, refChild)) {
                return false;
            }
            this._north = (North)child;
        } else if (child instanceof South) {
            if (!super.insertBefore(child, refChild)) {
                return false;
            }
            this._south = (South)child;
        } else if (child instanceof West) {
            if (!super.insertBefore(child, refChild)) {
                return false;
            }
            this._west = (West)child;
        } else if (child instanceof East) {
            if (!super.insertBefore(child, refChild)) {
                return false;
            }
            this._east = (East)child;
        } else if (child instanceof Center) {
            if (!super.insertBefore(child, refChild)) {
                return false;
            }
            this._center = (Center)child;
        } else if (!super.insertBefore(child, refChild)) {
            return false;
        }
        return true;
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "_animationDisabled", this._animationDisabled);
    }

    public void onChildRemoved(Component child) {
        super.onChildRemoved(child);
        if (this._north == child) {
            this._north = null;
        } else if (this._south == child) {
            this._south = null;
        } else if (this._west == child) {
            this._west = null;
        } else if (this._east == child) {
            this._east = null;
        } else if (this._center == child) {
            this._center = null;
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-borderlayout" : this._zclass;
    }

    public Object clone() {
        Borderlayout clone = (Borderlayout)((Object)super.clone());
        clone.afterUnmarshal();
        return clone;
    }

    private void afterUnmarshal() {
        for (Object child : this.getChildren()) {
            if (child instanceof North) {
                this._north = (North)((Object)child);
                continue;
            }
            if (child instanceof South) {
                this._south = (South)((Object)child);
                continue;
            }
            if (child instanceof Center) {
                this._center = (Center)((Object)child);
                continue;
            }
            if (child instanceof West) {
                this._west = (West)((Object)child);
                continue;
            }
            if (!(child instanceof East)) continue;
            this._east = (East)((Object)child);
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.afterUnmarshal();
    }
}

