/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.zkoss.util.CollectionsX;
import org.zkoss.zul.DefaultTreeModel;
import org.zkoss.zul.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTreeNode<E>
implements TreeNode<E>,
Comparable<DefaultTreeNode<E>>,
Serializable {
    private DefaultTreeModel<E> _model;
    private DefaultTreeNode<E> _parent;
    private final List<TreeNode<E>> _children;
    private E _data;
    private boolean _maxnull;

    public DefaultTreeNode(E data, Collection<? extends TreeNode<E>> children) {
        this(data, children, false);
    }

    public DefaultTreeNode(E data, Collection<? extends TreeNode<E>> children, boolean nullAsMax) {
        this._data = data;
        this._children = new TreeNodeChildrenList();
        if (children != null) {
            for (TreeNode<E> node : children) {
                this.add(node);
            }
        }
        this._maxnull = nullAsMax;
    }

    public DefaultTreeNode(E data, TreeNode<E>[] children) {
        this(data, (Collection<TreeNode<E>>)new CollectionsX.ArrayCollection((Object[])children));
    }

    public DefaultTreeNode(E data) {
        this(data, false);
    }

    public DefaultTreeNode(E data, boolean nullAsMax) {
        this._data = data;
        this._children = null;
        this._maxnull = nullAsMax;
    }

    public void removeFromParent() {
        if (this._parent != null) {
            this._parent.remove(this);
        }
    }

    @Override
    public DefaultTreeModel<E> getModel() {
        return this._parent != null ? this._parent.getModel() : this._model;
    }

    @Override
    public void setModel(DefaultTreeModel<E> model) {
        if (model != null && this._parent != null) {
            throw new IllegalStateException("Only root allowed, " + this);
        }
        this._model = model;
    }

    @Override
    public E getData() {
        return this._data;
    }

    @Override
    public void setData(E data) {
        this._data = data;
        DefaultTreeModel<TreeNode<E>> model = this.getModel();
        TreeNode<E> parent = this.getParent();
        if (model != null && parent != null) {
            int index = parent.getIndex(this);
            model.fireEvent(parent, index, index, 0);
        }
    }

    @Override
    public List<? extends TreeNode<E>> getChildren() {
        return this.isLeaf() ? null : this._children;
    }

    @Override
    public TreeNode<E> getChildAt(int childIndex) {
        return childIndex >= 0 && childIndex < this.getChildCount() ? this._children.get(childIndex) : null;
    }

    @Override
    public int getChildCount() {
        return this.isLeaf() ? 0 : this._children.size();
    }

    @Override
    public TreeNode<E> getParent() {
        return this._parent;
    }

    protected void setParent(DefaultTreeNode<E> parent) {
        this._parent = parent;
    }

    @Override
    public int getIndex(TreeNode<E> node) {
        return this.isLeaf() ? -1 : this._children.indexOf(node);
    }

    @Override
    public boolean isLeaf() {
        return this._children == null;
    }

    @Override
    public void insert(TreeNode<E> child, int index) {
        if (this.isLeaf()) {
            throw new UnsupportedOperationException("Child is not allowed in leaf node");
        }
        this._children.add(index, child);
    }

    @Override
    public void add(TreeNode<E> child) {
        this.insert(child, this.getChildCount());
    }

    private static boolean isAncestor(TreeNode p, TreeNode c) {
        do {
            if (p != c) continue;
            return true;
        } while ((c = c.getParent()) != null);
        return false;
    }

    @Override
    public void remove(int index) {
        if (this.isLeaf()) {
            throw new UnsupportedOperationException("Child is not allowed in leaf node");
        }
        this._children.remove(index);
    }

    @Override
    public void remove(TreeNode<E> child) {
        if (this.isLeaf()) {
            throw new UnsupportedOperationException("Child is not allowed in leaf node");
        }
        if (!this._children.remove(child)) {
            throw new IllegalArgumentException("not a child of this node");
        }
    }

    @Override
    public int compareTo(DefaultTreeNode<E> node) {
        if (this._data == null) {
            return node == null ? 0 : (node.getData() == null ? 0 : (this._maxnull ? 1 : -1));
        }
        if (node == null) {
            return this._maxnull ? -1 : 1;
        }
        return ((Comparable)this._data).compareTo(node.getData());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class TreeNodeChildrenList
    extends AbstractList<TreeNode<E>> {
        protected final ArrayList<TreeNode<E>> _list = new ArrayList();

        protected TreeNodeChildrenList() {
        }

        @Override
        public TreeNode<E> get(int index) {
            return this._list.get(index);
        }

        @Override
        public int size() {
            return this._list.size();
        }

        @Override
        public void add(int index, TreeNode<E> child) {
            DefaultTreeModel<DefaultTreeNode> model;
            if (DefaultTreeNode.isAncestor(child, DefaultTreeNode.this)) {
                throw new IllegalArgumentException("New child is an ancestor");
            }
            TreeNode oldp = child.getParent();
            if (oldp != null) {
                oldp.remove(child);
            }
            this._list.add(index, child);
            if (child instanceof DefaultTreeNode) {
                ((DefaultTreeNode)child).setParent(DefaultTreeNode.this);
            }
            if ((model = DefaultTreeNode.this.getModel()) != null) {
                model.fireEvent(DefaultTreeNode.this, index, index, 1);
            }
        }

        @Override
        public TreeNode<E> remove(int index) {
            DefaultTreeModel model;
            TreeNode child = this._list.remove(index);
            if (child instanceof DefaultTreeNode) {
                ((DefaultTreeNode)child).setParent(null);
            }
            if ((model = DefaultTreeNode.this.getModel()) != null) {
                model.fireEvent(DefaultTreeNode.this, index, index, 2);
                model.removeSelection(child);
                model.setOpen(child, false);
            }
            return child;
        }

        @Override
        public boolean remove(Object child) {
            int index = this._list.indexOf(child);
            if (index < 0) {
                return false;
            }
            this.remove(index);
            return true;
        }
    }
}

