/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.impl.NumberInputElement;
import org.zkoss.zul.mesg.MZul;

public class Doublebox
extends NumberInputElement {
    public Doublebox() {
        this.setCols(11);
    }

    public Doublebox(double value) throws WrongValueException {
        this();
        this.setValue(value);
    }

    public Doublebox(Double value) throws WrongValueException {
        this();
        this.setValue(value);
    }

    public Double getValue() throws WrongValueException {
        return (Double)this.getTargetValue();
    }

    public double doubleValue() throws WrongValueException {
        Object val = this.getTargetValue();
        return val != null ? (Double)val : 0.0;
    }

    public int intValue() throws WrongValueException {
        Object val = this.getTargetValue();
        return val != null ? ((Double)val).intValue() : 0;
    }

    public long longValue() throws WrongValueException {
        Object val = this.getTargetValue();
        return val != null ? ((Double)val).longValue() : 0L;
    }

    public short shortValue() throws WrongValueException {
        Object val = this.getTargetValue();
        return val != null ? ((Double)val).shortValue() : (short)0;
    }

    public void setValue(Double value) throws WrongValueException {
        this.validate(value);
        this.setRawValue(value);
    }

    public void setValue(double value) throws WrongValueException {
        this.setValue(new Double(value));
    }

    public String getZclass() {
        return this._zclass == null ? "z-doublebox" : this._zclass;
    }

    public Object unmarshall(Object value) {
        return value instanceof Number ? new Double(((Number)value).doubleValue()) : value;
    }

    protected Object coerceFromString(String value) throws WrongValueException {
        Object[] vals = this.toNumberOnly(value);
        String val = (String)vals[0];
        if (val == null || val.length() == 0) {
            return null;
        }
        try {
            int divscale;
            double v = Double.parseDouble(val);
            int n = divscale = vals[1] != null ? (Integer)vals[1] : 0;
            if (divscale > 0) {
                v /= Math.pow(10.0, divscale);
            }
            return new Double(v);
        }
        catch (NumberFormatException ex) {
            throw this.showCustomError(new WrongValueException((Component)this, MZul.NUMBER_REQUIRED, (Object)value));
        }
    }

    protected String coerceToString(Object value) {
        return value != null && this.getFormat() == null ? value.toString() : this.formatNumber(value, null);
    }
}

