/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import org.zkoss.lang.Strings;
import org.zkoss.lang.reflect.Fields;
import org.zkoss.util.CollectionsX;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zul.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldComparator
implements Comparator,
Serializable {
    private static final long serialVersionUID = 20090120111922L;
    private Collection<FieldInfo> _fieldnames;
    private transient String _orderBy;
    private String _rawOrderBy;
    private boolean _maxnull;
    private boolean _ascending;

    public FieldComparator(String orderBy, boolean ascending) {
        this(orderBy, ascending, false);
    }

    public FieldComparator(String orderBy, boolean ascending, boolean nullAsMax) {
        if (Strings.isBlank((String)orderBy)) {
            throw new UiException("Empty fieldnames: " + orderBy);
        }
        this._fieldnames = this.parseFieldNames(orderBy, ascending);
        this._maxnull = nullAsMax;
        this._rawOrderBy = orderBy;
        this._ascending = ascending;
    }

    public int compare(Object o1, Object o2) {
        try {
            for (FieldInfo fi : this._fieldnames) {
                int res = this.compare0(o1, o2, fi.fieldname, fi.asc, fi.func);
                if (res == 0) continue;
                return res;
            }
            return 0;
        }
        catch (NoSuchMethodException ex) {
            throw UiException.Aide.wrap((Throwable)ex);
        }
    }

    public String getOrderBy() {
        if (this._orderBy == null) {
            StringBuffer sb = new StringBuffer(this._fieldnames.size() * 16);
            Iterator<FieldInfo> it = this._fieldnames.iterator();
            if (it.hasNext()) {
                this.appendField(sb, it.next());
            }
            while (it.hasNext()) {
                sb.append(",");
                this.appendField(sb, it.next());
            }
            this._orderBy = sb.toString();
        }
        return this._orderBy;
    }

    public String getRawOrderBy() {
        return this._rawOrderBy;
    }

    public boolean isAscending() {
        return this._ascending;
    }

    private void appendField(StringBuffer sb, FieldInfo fi) {
        if (fi.func != null) {
            sb.append(fi.func).append('(').append(fi.fieldname).append(')');
        } else {
            sb.append(fi.fieldname);
        }
        sb.append(fi.asc ? " ASC" : " DESC");
    }

    private int compare0(Object o1, Object o2, String fieldname, boolean asc, String func) throws NoSuchMethodException {
        Object f1 = o1 instanceof Map ? ((Map)o1).get(fieldname) : Fields.getByCompound((Object)this.getCompareObject(o1), (String)fieldname);
        Object f2 = o2 instanceof Map ? ((Map)o2).get(fieldname) : Fields.getByCompound((Object)this.getCompareObject(o2), (String)fieldname);
        Object v1 = this.handleFunction(f1, func);
        Object v2 = this.handleFunction(f2, func);
        if (v1 == null) {
            return v2 == null ? 0 : (this._maxnull ? 1 : -1);
        }
        if (v2 == null) {
            return this._maxnull ? -1 : 1;
        }
        int v = ((Comparable)v1).compareTo(v2);
        return asc ? v : -v;
    }

    private Object getCompareObject(Object o) {
        if (o instanceof TreeNode) {
            return ((TreeNode)o).getData();
        }
        return o;
    }

    private Object handleFunction(Object c, String func) {
        if ("UPPER".equals(func)) {
            if (c instanceof String) {
                return ((String)c).toUpperCase();
            }
            if (c instanceof Character) {
                return new Character(Character.toUpperCase(((Character)c).charValue()));
            }
        } else if ("LOWER".equals(func)) {
            if (c instanceof String) {
                return ((String)c).toLowerCase();
            }
            if (c instanceof Character) {
                return new Character(Character.toLowerCase(((Character)c).charValue()));
            }
        }
        return c;
    }

    private Collection<FieldInfo> parseFieldNames(String fieldnames, boolean ascending) {
        Collection fields = CollectionsX.parse(new ArrayList(), (String)fieldnames, (char)',');
        ArrayList<FieldInfo> results = new ArrayList<FieldInfo>(fields.size());
        Iterator it = fields.iterator();
        while (it.hasNext()) {
            boolean asc;
            String fieldname;
            String field = ((String)it.next()).trim();
            String ascstr = "asc";
            String func = null;
            String ufn = field.toUpperCase();
            if (ufn.startsWith("UPPER(") || ufn.startsWith("LOWER(")) {
                int k = field.lastIndexOf(41);
                if (k == 0) {
                    throw new UiException("No closing function ')' mark: " + field);
                }
                if (k == 6) {
                    throw new UiException("No data inside function: " + field);
                }
                fieldname = field.substring(6, k);
                if (k + 1 < field.length() && Strings.isBlank((String)(ascstr = field.substring(k + 1)))) {
                    ascstr = "asc";
                }
                func = ufn.substring(0, 5);
            } else {
                int j = field.indexOf(32);
                if (j < 0) {
                    fieldname = field;
                } else {
                    fieldname = field.substring(0, j);
                    ascstr = field.substring(j + 1);
                }
            }
            if ("asc".equalsIgnoreCase(ascstr)) {
                asc = ascending;
            } else if ("desc".equalsIgnoreCase(ascstr)) {
                asc = !ascending;
            } else {
                throw new UiException("field must be in the form of \"field ASC\" or \"field DESC\":" + ascstr);
            }
            results.add(new FieldInfo(fieldname, asc, func));
        }
        return results;
    }

    private static class FieldInfo
    implements Serializable {
        private String fieldname;
        private boolean asc;
        private String func;

        public FieldInfo(String fieldname, boolean asc, String func) {
            this.fieldname = fieldname;
            this.asc = asc;
            this.func = func;
        }
    }
}

