/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.OpenEvent;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listfoot;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.impl.GroupsListModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Listgroup
extends Listitem {
    private boolean _open = true;
    private transient List<Listitem> _items;

    public Listgroup() {
        this.init();
    }

    public Listgroup(String label) {
        this();
        this.setLabel(label);
    }

    public <T> Listgroup(String label, T value) {
        this();
        this.setLabel(label);
        this.setValue(value);
    }

    private void init() {
        this._items = new AbstractList<Listitem>(){

            @Override
            public int size() {
                return Listgroup.this.getItemCount();
            }

            @Override
            public Iterator<Listitem> iterator() {
                return new IterItems();
            }

            @Override
            public Listitem get(int index) {
                Listbox lb = Listgroup.this.getListbox();
                if (lb == null) {
                    throw new IndexOutOfBoundsException("Index: " + index);
                }
                return lb.getItemAtIndex(Listgroup.this.getIndex() + index + 1);
            }
        };
    }

    public List<Listitem> getItems() {
        return this._items;
    }

    public int getItemCount() {
        int[] g;
        Listbox lb = this.getListbox();
        if (lb != null && (g = lb.getGroupsInfoAt(this.getIndex(), true)) != null) {
            if (g[2] == -1) {
                return g[1] - 1;
            }
            return g[1] - 2;
        }
        return 0;
    }

    public int getVisibleItemCount() {
        int count = this.getItemCount();
        int visibleCount = 0;
        if (this.getNextSibling() instanceof Listitem) {
            for (Listitem item = (Listitem)this.getNextSibling(); count-- > 0 && item != null; item = (Listitem)item.getNextSibling()) {
                if (item.isVisible()) {
                    ++visibleCount;
                }
                if (!(item.getNextSibling() instanceof Listitem)) break;
            }
        }
        return visibleCount;
    }

    public int getListgroupfootIndex() {
        int[] g;
        Listbox lb = (Listbox)this.getParent();
        if (lb != null && (g = lb.getGroupsInfoAt(this.getIndex(), true)) != null) {
            return g[2];
        }
        return -1;
    }

    public Listfoot getListfoot() {
        int index = this.getListgroupfootIndex();
        if (index < 0) {
            return null;
        }
        Listbox lb = (Listbox)this.getParent();
        return (Listfoot)lb.getChildren().get(index);
    }

    public boolean isOpen() {
        return this._open;
    }

    public void setOpen(boolean open) {
        if (this._open != open) {
            this._open = open;
            this.smartUpdate("open", this._open);
            Listbox listbox = this.getListbox();
            if (listbox != null) {
                listbox.addVisibleItemCount(this.isOpen() ? this.getVisibleItemCount() : -this.getVisibleItemCount());
            }
        }
    }

    @Override
    public String getZclass() {
        return this._zclass == null ? "z-listgroup" : this._zclass;
    }

    @Override
    public Object clone() {
        Listgroup clone = (Listgroup)((Object)super.clone());
        clone.init();
        return clone;
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init();
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (!this.isOpen()) {
            renderer.render("open", false);
        }
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onOpen")) {
            OpenEvent evt = OpenEvent.getOpenEvent((AuRequest)request);
            this._open = evt.isOpen();
            Listbox listbox = this.getListbox();
            if (listbox != null) {
                listbox.addVisibleItemCount(this._open ? this.getVisibleItemCount() : -this.getVisibleItemCount());
                ListModel model = listbox.getModel();
                if (model instanceof GroupsListModel) {
                    ((GroupsListModel)model).getGroupsModel().setClose(listbox.getGroupIndex(this.getIndex()), !this._open);
                }
            }
            Events.postEvent((Event)evt);
        } else {
            super.service(request, everError);
        }
    }

    static {
        Listgroup.addClientEvent(Listgroup.class, (String)"onOpen", (int)8193);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IterItems
    implements Iterator<Listitem> {
        private final Iterator<Listitem> _it;
        private int _j;

        private IterItems() {
            this._it = Listgroup.this.getListbox().getItems().listIterator(Listgroup.this.getIndex() + 1);
        }

        @Override
        public boolean hasNext() {
            return this._j < Listgroup.this.getItemCount();
        }

        @Override
        public Listitem next() {
            ++this._j;
            return this._it.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

