/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.util.ArrayList;
import java.util.HashMap;
import org.zkoss.mesg.Messages;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.SerializableEventListener;
import org.zkoss.zul.impl.MessageboxDlg;
import org.zkoss.zul.mesg.MZul;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Messagebox {
    private static final Log log = Log.lookup(Messagebox.class);
    private static String _templ = "~./zul/html/messagebox.zul";
    public static final String QUESTION = "z-msgbox z-msgbox-question";
    public static final String EXCLAMATION = "z-msgbox z-msgbox-exclamation";
    public static final String INFORMATION = "z-msgbox z-msgbox-information";
    public static final String ERROR = "z-msgbox z-msgbox-error";
    public static final String NONE = null;
    public static final int OK = 1;
    public static final int CANCEL = 2;
    public static final int YES = 16;
    public static final int NO = 32;
    public static final int ABORT = 256;
    public static final int RETRY = 512;
    public static final int IGNORE = 1024;
    public static final String ON_YES = "onYes";
    public static final String ON_NO = "onNo";
    public static final String ON_RETRY = "onRetry";
    public static final String ON_ABORT = "onAbort";
    public static final String ON_IGNORE = "onIgnore";
    public static final String ON_OK = "onOK";
    public static final String ON_CANCEL = "onCancel";
    private static final Button[] DEFAULT_BUTTONS = new Button[]{Button.OK};

    public static Button show(String message, String title, Button[] buttons, String[] btnLabels, String icon, Button focus, EventListener<ClickEvent> listener) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("message", message);
        params.put("title", title != null ? title : Executions.getCurrent().getDesktop().getWebApp().getAppName());
        params.put("icon", icon);
        if (buttons == null || buttons.length == 0) {
            buttons = DEFAULT_BUTTONS;
        }
        int btnmask = 0;
        for (int j = 0; j < buttons.length; ++j) {
            if (buttons[j] == null) {
                throw new IllegalArgumentException("The " + j + "-th button is null");
            }
            btnmask += buttons[j].id;
            params.put(buttons[j].stringId, buttons[j].id);
        }
        params.put("buttons", btnmask);
        MessageboxDlg dlg = (MessageboxDlg)Executions.createComponents((String)_templ, null, params);
        dlg.setEventListener(listener);
        dlg.setButtons(buttons, btnLabels);
        if (focus != null) {
            dlg.setFocus(focus);
        }
        if (dlg.getDesktop().getWebApp().getConfiguration().isEventThreadEnabled()) {
            try {
                dlg.doModal();
            }
            catch (Throwable ex) {
                try {
                    dlg.detach();
                }
                catch (Throwable ex2) {
                    log.warningBriefly("Failed to detach when recovering from an error", ex2);
                }
                throw UiException.Aide.wrap((Throwable)ex);
            }
            return dlg.getResult();
        }
        dlg.doHighlighted();
        return Button.OK;
    }

    public static Button show(String message, String title, Button[] buttons, String icon, Button focus, EventListener<ClickEvent> listener) {
        return Messagebox.show(message, title, buttons, null, icon, focus, listener);
    }

    public static Button show(String message, String title, Button[] buttons, String icon, EventListener<ClickEvent> listener) {
        return Messagebox.show(message, title, buttons, null, icon, null, listener);
    }

    public static Button show(String message, Button[] buttons, EventListener<ClickEvent> listener) {
        return Messagebox.show(message, null, buttons, null, INFORMATION, null, listener);
    }

    public static int show(String message, String title, int buttons, String icon) {
        return Messagebox.show(message, title, buttons, icon, 0, null);
    }

    public static int show(String message, String title, int buttons, String icon, EventListener<Event> listener) {
        return Messagebox.show(message, title, buttons, icon, 0, listener);
    }

    public static int show(String message, String title, int buttons, String icon, int focus) {
        return Messagebox.show(message, title, buttons, icon, focus, null);
    }

    public static int show(String message, String title, int buttons, String icon, int focus, EventListener<Event> listener) {
        return Messagebox.show((String)message, (String)title, (Button[])Messagebox.toButtonTypes((int)buttons), null, (String)icon, (Button)(focus != 0 ? Messagebox.toButtonType((int)focus) : null), Messagebox.toButtonListener(listener)).id;
    }

    private static Button toButtonType(int btn) {
        switch (btn) {
            case 2: {
                return Button.CANCEL;
            }
            case 16: {
                return Button.YES;
            }
            case 32: {
                return Button.NO;
            }
            case 256: {
                return Button.ABORT;
            }
            case 512: {
                return Button.RETRY;
            }
            case 1024: {
                return Button.IGNORE;
            }
        }
        return Button.OK;
    }

    private static Button[] toButtonTypes(int buttons) {
        ArrayList<Button> btntypes = new ArrayList<Button>();
        if ((buttons & 1) != 0) {
            btntypes.add(Messagebox.toButtonType(1));
        }
        if ((buttons & 2) != 0) {
            btntypes.add(Messagebox.toButtonType(2));
        }
        if ((buttons & 0x10) != 0) {
            btntypes.add(Messagebox.toButtonType(16));
        }
        if ((buttons & 0x20) != 0) {
            btntypes.add(Messagebox.toButtonType(32));
        }
        if ((buttons & 0x200) != 0) {
            btntypes.add(Messagebox.toButtonType(512));
        }
        if ((buttons & 0x100) != 0) {
            btntypes.add(Messagebox.toButtonType(256));
        }
        if ((buttons & 0x400) != 0) {
            btntypes.add(Messagebox.toButtonType(1024));
        }
        return btntypes.toArray(new Button[btntypes.size()]);
    }

    private static EventListener<ClickEvent> toButtonListener(EventListener<Event> listener) {
        return listener != null ? new ButtonListener(listener) : null;
    }

    public static int show(String message) {
        return Messagebox.show(message, null, 1, INFORMATION, 0, null);
    }

    public static int show(int messageCode, Object[] args, int titleCode, int buttons, String icon) {
        return Messagebox.show(messageCode, args, titleCode, buttons, icon, 0, null);
    }

    public static int show(int messageCode, Object[] args, int titleCode, int buttons, String icon, int focus) {
        return Messagebox.show(messageCode, args, titleCode, buttons, icon, focus, null);
    }

    public static int show(int messageCode, Object[] args, int titleCode, int buttons, String icon, int focus, EventListener<Event> listener) {
        return Messagebox.show(Messages.get((int)messageCode, (Object[])args), titleCode > 0 ? Messages.get((int)titleCode) : null, buttons, icon, focus, listener);
    }

    public static int show(int messageCode, Object arg, int titleCode, int buttons, String icon) {
        return Messagebox.show(messageCode, arg, titleCode, buttons, icon, 0, null);
    }

    public static int show(int messageCode, Object arg, int titleCode, int buttons, String icon, int focus) {
        return Messagebox.show(messageCode, arg, titleCode, buttons, icon, focus, null);
    }

    public static int show(int messageCode, Object arg, int titleCode, int buttons, String icon, int focus, EventListener<Event> listener) {
        return Messagebox.show(Messages.get((int)messageCode, (Object)arg), titleCode > 0 ? Messages.get((int)titleCode) : null, buttons, icon, focus, listener);
    }

    public static int show(int messageCode, int titleCode, int buttons, String icon) {
        return Messagebox.show(messageCode, titleCode, buttons, icon, 0);
    }

    public static int show(int messageCode, int titleCode, int buttons, String icon, int focus) {
        return Messagebox.show(messageCode, titleCode, buttons, icon, focus, null);
    }

    public static int show(int messageCode, int titleCode, int buttons, String icon, int focus, EventListener<Event> listener) {
        return Messagebox.show(Messages.get((int)messageCode), titleCode > 0 ? Messages.get((int)titleCode) : null, buttons, icon, focus, listener);
    }

    public static void setTemplate(String uri) {
        if (uri == null || uri.length() == 0) {
            throw new IllegalArgumentException("empty");
        }
        _templ = uri;
    }

    public static String getTemplate() {
        return _templ;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ButtonListener
    implements SerializableEventListener<ClickEvent> {
        private final EventListener<Event> _listener;

        private ButtonListener(EventListener<Event> listener) {
            this._listener = listener;
        }

        public void onEvent(ClickEvent event) throws Exception {
            Button btn = event.getButton();
            this._listener.onEvent(new Event(event.getName(), event.getTarget(), (Object)(btn != null ? btn.id : -1)));
        }

        public String toString() {
            return this._listener.toString();
        }
    }

    public static class ClickEvent
    extends Event {
        public ClickEvent(String name, Component target, Button button) {
            super(name, target, (Object)button);
        }

        public Button getButton() {
            return (Button)((Object)this.getData());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Button {
        OK(1, "onOK", MZul.OK, "OK"),
        CANCEL(2, "onCancel", MZul.CANCEL, "CANCEL"),
        YES(16, "onYes", MZul.YES, "YES"),
        NO(32, "onNo", MZul.NO, "NO"),
        ABORT(256, "onAbort", MZul.ABORT, "ABORT"),
        RETRY(512, "onRetry", MZul.RETRY, "RETRY"),
        IGNORE(1024, "onIgnore", MZul.IGNORE, "IGNORE");

        public final int id;
        public final String event;
        public final int label;
        private final String stringId;

        private Button(int id, String event, int label, String stringId) {
            this.id = id;
            this.event = event;
            this.label = label;
            this.stringId = stringId;
        }
    }
}

