/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.lang.MutableInteger;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.Radio;
import org.zkoss.zul.impl.XulElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Radiogroup
extends XulElement {
    private String _orient = "horizontal";
    private String _name = this.genGroupName();
    private List<Radio> _externs;
    private int _jsel = -1;

    public String getOrient() {
        return this._orient;
    }

    public void setOrient(String orient) throws WrongValueException {
        if (!"horizontal".equals(orient) && !"vertical".equals(orient)) {
            throw new WrongValueException("orient cannot be " + orient);
        }
        if (!Objects.equals((Object)this._orient, (Object)orient)) {
            this._orient = orient;
            this.smartUpdate("orient", this._orient);
        }
    }

    public List<Radio> getItems() {
        LinkedList<Radio> items = new LinkedList<Radio>();
        Radiogroup.getItems0((Component)this, items);
        if (this._externs != null) {
            for (Radio radio : this._externs) {
                if (this.isRedudant(radio)) continue;
                items.add(radio);
            }
        }
        return items;
    }

    private static void getItems0(Component comp, List<Radio> items) {
        for (Component child : comp.getChildren()) {
            if (child instanceof Radio) {
                items.add((Radio)child);
                continue;
            }
            if (child instanceof Radiogroup) continue;
            Radiogroup.getItems0(child, items);
        }
    }

    public Radio getItemAtIndex(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Wrong index: " + index);
        }
        MutableInteger cur = new MutableInteger(0);
        Radio radio = Radiogroup.getAt((Component)this, cur, index);
        if (radio != null) {
            return radio;
        }
        if (this._externs != null) {
            for (Radio r : this._externs) {
                if (this.isRedudant(r) || cur.value++ != index) continue;
                return r;
            }
        }
        throw new IndexOutOfBoundsException(index + " out of 0.." + (cur.value - 1));
    }

    private static Radio getAt(Component comp, MutableInteger cur, int index) {
        for (Component child : comp.getChildren()) {
            Radio r;
            if (child instanceof Radio) {
                if (cur.value++ != index) continue;
                return (Radio)child;
            }
            if (child instanceof Radiogroup || (r = Radiogroup.getAt(child, cur, index)) == null) continue;
            return r;
        }
        return null;
    }

    private boolean isRedudant(Radio radio) {
        Radio p = radio;
        while ((p = p.getParent()) != null) {
            if (!(p instanceof Radiogroup)) continue;
            return p == this;
        }
        return false;
    }

    public int getItemCount() {
        int sum = Radiogroup.countItems((Component)this);
        if (this._externs != null) {
            for (Radio radio : this._externs) {
                if (this.isRedudant(radio)) continue;
                ++sum;
            }
        }
        return sum;
    }

    private static int countItems(Component comp) {
        int sum = 0;
        for (Component child : comp.getChildren()) {
            if (child instanceof Radio) {
                ++sum;
                continue;
            }
            if (child instanceof Radiogroup) continue;
            sum += Radiogroup.countItems(child);
        }
        return sum;
    }

    public int getSelectedIndex() {
        return this._jsel;
    }

    public void setSelectedIndex(int jsel) {
        if (jsel < 0) {
            jsel = -1;
        }
        if (this._jsel != jsel) {
            if (jsel < 0) {
                Radio r = this.getSelectedItem();
                if (r != null) {
                    r.setSelected(false);
                }
            } else {
                this.getItemAtIndex(jsel).setSelected(true);
            }
        }
    }

    public Radio getSelectedItem() {
        return this._jsel >= 0 ? this.getItemAtIndex(this._jsel) : null;
    }

    public void setSelectedItem(Radio item) {
        if (item == null) {
            this.setSelectedIndex(-1);
        } else {
            if (item.getRadiogroup() != this) {
                throw new UiException("Not a child: " + (Object)((Object)item));
            }
            item.setSelected(true);
        }
    }

    public Radio appendItem(String label, String value) {
        Radio item = new Radio();
        item.setLabel(label);
        item.setValue(value);
        item.setParent((Component)this);
        return item;
    }

    public Radio removeItemAt(int index) {
        Component p;
        Radio item = this.getItemAtIndex(index);
        if (item != null && !this.removeExternal(item) && (p = item.getParent()) != null) {
            p.removeChild((Component)item);
        }
        return item;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        if (name != null && name.length() == 0) {
            name = null;
        }
        if (!Objects.equals((Object)this._name, (Object)name)) {
            this._name = name;
            this.smartUpdate("name", this._name);
        }
    }

    void fixOnAdd(Radio child) {
        if (this._jsel >= 0 && child.isSelected()) {
            child.setSelected(false);
        } else {
            this.fixSelectedIndex();
        }
    }

    void fixOnRemove(Radio child) {
        if (child.isSelected()) {
            this._jsel = -1;
        } else if (this._jsel > 0) {
            this.fixSelectedIndex();
        }
    }

    void fixSelectedIndex() {
        MutableInteger cur = new MutableInteger(0);
        this._jsel = Radiogroup.fixSelIndex((Component)this, cur);
        if (this._jsel < 0 && this._externs != null) {
            for (Radio radio : this._externs) {
                if (this.isRedudant(radio)) continue;
                if (radio.isSelected()) {
                    this._jsel = cur.value;
                    break;
                }
                ++cur.value;
            }
        }
    }

    private static int fixSelIndex(Component comp, MutableInteger cur) {
        for (Component child : comp.getChildren()) {
            int jsel;
            if (child instanceof Radio) {
                if (((Radio)child).isSelected()) {
                    return cur.value;
                }
                ++cur.value;
                continue;
            }
            if (child instanceof Radiogroup || (jsel = Radiogroup.fixSelIndex(child, cur)) < 0) continue;
            return jsel;
        }
        return -1;
    }

    void addExternal(Radio radio) {
        if (this._externs == null) {
            this._externs = new LinkedList<Radio>();
        }
        this._externs.add(radio);
        if (!this.isRedudant(radio)) {
            this.fixOnAdd(radio);
        }
    }

    boolean removeExternal(Radio radio) {
        if (this._externs != null && this._externs.remove((Object)radio)) {
            if (!this.isRedudant(radio)) {
                this.fixOnRemove(radio);
            }
            return true;
        }
        return false;
    }

    private String genGroupName() {
        return Strings.encode((StringBuffer)new StringBuffer(16).append("_pg"), (int)System.identityHashCode((Object)this)).toString();
    }

    @Override
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (this._name != null) {
            this.render(renderer, "name", this._name);
        }
        if (!"horizontal".equals(this._orient)) {
            this.render(renderer, "orient", this._orient);
        }
    }

    @Override
    public Object clone() {
        Radiogroup clone = (Radiogroup)((Object)super.clone());
        Radiogroup.fixClone(clone);
        return clone;
    }

    private static void fixClone(Radiogroup clone) {
        if (clone._name.startsWith("_pg")) {
            clone._name = clone.genGroupName();
        }
    }

    static {
        Radiogroup.addClientEvent(Radiogroup.class, (String)"onCheck", (int)16385);
    }
}

