/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.util.ArraysX;
import org.zkoss.zul.AbstractListModel;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListSubModel;
import org.zkoss.zul.ext.Sortable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleListModel<E>
extends AbstractListModel<E>
implements Sortable<E>,
ListSubModel<E>,
Serializable {
    private static final long serialVersionUID = 20060707L;
    private final Object[] _data;

    public SimpleListModel(E[] data, boolean live) {
        this._data = live ? data : ArraysX.clone((Object[])data);
    }

    public SimpleListModel(E[] data) {
        this(data, false);
    }

    public SimpleListModel(List<? extends E> data) {
        this._data = data.toArray();
    }

    @Override
    public int getSize() {
        return this._data.length;
    }

    @Override
    public E getElementAt(int j) {
        return (E)this._data[j];
    }

    @Override
    public void sort(Comparator<E> cmpr, boolean ascending) {
        Arrays.sort(this._data, cmpr);
        this.fireEvent(3, -1, -1);
    }

    @Override
    public ListModel<E> getSubModel(Object value, int nRows) {
        LinkedList<Object> data = new LinkedList<Object>();
        nRows = this.getMaxNumberInSubModel(nRows);
        for (int i = 0; i < this._data.length; ++i) {
            if (!this.inSubModel(value, this._data[i])) continue;
            data.add(this._data[i]);
            if (--nRows <= 0) break;
        }
        return new SimpleListModel(data);
    }

    protected int getMaxNumberInSubModel(int nRows) {
        return nRows < 0 ? 15 : nRows;
    }

    protected boolean inSubModel(Object key, Object value) {
        String idx = this.objectToString(key);
        return idx.length() > 0 && this.objectToString(value).startsWith(idx);
    }

    protected String objectToString(Object value) {
        String s = value != null ? value.toString() : "";
        return s != null ? s : "";
    }
}

