/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Objects;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuRequests;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuSelect;
import org.zkoss.zk.au.out.AuWrongValue;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.ErrorEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.InputEvent;
import org.zkoss.zk.ui.event.SelectionEvent;
import org.zkoss.zk.ui.ext.Disable;
import org.zkoss.zk.ui.ext.Readonly;
import org.zkoss.zk.ui.ext.Scope;
import org.zkoss.zk.ui.ext.Scopes;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.sys.JavaScriptValue;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.ClientConstraint;
import org.zkoss.zul.Constraint;
import org.zkoss.zul.CustomConstraint;
import org.zkoss.zul.SimpleConstraint;
import org.zkoss.zul.ext.Constrainted;
import org.zkoss.zul.impl.Utils;
import org.zkoss.zul.impl.XulElement;
import org.zkoss.zul.mesg.MZul;

public abstract class InputElement
extends XulElement
implements Constrainted,
Readonly,
Disable {
    private static final Log log = Log.lookup(InputElement.class);
    protected Object _value;
    private int _cols;
    private AuxInfo _auxinf;
    private boolean _disabled;
    private boolean _readonly;
    private boolean _valided;
    private boolean _inplace;

    public void setInplace(boolean inplace) {
        if (this._inplace != inplace) {
            this._inplace = inplace;
            this.smartUpdate("inplace", this._inplace);
        }
    }

    public boolean isInplace() {
        return this._inplace;
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean disabled) {
        if (this._disabled != disabled) {
            this._disabled = disabled;
            this.smartUpdate("disabled", this._disabled);
        }
    }

    public boolean isReadonly() {
        return this._readonly;
    }

    public void setReadonly(boolean readonly) {
        if (this._readonly != readonly) {
            this._readonly = readonly;
            this.smartUpdate("readonly", this._readonly);
        }
    }

    public String getName() {
        return this._auxinf != null ? this._auxinf.name : null;
    }

    public void setName(String name) {
        if (name != null && name.length() == 0) {
            name = null;
        }
        if (!Objects.equals((Object)(this._auxinf != null ? this._auxinf.name : null), (Object)name)) {
            this.initAuxInfo().name = name;
            this.smartUpdate("name", this.getName());
        }
    }

    public String getErrorMessage() {
        return this._auxinf != null ? this._auxinf.errmsg : null;
    }

    public void setErrorMessage(String errmsg) {
        if (errmsg != null && errmsg.length() > 0) {
            this.initAuxInfo().errmsg = errmsg;
            this.response((AuResponse)new AuWrongValue((Component)this, errmsg));
        } else {
            this.clearErrorMessage();
        }
    }

    public void clearErrorMessage(boolean revalidateRequired) {
        if (this._auxinf != null && this._auxinf.errmsg != null) {
            this._auxinf.errmsg = null;
            Clients.clearWrongValue((Component)this);
        }
        this._valided = !revalidateRequired;
    }

    public void clearErrorMessage() {
        this.clearErrorMessage(false);
    }

    public String getText() throws WrongValueException {
        this.checkUserError();
        return this.coerceToString(this._value);
    }

    public void setText(String value) throws WrongValueException {
        if (this._auxinf != null && this._auxinf.maxlength > 0 && value != null && value.length() > this._auxinf.maxlength) {
            throw new WrongValueException((Component)this, MZul.STRING_TOO_LONG, (Object)new Integer(this._auxinf.maxlength));
        }
        Object val = this.coerceFromString(value);
        boolean same = Objects.equals((Object)this._value, (Object)val);
        boolean errFound = false;
        if (!same || !this._valided || this._auxinf != null && this._auxinf.errmsg != null) {
            this.validate(val);
            errFound = this._auxinf != null && this._auxinf.errmsg != null;
            this.clearErrorMessage();
        }
        if (!same) {
            this._value = val;
            this.smartUpdate("_value", this.marshall(val));
        } else if (errFound) {
            this.smartUpdate("_value", this.marshall(this._value));
        }
    }

    protected abstract Object coerceFromString(String var1) throws WrongValueException;

    protected abstract String coerceToString(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validate(Object value) throws WrongValueException {
        Constraint constr = this.getConstraint();
        if (constr != null) {
            Scopes.beforeInterpret((Scope)this);
            try {
                constr.validate((Component)this, value);
                if (!this._auxinf.checkOnly && constr instanceof CustomConstraint) {
                    try {
                        ((CustomConstraint)((Object)constr)).showCustomError((Component)this, null);
                    }
                    catch (Throwable ex) {
                        log.realCauseBriefly(ex);
                    }
                }
            }
            finally {
                Scopes.afterInterpret();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WrongValueException showCustomError(WrongValueException ex) {
        if (this._auxinf != null && this._auxinf.constr instanceof CustomConstraint) {
            Scopes.beforeInterpret((Scope)this);
            try {
                ((CustomConstraint)((Object)this._auxinf.constr)).showCustomError((Component)this, ex);
            }
            catch (Throwable t) {
                log.realCause(t);
            }
            finally {
                Scopes.afterInterpret();
            }
        }
        return ex;
    }

    public int getMaxlength() {
        return this._auxinf != null ? this._auxinf.maxlength : 0;
    }

    public void setMaxlength(int maxlength) {
        if ((this._auxinf != null ? this._auxinf.maxlength : 0) != maxlength) {
            this.initAuxInfo().maxlength = maxlength;
            this.smartUpdate("maxlength", this.getMaxlength());
        }
    }

    public int getCols() {
        return this._cols;
    }

    public void setCols(int cols) throws WrongValueException {
        if (cols <= 0) {
            throw new WrongValueException("Illegal cols: " + cols);
        }
        if (this._cols != cols) {
            this._cols = cols;
            this.smartUpdate("cols", this._cols);
        }
    }

    public int getTabindex() {
        return this._auxinf != null ? this._auxinf.tabindex : 0;
    }

    public void setTabindex(int tabindex) throws WrongValueException {
        if ((this._auxinf != null ? this._auxinf.tabindex : 0) != tabindex) {
            this.initAuxInfo().tabindex = tabindex;
            this.smartUpdate("tabindex", this.getTabindex());
        }
    }

    public boolean getInstant() {
        return this._auxinf != null && this._auxinf.instant;
    }

    public void setInstant(boolean instant) {
        if (this.getInstant() != instant) {
            this.initAuxInfo().instant = instant;
            this.smartUpdate("instant", this.getInstant());
        }
    }

    public boolean isMultiline() {
        return false;
    }

    public String getType() {
        return "text";
    }

    public void select() {
        this.response((AuResponse)new AuSelect((Component)this));
    }

    public void setConstraint(String constr) {
        this.setConstraint(constr != null ? SimpleConstraint.getInstance(constr) : null);
    }

    public void setConstraint(Constraint constr) {
        if (!Objects.equals((Object)(this._auxinf != null ? this._auxinf.constr : null), (Object)constr)) {
            this.initAuxInfo().constr = constr;
            this._valided = false;
            if (this._auxinf.constr instanceof CustomConstraint) {
                this.smartUpdate("constraint", "[c");
                return;
            }
            if (this._auxinf.constr instanceof ClientConstraint) {
                Object code;
                ClientConstraint cc = (ClientConstraint)((Object)this._auxinf.constr);
                JavaScriptValue cpkgs = InputElement.getClientPackages(cc);
                if (cpkgs != null) {
                    this.smartUpdate("_0", cpkgs);
                }
                if ((code = InputElement.getClientConstraintCode(cc)) != null) {
                    if (code instanceof JavaScriptValue) {
                        this.smartUpdate("z$al", code);
                    } else {
                        this.smartUpdate("constraint", new JavaScriptValue((String)code));
                    }
                    return;
                }
            }
            this.smartUpdate("constraint", this._auxinf.constr != null ? "[s" : null);
        }
    }

    private static JavaScriptValue getClientPackages(ClientConstraint cc) {
        String cpkg = cc.getClientPackages();
        return cpkg != null ? new JavaScriptValue("zk.load('" + cpkg + "')") : null;
    }

    private static Object getClientConstraintCode(ClientConstraint cc) {
        String js = cc.getClientConstraint();
        if (js != null && js.length() > 0) {
            char c = js.charAt(0);
            if (c != '\'' && c != '\"') {
                return new JavaScriptValue("{constraint:function(){\nreturn " + js + ";}}");
            }
            return js;
        }
        return null;
    }

    public Constraint getConstraint() {
        return this._auxinf != null ? this._auxinf.constr : null;
    }

    protected Object getTargetValue() throws WrongValueException {
        this.checkUserError();
        return this._value;
    }

    public Object getRawValue() {
        return this._value;
    }

    public String getRawText() {
        return this.coerceToString(this._value);
    }

    public void setRawValue(Object value) {
        if (this._auxinf != null && this._auxinf.errmsg != null || !Objects.equals((Object)this._value, (Object)value)) {
            this.clearErrorMessage(true);
            this._value = value;
            this.smartUpdate("_value", this.marshall(this._value));
        }
    }

    protected void setValueDirectly(Object value) {
        this._value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        if (this._auxinf != null && this._auxinf.errmsg != null) {
            return false;
        }
        if (!this._valided && this._auxinf != null && this._auxinf.constr != null) {
            this._auxinf.checkOnly = true;
            try {
                this.validate(this._value);
            }
            catch (Throwable ex) {
                boolean bl = false;
                return bl;
            }
            finally {
                this._auxinf.checkOnly = false;
            }
        }
        return true;
    }

    public void setSelectedText(int start, int end, String newtxt, boolean isHighLight) {
        if (start <= end) {
            String txt = this.getText();
            int len = txt.length();
            if (start < 0) {
                start = 0;
            }
            if (start > len) {
                start = len;
            }
            if (end < 0) {
                end = 0;
            }
            if (end > len) {
                end = len;
            }
            if (newtxt == null) {
                newtxt = "";
            }
            this.setText(txt.substring(0, start) + newtxt + txt.substring(end));
            this.setSelectionRange(start, isHighLight ? start + newtxt.length() : start);
        }
    }

    public void setSelectionRange(int start, int end) {
        this.response((AuResponse)new AuSelect((Component)this, start, end));
    }

    protected void checkUserError() throws WrongValueException {
        if (this._auxinf != null && this._auxinf.errmsg != null) {
            throw new WrongValueException((Component)this, this._auxinf.errmsg);
        }
        if (!this._valided && this._auxinf != null && this._auxinf.constr != null) {
            this.setText(this.coerceToString(this._value));
        }
    }

    protected boolean isChildable() {
        return false;
    }

    public WrongValueException onWrongValue(WrongValueException ex) {
        this.initAuxInfo().errmsg = Exceptions.getMessage((Throwable)ex);
        return this.showCustomError(ex);
    }

    protected Object marshall(Object value) {
        return value;
    }

    protected Object unmarshall(Object value) {
        return value;
    }

    private void setValueByClient(Object value, String valstr) {
        if (this._auxinf != null && this._auxinf.maxlength > 0 && valstr != null && valstr.length() > this._auxinf.maxlength) {
            throw new WrongValueException((Component)this, MZul.STRING_TOO_LONG, (Object)new Integer(this._auxinf.maxlength));
        }
        boolean same = Objects.equals((Object)this._value, (Object)value);
        boolean errFound = false;
        if (!same || !this._valided || this._auxinf != null && this._auxinf.errmsg != null) {
            this.validate(value);
            errFound = this._auxinf != null && this._auxinf.errmsg != null;
            this.clearErrorMessage();
        }
        if (!same) {
            this._value = value;
        } else if (errFound) {
            this.smartUpdate("_value", this.marshall(this._value));
        }
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onChange")) {
            Map data = request.getData();
            Object clientv = data.get("value");
            Object oldval = this._value;
            Object value = null;
            try {
                value = this.unmarshall(clientv);
            }
            catch (NumberFormatException ex) {
                this.initAuxInfo().errmsg = ex.getMessage();
                throw new WrongValueException((Component)this, MZul.NUMBER_REQUIRED, clientv);
            }
            String valstr = this.coerceToString(value);
            try {
                this.setValueByClient(value, valstr);
                if (Objects.equals((Object)oldval, (Object)this._value)) {
                    return;
                }
            }
            catch (WrongValueException ex) {
                this.initAuxInfo().errmsg = ex.getMessage();
                throw ex;
            }
            InputEvent evt = new InputEvent(cmd, (Component)this, valstr, oldval, AuRequests.getBoolean((Map)data, (String)"bySelectBack"), AuRequests.getInt((Map)data, (String)"start", (int)0));
            Events.postEvent((Event)evt);
        } else if (cmd.equals("onChanging")) {
            Map data = request.getData();
            Object clientv = data.get("value");
            Object oldval = this._value;
            InputEvent evt = new InputEvent(cmd, (Component)this, clientv == null ? "" : clientv.toString(), oldval, AuRequests.getBoolean((Map)data, (String)"bySelectBack"), AuRequests.getInt((Map)data, (String)"start", (int)0));
            Events.postEvent((Event)evt);
        } else if (cmd.equals("onError")) {
            ErrorEvent evt = ErrorEvent.getErrorEvent((AuRequest)request, (Object)this._value);
            String msg = evt.getMessage();
            this.initAuxInfo().errmsg = msg != null && msg.length() > 0 ? msg : null;
            Events.postEvent((Event)evt);
        } else if (cmd.equals("onSelection")) {
            Events.postEvent((Event)SelectionEvent.getSelectionEvent((AuRequest)request));
        } else {
            super.service(request, everError);
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        Constraint constr;
        super.renderProperties(renderer);
        this.render(renderer, "_value", this.marshall(this._value));
        this.render(renderer, "readonly", this._readonly);
        this.render(renderer, "disabled", this._disabled);
        this.render(renderer, "name", this.getName());
        this.render(renderer, "inplace", this._inplace);
        int v = this.getMaxlength();
        if (v > 0) {
            renderer.render("maxlength", v);
        }
        if (this._cols > 0) {
            renderer.render("cols", this._cols);
        }
        if ((v = this.getTabindex()) != 0) {
            renderer.render("tabindex", v);
        }
        if (this.getInstant()) {
            renderer.render("instant", true);
        }
        boolean constrDone = false;
        Constraint constraint = constr = this._auxinf != null ? this._auxinf.constr : null;
        if (constr instanceof CustomConstraint) {
            renderer.render("constraint", "[c");
            constrDone = true;
        } else if (constr instanceof ClientConstraint) {
            ClientConstraint cc = (ClientConstraint)((Object)constr);
            this.render(renderer, "_0", InputElement.getClientPackages(cc));
            Object code = InputElement.getClientConstraintCode(cc);
            if (code != null) {
                if (code instanceof JavaScriptValue) {
                    renderer.render("z$al", code);
                } else {
                    renderer.renderDirectly("constraint", code);
                }
                constrDone = true;
            }
        }
        if (!constrDone && constr != null) {
            renderer.render("constraint", "[s");
        }
        Utils.renderCrawlableText(this.coerceToString(this._value));
    }

    public Object clone() {
        InputElement clone = (InputElement)super.clone();
        if (this._auxinf != null) {
            clone._auxinf = (AuxInfo)this._auxinf.clone();
        }
        return clone;
    }

    private AuxInfo initAuxInfo() {
        if (this._auxinf == null) {
            this._auxinf = new AuxInfo();
        }
        return this._auxinf;
    }

    static {
        InputElement.addClientEvent(InputElement.class, (String)"onChange", (int)16385);
        InputElement.addClientEvent(InputElement.class, (String)"onChanging", (int)8192);
        InputElement.addClientEvent(InputElement.class, (String)"onFocus", (int)8192);
        InputElement.addClientEvent(InputElement.class, (String)"onBlur", (int)8192);
        InputElement.addClientEvent(InputElement.class, (String)"onSelection", (int)16384);
        InputElement.addClientEvent(InputElement.class, (String)"onError", (int)8193);
    }

    private static class AuxInfo
    implements Serializable,
    Cloneable {
        private String errmsg;
        private String name;
        private int maxlength;
        private int tabindex;
        private boolean instant;
        private Constraint constr;
        private transient boolean checkOnly;

        private AuxInfo() {
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }
    }
}

