/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.jsp.zul;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.DynamicAttributes;
import org.zkoss.jsp.zul.impl.AbstractTag;
import org.zkoss.jsp.zul.impl.VariableResolverInfo;
import org.zkoss.jsp.zul.impl.VariableResolvers;
import org.zkoss.lang.Classes;

public class VariableResolverTag
extends AbstractTag
implements DynamicAttributes {
    private Class _resolverClass;
    private List<Object> _args = new LinkedList<Object>();
    private boolean flag;
    private static final Pattern ARGS_ptn = Pattern.compile("arg[0-9]+");

    public void doTag() throws JspException, IOException {
        VariableResolverInfo vInfo = new VariableResolverInfo(this._resolverClass, this._args);
        VariableResolvers.getInstance(this.getJspContext()).add(vInfo);
    }

    private static boolean isArg(String attrName) {
        Matcher match = ARGS_ptn.matcher(attrName);
        return match.find();
    }

    public void setDynamicAttribute(String uri, String localName, Object value) throws JspException {
        try {
            if (!VariableResolverTag.isArg(localName)) {
                throw new IllegalArgumentException("illegal argument Name:" + localName);
            }
            String nm = localName.substring(3);
            int index = Integer.parseInt(nm);
            this._args.add(index, value);
        }
        catch (NumberFormatException e1) {
            throw new IllegalArgumentException("illegal argument Name:" + localName);
        }
    }

    public void setUse(String clazz) {
        if (clazz == null || clazz.length() == 0) {
            throw new IllegalArgumentException("null or empty");
        }
        try {
            this._resolverClass = Classes.forNameByThread((String)clazz);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Failed to instantiate " + clazz, ex);
        }
    }

    public String getUse() {
        return this._resolverClass != null ? this._resolverClass.getName() : null;
    }
}

