/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.jsp.zul.impl;

import java.util.Collection;
import javax.servlet.jsp.JspException;
import org.zkoss.jsp.zul.impl.MultiComposer;
import org.zkoss.lang.Classes;
import org.zkoss.util.CollectionsX;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.util.Composer;
import org.zkoss.zk.ui.util.ComposerExt;

class ComposerHandler {
    private Composer composer;
    private ComposerExt composerExt;

    ComposerHandler(Object apply) {
        this.composer = ComposerHandler.parseAppliedComposer(apply);
        if (this.composer != null) {
            this.composerExt = this.composer instanceof ComposerExt ? (ComposerExt)this.composer : null;
        }
    }

    private static Composer parseAppliedComposer(Object o) {
        if (null == o) {
            return null;
        }
        try {
            String s;
            if (o instanceof String && (s = (String)o).indexOf(44) >= 0) {
                o = CollectionsX.parse(null, (String)s, (char)',');
            }
            if (o instanceof Collection) {
                Collection c = (Collection)o;
                int sz = c.size();
                switch (sz) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        o = c.iterator().next();
                        break;
                    }
                    default: {
                        o = c.toArray(new Object[sz]);
                    }
                }
            }
            if (o instanceof Object[]) {
                Object[] cs = o;
                switch (cs.length) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        o = cs[0];
                        break;
                    }
                    default: {
                        return new MultiComposer(cs);
                    }
                }
            }
            if (o instanceof String) {
                o = Classes.newInstanceByThread((String)((String)o).trim());
            } else if (o instanceof Class) {
                o = ((Class)o).newInstance();
            }
            if (o instanceof Composer) {
                return (Composer)o;
            }
        }
        catch (Exception ex) {
            throw UiException.Aide.wrap((Throwable)ex);
        }
        return null;
    }

    public void doBeforeComposeChildren(Component comp) throws Exception {
        if (this.composerExt != null) {
            this.composerExt.doBeforeComposeChildren(comp);
        }
    }

    public void doAfterCompose(Component comp) throws JspException {
        try {
            if (this.composer != null) {
                this.composer.doAfterCompose(comp);
            }
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
    }

    public boolean doCatch(Throwable e) {
        boolean flag = false;
        try {
            if (this.composerExt != null) {
                return this.composerExt.doCatch(e);
            }
        }
        catch (Exception e1) {
            StackTraceElement[] oriArr = e.getStackTrace();
            StackTraceElement[] erArr = e1.getStackTrace();
            StackTraceElement[] newErrArr = new StackTraceElement[oriArr.length + erArr.length];
            System.arraycopy(newErrArr, 0, oriArr, 0, oriArr.length);
            System.arraycopy(newErrArr, oriArr.length, erArr, 0, erArr.length);
            e.setStackTrace(newErrArr);
        }
        return false;
    }

    public void doFinally() throws JspException {
        if (this.composerExt != null) {
            try {
                this.composerExt.doFinally();
            }
            catch (Exception e) {
                throw new JspException((Throwable)e);
            }
        }
    }
}

