/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.jsp.zul.impl;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.jsp.JspContext;
import org.zkoss.xel.Function;
import org.zkoss.xel.FunctionMapper;
import org.zkoss.xel.XelException;
import org.zkoss.zk.ui.Page;

public class FunctionMappers {
    private static final String KEY = FunctionMappers.class.getName() + "!KEY";
    private final Map<String, Function> funcMap;
    private final JspContext context;

    public FunctionMappers(JspContext context) {
        this.context = context;
        this.funcMap = new LinkedHashMap<String, Function>();
    }

    public static FunctionMappers getInstance(JspContext context) {
        FunctionMappers fms = (FunctionMappers)context.getAttribute(KEY);
        if (fms == null) {
            fms = new FunctionMappers(context);
            context.setAttribute(KEY, (Object)fms);
        }
        return fms;
    }

    public void addFunction(String prefix, String name, Function func) {
        if (name == null || name.length() == 0 || func == null) {
            throw new IllegalArgumentException();
        }
        this.funcMap.put(prefix + ":" + name, func);
    }

    public void atachFunctions(Page page) {
        page.addFunctionMapper(new FunctionMapper(){

            public Function resolveFunction(String prefix, String name) throws XelException {
                return (Function)FunctionMappers.this.funcMap.get(prefix + ":" + name);
            }

            public Collection getClassNames() {
                return null;
            }

            public Class resolveClass(String name) throws XelException {
                return null;
            }
        });
    }
}

