/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.jsp.zul.impl;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.JspContext;
import org.zkoss.jsp.zul.impl.LeafTag;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.util.Initiator;
import org.zkoss.zk.ui.util.InitiatorExt;

public class Initiators {
    static final Log log = Log.lookup(Initiators.class);
    private final List _inits = new LinkedList();

    private Initiators() {
    }

    public static Initiators getInstance(JspContext context) {
        Initiators inits = (Initiators)context.getAttribute(Initiators.class.getName());
        if (inits == null) {
            inits = new Initiators();
            context.setAttribute(Initiators.class.getName(), (Object)inits);
        }
        return inits;
    }

    public void addInitiator(Initiator init, LinkedHashMap args) {
        this._inits.add(new Object[]{init, args});
    }

    public void doInit(Page page) {
        for (Object[] objArr : this._inits) {
            Initiator initiator = (Initiator)objArr[0];
            LinkedHashMap args = (LinkedHashMap)objArr[1];
            try {
                initiator.doInit(page, (Map)args);
            }
            catch (Throwable ex) {
                throw UiException.Aide.wrap((Throwable)ex);
            }
        }
    }

    public void doAfterCompose(Page page, List compTags) throws Exception {
        Component[] comps = null;
        if (compTags != null) {
            Object[] tags = compTags.toArray();
            comps = new Component[tags.length];
            for (int i = tags.length - 1; i >= 0; --i) {
                LeafTag tag = (LeafTag)tags[i];
                comps[i] = tag.getComponent();
            }
        }
        Iterator it = this._inits.iterator();
        while (it.hasNext()) {
            Initiator init = (Initiator)((Object[])it.next())[0];
            if (init instanceof InitiatorExt) {
                if (comps == null) {
                    comps = new Component[]{};
                }
                ((InitiatorExt)init).doAfterCompose(page, comps);
                continue;
            }
            init.doAfterCompose(page);
        }
    }

    public void doCatch(Throwable t) {
        Iterator it = this._inits.iterator();
        while (it.hasNext()) {
            Initiator init = (Initiator)((Object[])it.next())[0];
            try {
                init.doCatch(t);
            }
            catch (Throwable ex) {
                log.error(ex);
            }
        }
    }

    public void doFinally() {
        Throwable t = null;
        Iterator it = this._inits.iterator();
        while (it.hasNext()) {
            Initiator init = (Initiator)((Object[])it.next())[0];
            try {
                init.doFinally();
            }
            catch (Throwable ex) {
                log.error(ex);
                if (t != null) continue;
                t = ex;
            }
        }
        if (t != null) {
            throw UiException.Aide.wrap(t);
        }
    }
}

