/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.util.resource;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.SystemException;
import org.zkoss.util.logging.Log;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.web.util.resource.ExtendletContext;
import org.zkoss.web.util.resource.ResourceCache;
import org.zkoss.web.util.resource.ResourceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceCaches {
    private static final Log log = Log.lookup(ResourceCaches.class);

    public static final <V> V get(ResourceCache<V> cache, ServletContext ctx, String path, Object extra) {
        URL url = null;
        if (path == null || path.length() == 0) {
            path = "/";
        } else if (path.charAt(0) != '/') {
            if (path.indexOf("://") > 0) {
                try {
                    url = new URL(path);
                }
                catch (MalformedURLException ex) {
                    throw new SystemException((Throwable)ex);
                }
            } else {
                path = '/' + path;
            }
        }
        if (url == null) {
            File file;
            String flnm;
            if (path.startsWith("/~")) {
                String ctxpath;
                ServletContext ctx0 = ctx;
                String path0 = path;
                int j = path.indexOf(47, 2);
                if (j >= 0) {
                    ctxpath = "/" + path.substring(2, j);
                    path = path.substring(j);
                } else {
                    ctxpath = "/" + path.substring(2);
                    path = "/";
                }
                ExtendletContext extctx = Servlets.getExtendletContext(ctx, ctxpath.substring(1));
                if (extctx != null) {
                    url = extctx.getResource(path);
                    if (url == null) {
                        return null;
                    }
                    return (V)cache.get(new ResourceInfo(path, url, extra));
                }
                if ((ctx = ctx.getContext(ctxpath)) == null) {
                    ctx = ctx0;
                    path = path0;
                }
            }
            if ((flnm = ctx.getRealPath(path)) != null && (file = new File(flnm)).exists()) {
                return (V)cache.get(new ResourceInfo(path, file, extra));
            }
        }
        try {
            if (url == null) {
                url = ctx.getResource(path);
            }
            if (url != null) {
                return (V)cache.get(new ResourceInfo(path, url, extra));
            }
        }
        catch (Throwable ex) {
            log.warning("Unable to load " + path + "\n" + Exceptions.getMessage((Throwable)ex));
        }
        return null;
    }
}

