/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.au;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.UiException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuRequests {
    public static <T extends Component> Set<T> convertToItems(Desktop desktop, List<String> uuids) {
        LinkedHashSet<Component> items = new LinkedHashSet<Component>();
        if (uuids != null) {
            for (String uuid : uuids) {
                Component item = desktop.getComponentByUuidIfAny(uuid.trim());
                if (item == null) continue;
                items.add(item);
            }
        }
        return items;
    }

    public static int parseKeys(Map<String, Object> data) {
        int keys = 0;
        if (data != null) {
            if (AuRequests.getBoolean(data, "altKey")) {
                keys |= 1;
            }
            if (AuRequests.getBoolean(data, "ctrlKey")) {
                keys |= 2;
            }
            if (AuRequests.getBoolean(data, "shiftKey")) {
                keys |= 4;
            }
            switch (AuRequests.getInt(data, "which", -1)) {
                case 1: {
                    keys |= 0x100;
                    break;
                }
                case 2: {
                    keys |= 0x400;
                    break;
                }
                case 3: {
                    keys |= 0x200;
                }
            }
        }
        return keys;
    }

    public static String getInnerWidth(AuRequest request) throws UiException {
        return (String)request.getData().get("");
    }

    public static Object getUpdateResult(AuRequest request) throws UiException {
        String key = (String)request.getData().get("contentId");
        Object result = request.getDesktop().removeAttribute(key);
        if (result == null) {
            throw new UiException("Content not found: " + key);
        }
        return result;
    }

    public static int getInt(Map<String, Object> data, String key, int defVal) {
        Object o = data.get(key);
        return o != null ? ((Number)o).intValue() : defVal;
    }

    public static long getLong(Map<String, Object> data, String key, long defVal) {
        Object o = data.get(key);
        return o != null ? ((Number)o).longValue() : defVal;
    }

    public static int getInt(Map<String, Object> data, String key, int defVal, boolean silent) {
        if (silent) {
            try {
                return AuRequests.getInt(data, key, defVal);
            }
            catch (Throwable ex) {
                return defVal;
            }
        }
        return AuRequests.getInt(data, key, defVal);
    }

    public static long getLong(Map<String, Object> data, String key, long defVal, boolean silent) {
        if (silent) {
            try {
                return AuRequests.getLong(data, key, defVal);
            }
            catch (Throwable ex) {
                return defVal;
            }
        }
        return AuRequests.getLong(data, key, defVal);
    }

    public static boolean getBoolean(Map<String, Object> data, String key) {
        Object o = data.get(key);
        return o != null && (!(o instanceof Boolean) || (Boolean)o != false);
    }
}

