/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.au.http;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.ui.Desktop;

class ZkFileItemFactory
extends DiskFileItemFactory {
    private static final Log log = Log.lookup(ZkFileItemFactory.class);
    private final Desktop _desktop;
    private final String _key;
    private long _cbtotal;
    private long _cbrcv;

    ZkFileItemFactory(Desktop desktop, HttpServletRequest request, String key) {
        this.setSizeThreshold(131072);
        this._desktop = desktop;
        this._key = key;
        long cbtotal = 0L;
        String ctlen = request.getHeader("content-length");
        if (ctlen != null) {
            try {
                cbtotal = Long.parseLong(ctlen.trim());
            }
            catch (Throwable ex) {
                log.warning(ex);
            }
        }
        this._cbtotal = cbtotal;
        if (this._desktop.getAttribute("org.zkoss.zk.upload.percent") == null) {
            this._desktop.setAttribute("org.zkoss.zk.upload.percent", new HashMap());
            this._desktop.setAttribute("org.zkoss.zk.upload.size", new HashMap());
        }
        ((Map)this._desktop.getAttribute("org.zkoss.zk.upload.percent")).put(key, new Integer(0));
        ((Map)this._desktop.getAttribute("org.zkoss.zk.upload.size")).put(key, new Long(this._cbtotal));
    }

    void onProgress(long cbRead) {
        int percent = 0;
        if (this._cbtotal > 0L) {
            this._cbrcv = cbRead;
            percent = (int)(this._cbrcv * 100L / this._cbtotal);
        }
        ((Map)this._desktop.getAttribute("org.zkoss.zk.upload.percent")).put(this._key, new Integer(percent));
    }

    public FileItem createItem(String fieldName, String contentType, boolean isFormField, String fileName) {
        return new ZkFileItem(fieldName, contentType, isFormField, fileName, this.getSizeThreshold(), this.getRepository());
    }

    class ProgressCallback
    implements ProgressListener {
        ProgressCallback() {
        }

        public void update(long pBytesRead, long pContentLength, int pItems) {
            ZkFileItemFactory.this.onProgress(pBytesRead);
            if (pContentLength >= 0L) {
                ZkFileItemFactory.this._cbtotal = pContentLength;
            }
        }
    }

    class ZkFileItem
    extends DiskFileItem {
        ZkFileItem(String fieldName, String contentType, boolean isFormField, String fileName, int sizeThreshold, File repository) {
            super(fieldName, contentType, isFormField, fileName, sizeThreshold, repository);
        }

        public String getCharSet() {
            String charset = super.getCharSet();
            return charset != null ? charset : "UTF-8";
        }
    }
}

