/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.event;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Page;

public class Event
implements Serializable {
    private final String _name;
    private final Component _target;
    private final Object _data;
    private boolean _propagatable = true;

    public static Event getEvent(AuRequest request) {
        Object data2;
        String name = request.getCommand();
        Component comp = request.getComponent();
        Map<String, Object> data = request.getData();
        Object object = data2 = data != null ? data.get("") : null;
        if (data2 == null) {
            return new Event(name, comp);
        }
        if (data2 instanceof Collection) {
            return new Event(name, comp, ((Collection)data2).toArray());
        }
        return new Event(name, comp, data2);
    }

    public Event(String name) {
        this(name, null);
    }

    public Event(String name, Component target) {
        if (name == null) {
            throw new NullPointerException();
        }
        this._name = name;
        this._target = target;
        this._data = null;
    }

    public Event(String name, Component target, Object data) {
        if (name == null) {
            throw new NullPointerException();
        }
        this._name = name;
        this._target = target;
        this._data = data;
    }

    public final String getName() {
        return this._name;
    }

    public final Component getTarget() {
        return this._target;
    }

    public final Page getPage() {
        return this._target != null ? this._target.getPage() : null;
    }

    public Object getData() {
        return this._data;
    }

    public boolean isPropagatable() {
        return this._propagatable;
    }

    public void stopPropagation() {
        this._propagatable = false;
    }

    public String toString() {
        String clsnm = this.getClass().getName();
        int j = clsnm.lastIndexOf(46);
        return "[" + clsnm.substring(j + 1) + ' ' + this._name + ' ' + this._target + ']';
    }
}

