/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.event;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.lang.Generics;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuRequests;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectEvent<T extends Component>
extends Event {
    private final Set<T> _selectedItems;
    private final T _ref;
    private final int _keys;
    public static final int ALT_KEY = 1;
    public static final int CTRL_KEY = 2;
    public static final int SHIFT_KEY = 4;

    public static final <T extends Component> SelectEvent<T> getSelectEvent(AuRequest request) {
        Map<String, Object> data = request.getData();
        Desktop desktop = request.getDesktop();
        List sitems = Generics.cast((List)((List)data.get("items")));
        Set items = AuRequests.convertToItems(desktop, sitems);
        return new SelectEvent<Component>(request.getCommand(), request.getComponent(), items, desktop.getComponentByUuidIfAny((String)data.get("reference")), AuRequests.parseKeys(data));
    }

    public SelectEvent(String name, Component target, Set<T> selectedItems) {
        this(name, target, selectedItems, null, 0);
    }

    public SelectEvent(String name, Component target, Set<T> selectedItems, T ref) {
        this(name, target, selectedItems, ref, 0);
    }

    public SelectEvent(String name, Component target, Set<T> selectedItems, T ref, int keys) {
        super(name, target);
        this._selectedItems = selectedItems != null ? selectedItems : Collections.emptySet();
        this._ref = ref;
        this._keys = keys;
    }

    public final Set<T> getSelectedItems() {
        return this._selectedItems;
    }

    public T getReference() {
        return this._ref;
    }

    public final int getKeys() {
        return this._keys;
    }
}

