/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.event.impl;

import java.util.LinkedList;
import java.util.List;
import org.zkoss.lang.Threads;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.DesktopUnavailableException;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventQueue;
import org.zkoss.zk.ui.event.impl.DesktopEventQueue;
import org.zkoss.zk.ui.event.impl.ListenerInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AsyncListenerThread<T extends Event>
extends Thread {
    private static final Log log = DesktopEventQueue.log;
    final Desktop _desktop = Executions.getCurrent().getDesktop();
    private final EventQueue<T> _que;
    private final ListenerInfo<T> _inf;
    private final T _event;
    private List<T> _pendingEvents;

    AsyncListenerThread(EventQueue<T> que, ListenerInfo<T> inf, T event) {
        this._que = que;
        this._inf = inf;
        this._event = event;
        Threads.setDaemon((Thread)this, (boolean)true);
    }

    void postEvent(T event) {
        if (this._pendingEvents == null) {
            this._pendingEvents = new LinkedList<T>();
        }
        this._pendingEvents.add(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block11: {
            try {
                this._inf.listener.onEvent(this._event);
                if (this._inf.callback == null && this._pendingEvents == null) break block11;
                try {
                    Executions.activate(this._desktop);
                    try {
                        if (this._pendingEvents != null) {
                            for (Event evt : this._pendingEvents) {
                                this._que.publish(evt);
                            }
                        }
                        if (this._inf.callback != null) {
                            this._inf.callback.onEvent(this._event);
                        }
                    }
                    finally {
                        Executions.deactivate(this._desktop);
                    }
                }
                catch (Throwable ex) {
                    log.realCauseBriefly(ex);
                }
            }
            catch (DesktopUnavailableException ex) {
            }
            catch (Throwable ex) {
                log.realCauseBriefly(ex);
                throw UiException.Aide.wrap(ex);
            }
        }
    }
}

