/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.http;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.security.Principal;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.idom.Document;
import org.zkoss.lang.Classes;
import org.zkoss.util.CollectionsX;
import org.zkoss.util.resource.Locator;
import org.zkoss.util.resource.Locators;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.web.servlet.http.Encodes;
import org.zkoss.web.servlet.http.HttpBufferedResponse;
import org.zkoss.web.servlet.xel.AttributesMap;
import org.zkoss.web.servlet.xel.RequestContext;
import org.zkoss.web.servlet.xel.RequestContexts;
import org.zkoss.web.servlet.xel.RequestXelResolver;
import org.zkoss.web.util.resource.ClassWebResource;
import org.zkoss.web.util.resource.Extendlet;
import org.zkoss.xel.Expression;
import org.zkoss.xel.ExpressionFactory;
import org.zkoss.xel.Expressions;
import org.zkoss.xel.FunctionMapper;
import org.zkoss.xel.VariableResolver;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.ext.ScopeListener;
import org.zkoss.zk.ui.http.WebManager;
import org.zkoss.zk.ui.impl.AbstractExecution;
import org.zkoss.zk.ui.impl.RequestInfoImpl;
import org.zkoss.zk.ui.impl.ScopeListeners;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.metainfo.PageDefinitions;
import org.zkoss.zk.ui.sys.RequestInfo;
import org.zkoss.zk.ui.sys.Visualizer;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.xel.Evaluator;
import org.zkoss.zk.xel.impl.ExecutionResolver;
import org.zkoss.zk.xel.impl.SimpleEvaluator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionImpl
extends AbstractExecution {
    private final ServletContext _ctx;
    private final HttpServletRequest _request;
    private final HttpServletResponse _response;
    private final RequestContext _xelctx;
    private final Map<String, Object> _attrs;
    private MyEval _eval;
    private ExecutionResolver _resolver;
    private final ScopeListeners _scopeListeners = new ScopeListeners(this);
    private boolean _voided;

    public ExecutionImpl(ServletContext ctx, HttpServletRequest request, HttpServletResponse response, Desktop desktop, Page creating) {
        super(desktop, creating);
        this._ctx = ctx;
        this._request = request;
        this._response = response;
        this._xelctx = new ReqContext();
        this._attrs = new AttributesMap(){

            protected Enumeration<String> getKeys() {
                return ExecutionImpl.this._request.getAttributeNames();
            }

            protected Object getValue(String key) {
                return ExecutionImpl.this._request.getAttribute(key);
            }

            protected void setValue(String key, Object val) {
                ExecutionImpl.this._request.setAttribute(key, val);
            }

            protected void removeValue(String key) {
                ExecutionImpl.this._request.removeAttribute(key);
            }
        };
    }

    @Override
    public void onActivate() {
        super.onActivate();
        RequestContexts.push((RequestContext)this._xelctx);
    }

    @Override
    public void onDeactivate() {
        RequestContexts.pop();
        super.onDeactivate();
    }

    @Override
    public String[] getParameterValues(String name) {
        return this._request.getParameterValues(name);
    }

    @Override
    public String getParameter(String name) {
        return this._request.getParameter(name);
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        return this._request.getParameterMap();
    }

    @Override
    public VariableResolver getVariableResolver() {
        if (this._resolver == null) {
            this._resolver = new ExecutionResolver(this, (VariableResolver)new RequestXelResolver(this._ctx, (ServletRequest)this._request, (ServletResponse)this._response){

                public ExpressionFactory getExpressionFactory() {
                    return ExecutionImpl.this.getExpressionFactory();
                }
            });
        }
        return this._resolver;
    }

    private ExpressionFactory getExpressionFactory() {
        return Expressions.newExpressionFactory();
    }

    @Override
    public Evaluator getEvaluator(Page page, Class<? extends ExpressionFactory> expfcls) {
        if (page == null) {
            page = this.getCurrentPage();
        }
        if (page != null && expfcls == null) {
            expfcls = page.getExpressionFactoryClass();
        }
        if (this._eval == null || this._eval.page != page || this._eval.getExpressionFactoryClass() != expfcls) {
            this._eval = new MyEval(page, expfcls);
        }
        return this._eval;
    }

    @Override
    public Evaluator getEvaluator(Component comp, Class<? extends ExpressionFactory> expfcls) {
        return this.getEvaluator(comp != null ? comp.getPage() : null, expfcls);
    }

    @Override
    public Object evaluate(Component comp, String expr, Class<?> expectedType) {
        return this.evaluate0(comp, expr, expectedType, comp != null ? comp.getPage() : null);
    }

    @Override
    public Object evaluate(Page page, String expr, Class<?> expectedType) {
        return this.evaluate0(page, expr, expectedType, page);
    }

    private Object evaluate0(Object self, String expr, Class<?> expectedType, Page page) {
        if (expr == null || expr.length() == 0 || expr.indexOf("${") < 0) {
            if (expectedType == Object.class || expectedType == String.class) {
                return expr;
            }
            return Classes.coerce(expectedType, (Object)expr);
        }
        Evaluator eval = this.getEvaluator(page, null);
        Expression expression = eval.parseExpression(expr, expectedType);
        return self instanceof Page ? eval.evaluate((Page)self, expression) : eval.evaluate((Component)self, expression);
    }

    @Override
    public void include(Writer out, String page, Map<String, ?> params, int mode) throws IOException {
        try {
            if (!this.dispatch(out, page, params, mode, true)) {
                Servlets.include((ServletContext)this._ctx, (ServletRequest)this._request, (ServletResponse)HttpBufferedResponse.getInstance((HttpServletResponse)this._response, (Writer)out), (String)page, params, (int)mode);
            }
        }
        catch (ServletException ex) {
            throw new UiException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dispatch(Writer out, String page, Map params, int mode, boolean include) throws IOException, ServletException {
        if (mode != 3 && params != null || !page.startsWith("~./") || page.indexOf(63) >= 0) {
            return false;
        }
        ClassWebResource cwr = WebManager.getWebManager(this._ctx).getClassWebResource();
        if (!ExecutionImpl.isDirectInclude(cwr, page)) {
            return false;
        }
        Object old = null;
        if (mode == 3) {
            old = this._request.getAttribute("arg");
            if (params != null) {
                this._request.setAttribute("arg", (Object)params);
            }
        }
        String attrnm = include ? "org.zkoss.web.servlet.include" : "org.zkoss.web.servlet.forward";
        this._request.setAttribute(attrnm, (Object)Boolean.TRUE);
        try {
            cwr.service(this._request, HttpBufferedResponse.getInstance((HttpServletResponse)this._response, (Writer)out), page.substring(2));
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this._request.removeAttribute(attrnm);
            if (mode == 3) {
                this._request.setAttribute("arg", old);
            }
            throw throwable;
        }
        this._request.removeAttribute(attrnm);
        if (mode == 3) {
            this._request.setAttribute("arg", old);
        }
        return true;
    }

    private static boolean isDirectInclude(ClassWebResource cwr, String path) {
        Extendlet extlet;
        String ext = Servlets.getExtension((String)path);
        Extendlet extendlet = extlet = ext != null ? cwr.getExtendlet(ext) : null;
        if (extlet != null) {
            try {
                return extlet.getFeature(1);
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    public void include(String page) throws IOException {
        this.include(null, page, null, 0);
    }

    @Override
    public void forward(Writer out, String page, Map<String, ?> params, int mode) throws IOException {
        Visualizer uv = this.getVisualizer();
        if (uv != null && uv.isEverAsyncUpdate()) {
            throw new IllegalStateException("Use sendRedirect instead when processing user's request");
        }
        this.setVoided(true);
        try {
            if (!this.dispatch(out, page, params, mode, false)) {
                Servlets.forward((ServletContext)this._ctx, (ServletRequest)this._request, (ServletResponse)HttpBufferedResponse.getInstance((HttpServletResponse)this._response, (Writer)out), (String)page, params, (int)mode);
            }
        }
        catch (ServletException ex) {
            throw new UiException(ex);
        }
    }

    @Override
    public void forward(String page) throws IOException {
        this.forward(null, page, null, 0);
    }

    @Override
    public boolean isIncluded() {
        return Servlets.isIncluded((ServletRequest)this._request);
    }

    @Override
    public boolean isForwarded() {
        return Servlets.isForwarded((ServletRequest)this._request);
    }

    @Override
    public String locate(String path) {
        try {
            if (path.startsWith("~./")) {
                path = Servlets.locate((ServletContext)this._ctx, (ServletRequest)this._request, (String)("/web" + path.substring(2)), (Locator)Locators.getDefault());
                return "~." + path.substring("/web".length());
            }
            return Servlets.locate((ServletContext)this._ctx, (ServletRequest)this._request, (String)path, null);
        }
        catch (ServletException ex) {
            throw new UiException(ex);
        }
    }

    @Override
    public boolean isVoided() {
        return this._voided;
    }

    @Override
    public void setVoided(boolean voided) {
        this._voided = voided;
    }

    @Override
    public String encodeURL(String uri) {
        try {
            return Encodes.encodeURL((ServletContext)this._ctx, (ServletRequest)this._request, (ServletResponse)this._response, (String)uri);
        }
        catch (ServletException ex) {
            throw new UiException(ex);
        }
    }

    @Override
    public Principal getUserPrincipal() {
        return this._request.getUserPrincipal();
    }

    @Override
    public boolean isUserInRole(String role) {
        return this._request.isUserInRole(role);
    }

    @Override
    public String getRemoteUser() {
        return this._request.getRemoteUser();
    }

    @Override
    public String getRemoteHost() {
        return this._request.getRemoteHost();
    }

    @Override
    public String getRemoteAddr() {
        return this._request.getRemoteAddr();
    }

    @Override
    public String getServerName() {
        return this._request.getServerName();
    }

    @Override
    public int getServerPort() {
        return this._request.getServerPort();
    }

    @Override
    public String getLocalName() {
        return this._request.getLocalName();
    }

    @Override
    public String getLocalAddr() {
        return this._request.getLocalAddr();
    }

    @Override
    public int getLocalPort() {
        return this._request.getLocalPort();
    }

    @Override
    public String getContextPath() {
        String s = this._request.getContextPath();
        return s == null || "/".equals(s) ? "" : s;
    }

    @Override
    public String getScheme() {
        return this._request.getScheme();
    }

    @Override
    public PageDefinition getPageDefinition(String uri) {
        if (uri == null || uri.length() == 0) {
            throw new IllegalArgumentException("uri not specified: " + uri);
        }
        uri = this.toAbsoluteURI(uri, false);
        PageDefinition pagedef = ((WebAppCtrl)((Object)this.getDesktop().getWebApp())).getUiFactory().getPageDefinition(this.newRequestInfo(uri), uri);
        if (pagedef == null) {
            throw new UiException("Page not found: " + uri);
        }
        return pagedef;
    }

    @Override
    public PageDefinition getPageDefinitionDirectly(String content, String ext) {
        return ((WebAppCtrl)((Object)this.getDesktop().getWebApp())).getUiFactory().getPageDefinitionDirectly(this.newRequestInfo(null), content, ext);
    }

    @Override
    public PageDefinition getPageDefinitionDirectly(Document content, String ext) {
        return ((WebAppCtrl)((Object)this.getDesktop().getWebApp())).getUiFactory().getPageDefinitionDirectly(this.newRequestInfo(null), content, ext);
    }

    @Override
    public PageDefinition getPageDefinitionDirectly(Reader reader, String ext) throws IOException {
        return ((WebAppCtrl)((Object)this.getDesktop().getWebApp())).getUiFactory().getPageDefinitionDirectly(this.newRequestInfo(null), reader, ext);
    }

    private RequestInfo newRequestInfo(String uri) {
        Desktop dt = this.getDesktop();
        return new RequestInfoImpl(dt, this._request, PageDefinitions.getLocator(this.getDesktop().getWebApp(), uri));
    }

    @Override
    public void setContentType(String contentType) {
        if (this._response instanceof HttpServletResponse) {
            this._response.setContentType(contentType);
        }
    }

    @Override
    public boolean isBrowser() {
        return true;
    }

    @Override
    public boolean isBrowser(String type) {
        return Servlets.isBrowser((ServletRequest)this._request, (String)type);
    }

    @Override
    public boolean isRobot() {
        return Servlets.isRobot((ServletRequest)this._request);
    }

    @Override
    public boolean isExplorer() {
        return Servlets.isExplorer((ServletRequest)this._request);
    }

    @Override
    public boolean isExplorer7() {
        return Servlets.isExplorer7((ServletRequest)this._request);
    }

    @Override
    public boolean isGecko() {
        return Servlets.isGecko((ServletRequest)this._request);
    }

    @Override
    public boolean isGecko3() {
        return Servlets.isGecko3((ServletRequest)this._request);
    }

    @Override
    public boolean isOpera() {
        return Servlets.isOpera((ServletRequest)this._request);
    }

    @Override
    public boolean isSafari() {
        return Servlets.isSafari((ServletRequest)this._request);
    }

    @Override
    public boolean isHilDevice() {
        return Servlets.isHilDevice((ServletRequest)this._request);
    }

    @Override
    public String getUserAgent() {
        return Servlets.getUserAgent((ServletRequest)this._request);
    }

    @Override
    public Object getNativeRequest() {
        return this._request;
    }

    @Override
    public Object getNativeResponse() {
        return this._response;
    }

    @Override
    public Object getAttribute(String name) {
        return this._request.getAttribute(name);
    }

    @Override
    public boolean hasAttribute(String name) {
        return this.getAttribute(name) != null;
    }

    @Override
    public Object setAttribute(String name, Object value) {
        Object old = this._request.getAttribute(name);
        this._request.setAttribute(name, value);
        return old;
    }

    @Override
    public Object removeAttribute(String name) {
        Object old = this._request.getAttribute(name);
        this._request.removeAttribute(name);
        return old;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this._attrs;
    }

    @Override
    public boolean addScopeListener(ScopeListener listener) {
        return this._scopeListeners.addScopeListener(listener);
    }

    @Override
    public boolean removeScopeListener(ScopeListener listener) {
        return this._scopeListeners.removeScopeListener(listener);
    }

    ScopeListeners getScopeListeners() {
        return this._scopeListeners;
    }

    @Override
    public String getHeader(String name) {
        return this._request.getHeader(name);
    }

    @Override
    public Iterable<String> getHeaders(String name) {
        Enumeration headers = this._request.getHeaders(name);
        return headers != null ? new Headers(name, headers) : null;
    }

    @Override
    public Iterable<String> getHeaderNames() {
        Enumeration headers = this._request.getHeaderNames();
        return headers != null ? new HeaderNames(headers) : null;
    }

    @Override
    public void setResponseHeader(String name, String value) {
        this._response.setHeader(name, value);
    }

    @Override
    public void setResponseHeader(String name, Date value) {
        this._response.setDateHeader(name, value.getTime());
    }

    @Override
    public void addResponseHeader(String name, String value) {
        this._response.addHeader(name, value);
    }

    @Override
    public void addResponseHeader(String name, Date value) {
        this._response.addDateHeader(name, value.getTime());
    }

    @Override
    public boolean containsResponseHeader(String name) {
        return this._response.containsHeader(name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyEval
    extends SimpleEvaluator {
        private Page page;

        private MyEval(Page page, Class<? extends ExpressionFactory> expfcls) {
            super(null, expfcls);
            this.page = page;
        }

        @Override
        public FunctionMapper getFunctionMapper(Object ref) {
            return this.page != null ? this.page.getFunctionMapper() : null;
        }
    }

    private class ReqContext
    implements RequestContext {
        private ReqContext() {
        }

        public Writer getOut() throws IOException {
            return ExecutionImpl.this._response.getWriter();
        }

        public VariableResolver getVariableResolver() {
            return ExecutionImpl.this.getVariableResolver();
        }

        public ServletRequest getRequest() {
            return ExecutionImpl.this._request;
        }

        public ServletResponse getResponse() {
            return ExecutionImpl.this._response;
        }

        public ServletContext getServletContext() {
            return ExecutionImpl.this._ctx;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HeaderNames
    implements Iterable<String> {
        private Enumeration<String> _cache;

        private HeaderNames(Enumeration<String> cache) {
            this._cache = cache;
        }

        @Override
        public Iterator<String> iterator() {
            Enumeration headers;
            if (this._cache != null) {
                headers = this._cache;
                this._cache = null;
            } else {
                headers = ExecutionImpl.this._request.getHeaderNames();
            }
            return new CollectionsX.EnumerationIterator(headers);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Headers
    implements Iterable<String> {
        private final String _name;
        private Enumeration<String> _cache;

        private Headers(String name, Enumeration<String> cache) {
            this._name = name;
            this._cache = cache;
        }

        @Override
        public Iterator<String> iterator() {
            Enumeration headers;
            if (this._cache != null) {
                headers = this._cache;
                this._cache = null;
            } else {
                headers = ExecutionImpl.this._request.getHeaders(this._name);
            }
            return new CollectionsX.EnumerationIterator(headers);
        }
    }
}

