/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.http;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.idom.Element;
import org.zkoss.idom.input.SAXBuilder;
import org.zkoss.idom.util.IDOMs;
import org.zkoss.io.Files;
import org.zkoss.json.JSONArray;
import org.zkoss.json.JSONObject;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Library;
import org.zkoss.lang.Strings;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.web.servlet.http.Encodes;
import org.zkoss.web.servlet.http.Https;
import org.zkoss.web.util.resource.ExtendletConfig;
import org.zkoss.web.util.resource.ExtendletContext;
import org.zkoss.web.util.resource.ExtendletLoader;
import org.zkoss.zk.device.Device;
import org.zkoss.zk.device.Devices;
import org.zkoss.zk.fn.JspFns;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.WebApps;
import org.zkoss.zk.ui.http.AbstractExtendlet;
import org.zkoss.zk.ui.http.Provider;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.metainfo.WidgetDefinition;
import org.zkoss.zk.ui.util.Configuration;
import org.zkoss.zk.ui.util.URIInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WpdExtendlet
extends AbstractExtendlet<Object> {
    public void init(ExtendletConfig config) {
        this.init(config, new WpdLoader());
        config.addCompressExtension("wpd");
    }

    public void service(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException, IOException {
        byte[] bs;
        byte[] data = this.retrieve(request, response, path);
        if (data == null) {
            return;
        }
        response.setContentType("text/javascript;charset=UTF-8");
        if (this._webctx.shallCompress((ServletRequest)request, "wpd") && data.length > 200 && (bs = Https.gzip((HttpServletRequest)request, (HttpServletResponse)response, null, (byte[])data)) != null) {
            data = bs;
        }
        response.setContentLength(data.length);
        response.getOutputStream().write(data);
        response.flushBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] retrieve(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException, IOException {
        byte[] data;
        String pkg = null;
        this.setProvider(new Provider(this, request, response));
        try {
            boolean cacheable;
            Object rawdata;
            String resourceCache = Library.getProperty((String)"org.zkoss.zk.WPD.cache");
            if (resourceCache != null && "false".equalsIgnoreCase(resourceCache)) {
                this._cache.clear();
            }
            if ((rawdata = this._cache.get((Object)path)) == null) {
                if (Servlets.isIncluded((ServletRequest)request)) {
                    log.error("Failed to load the resource: " + path);
                    throw new FileNotFoundException("Failed to load the resource: " + path);
                }
                response.sendError(404, path);
                byte[] byArray = null;
                return byArray;
            }
            if (rawdata instanceof ByteContent) {
                ByteContent bc = (ByteContent)rawdata;
                data = bc.content;
                cacheable = bc.cacheable;
            } else {
                WpdContent wc = (WpdContent)rawdata;
                data = wc.toByteArray(request);
                pkg = wc.name;
                cacheable = wc.cacheable;
            }
            if (cacheable) {
                JspFns.setCacheControl(this.getServletContext(), request, response, "org.zkoss.web.classWebResource.cache", 8760);
            }
        }
        finally {
            this.setProvider(null);
        }
        return pkg != null ? this.mergeJavaScript(request, response, pkg, data) : data;
    }

    protected String getDeviceType() {
        return "ajax";
    }

    protected byte[] mergeJavaScript(HttpServletRequest request, HttpServletResponse response, String pkgTo, byte[] data) throws ServletException, IOException {
        ByteArrayOutputStream out = null;
        Device device = null;
        String deviceType = this.getDeviceType();
        for (LanguageDefinition langdef : LanguageDefinition.getByDeviceType(deviceType)) {
            for (String pkg : langdef.getMergedJavaScriptPackages(pkgTo)) {
                String path;
                if (out == null) {
                    out = new ByteArrayOutputStream(102400);
                    out.write(data);
                    device = Devices.getDevice(deviceType);
                }
                if ((data = this.retrieve(request, response, path = device.packageToPath(pkg))) != null) {
                    out.write(data);
                    continue;
                }
                log.error("Failed to load the resource: " + path);
            }
        }
        return out != null ? out.toByteArray() : data;
    }

    Object parse(InputStream is, String path) throws Exception {
        Element root = new SAXBuilder(true, false, true).build(is).getRootElement();
        String name = IDOMs.getRequiredAttributeValue((Element)root, (String)"name");
        if (name.length() == 0) {
            throw new UiException("The name attribute must be specified, " + root.getLocator() + ", " + path);
        }
        boolean zk = "zk".equals(name);
        boolean aaas = "zk.aaas".equals(name);
        String lang = root.getAttributeValue("language");
        LanguageDefinition langdef = lang != null ? LanguageDefinition.lookup(lang) : null;
        String dir = path.substring(0, path.lastIndexOf(47) + 1);
        boolean cacheable = !"false".equals(root.getAttributeValue("cacheable"));
        WpdContent wc = zk || aaas || !cacheable || this.isWpdContentRequired(name, root) ? new WpdContent(name, dir, cacheable) : null;
        Provider provider = this.getProvider();
        ByteArrayOutputStream out = new ByteArrayOutputStream(16384);
        String depends = null;
        if (zk) {
            this.write((OutputStream)out, "if(!window.zk){\n");
        } else if (!aaas) {
            depends = root.getAttributeValue("depends");
            if (depends != null && depends.length() == 0) {
                depends = null;
            }
            if (depends != null) {
                this.write((OutputStream)out, "zk.load('");
                this.write((OutputStream)out, depends);
                this.write((OutputStream)out, "',");
            } else {
                this.write((OutputStream)out, '(');
            }
            this.write((OutputStream)out, "function(){if(zk._p=zkpi('");
            this.write((OutputStream)out, name);
            this.write((OutputStream)out, '\'');
            if (provider != null && provider.getResource(dir + "wv/zk.wpd") != null) {
                this.write((OutputStream)out, ",true");
            }
            this.write((OutputStream)out, "))try{\n");
        }
        HashMap<String, String[]> moldInfos = new HashMap<String, String[]>();
        for (Element el : root.getElements()) {
            String jspath;
            String elnm = el.getName();
            if ("widget".equals(elnm)) {
                WidgetDefinition wgtdef;
                String wgtnm = IDOMs.getRequiredAttributeValue((Element)el, (String)"name");
                jspath = wgtnm + ".js";
                if (!this.writeResource(out, jspath, dir, false)) {
                    log.error("Widget " + wgtnm + ": " + jspath + " not found, " + el.getLocator() + ", " + path);
                    continue;
                }
                String wgtflnm = name + "." + wgtnm;
                this.write((OutputStream)out, "zkreg('");
                this.write((OutputStream)out, wgtflnm);
                this.write((OutputStream)out, '\'');
                WidgetDefinition widgetDefinition = wgtdef = langdef != null ? langdef.getWidgetDefinitionIfAny(wgtflnm) : null;
                if (wgtdef != null && wgtdef.isBlankPreserved()) {
                    this.write((OutputStream)out, ",true");
                }
                this.write((OutputStream)out, ");");
                if (wgtdef == null) continue;
                try {
                    boolean first = true;
                    for (String mold : wgtdef.getMoldNames()) {
                        String uri = wgtdef.getMoldURI(mold);
                        if (uri == null) continue;
                        if (first) {
                            first = false;
                            this.write((OutputStream)out, "zk._m={};\n");
                        }
                        this.write((OutputStream)out, "zk._m['");
                        this.write((OutputStream)out, mold);
                        this.write((OutputStream)out, "']=");
                        String[] info = (String[])moldInfos.get(uri);
                        if (info != null) {
                            this.write((OutputStream)out, "[zk._p.p.");
                            this.write((OutputStream)out, info[0]);
                            this.write((OutputStream)out, ",'");
                            this.write((OutputStream)out, info[1]);
                            this.write((OutputStream)out, "'];");
                            continue;
                        }
                        moldInfos.put(uri, new String[]{wgtnm, mold});
                        if (!this.writeResource(out, uri, dir, true)) {
                            this.write((OutputStream)out, "zk.$void;zk.error('");
                            this.write((OutputStream)out, uri);
                            this.write((OutputStream)out, " not found')");
                            log.error("Failed to load mold " + mold + " for widget " + wgtflnm + ": " + uri + " not found");
                        }
                        this.write((OutputStream)out, ';');
                    }
                    if (first) continue;
                    this.write((OutputStream)out, "zkmld(");
                    this.write((OutputStream)out, zk ? "zk." : "zk._p.p.");
                    this.write((OutputStream)out, wgtnm);
                    this.write((OutputStream)out, ",zk._m);");
                }
                catch (Throwable ex) {
                    log.error("Failed to load molds for widget " + wgtflnm + ".\nCause: " + Exceptions.getMessage((Throwable)ex));
                }
                continue;
            }
            if ("script".equals(elnm)) {
                String s;
                String browser = el.getAttributeValue("browser");
                jspath = el.getAttributeValue("src");
                if (jspath != null && jspath.length() > 0) {
                    if (wc != null && (browser != null || jspath.indexOf(42) >= 0)) {
                        this.move(wc, out);
                        wc.add(jspath, browser);
                    } else {
                        if (browser != null && provider != null && !Servlets.isBrowser((ServletRequest)provider.request, (String)browser)) continue;
                        if (!this.writeResource(out, jspath, dir, true)) {
                            log.error(jspath + " not found, " + el.getLocator() + ", " + path);
                        }
                    }
                }
                if ((s = el.getText(true)) == null || s.length() <= 0) continue;
                this.write((OutputStream)out, s);
                this.write((OutputStream)out, '\n');
                continue;
            }
            if ("function".equals(elnm)) {
                AbstractExtendlet.MethodInfo mtd = WpdExtendlet.getMethodInfo(el);
                if (mtd == null) continue;
                if (wc != null) {
                    this.move(wc, out);
                    wc.add(mtd);
                    continue;
                }
                this.write((OutputStream)out, mtd);
                continue;
            }
            log.warning("Unknown element " + elnm + ", " + el.getLocator() + ", " + path);
        }
        if (zk) {
            WebApp wapp = this.getWebApp();
            if (wapp != null) {
                this.writeAppInfo(out, wapp);
            }
            this.write((OutputStream)out, '}');
            this.writeHost(wc, out, wapp);
        } else if (aaas) {
            this.writeHost(wc, out, this.getWebApp());
        } else {
            this.write((OutputStream)out, "\n}finally{zk.setLoaded(zk._p.n);}");
            if (depends != null) {
                this.write((OutputStream)out, "});zk.setLoaded('");
                this.write((OutputStream)out, name);
                this.write((OutputStream)out, "',1);");
            } else {
                this.write((OutputStream)out, "})();");
            }
        }
        if (wc != null) {
            this.move(wc, out);
            return wc;
        }
        return new ByteContent(out.toByteArray(), cacheable);
    }

    private boolean isWpdContentRequired(String pkg, Element root) {
        for (LanguageDefinition langdef : LanguageDefinition.getByDeviceType(this.getDeviceType())) {
            if (!langdef.getJavaScriptPackagesWithMerges().contains(pkg)) continue;
            return true;
        }
        for (Element el : root.getElements("script")) {
            if (el.getAttributeValue("browser") == null) continue;
            return true;
        }
        return false;
    }

    private void writeHost(WpdContent wc, ByteArrayOutputStream out, WebApp wapp) {
        Object[] pkgs;
        if (wapp != null && (pkgs = wapp.getConfiguration().getClientPackages()).length > 0) {
            this.move(wc, out);
            wc.addHost(wapp, JSONArray.toJSONString((Object[])pkgs));
        }
    }

    private boolean writeResource(OutputStream out, String path, String dir, boolean locate) throws IOException, ServletException {
        if (path.startsWith("~./")) {
            path = path.substring(2);
        } else if (path.charAt(0) != '/') {
            path = Files.normalize((String)dir, (String)path);
        }
        InputStream is = this.getProvider().getResourceAsStream(path, locate);
        if (is == null) {
            this.write(out, "zk.log('");
            this.write(out, path);
            this.write(out, " not found');");
            return false;
        }
        Files.copy((OutputStream)out, (InputStream)is);
        Files.close((InputStream)is);
        this.write(out, '\n');
        return true;
    }

    private void write(OutputStream out, String s) throws IOException {
        if (s != null) {
            byte[] bs = s.getBytes("UTF-8");
            out.write(bs, 0, bs.length);
        }
    }

    private void writeln(OutputStream out) throws IOException {
        this.write(out, '\n');
    }

    private void write(OutputStream out, char cc) throws IOException {
        assert (cc < '\u0080');
        byte[] bs = new byte[]{(byte)cc};
        out.write(bs, 0, 1);
    }

    private void write(OutputStream out, AbstractExtendlet.MethodInfo mtd) throws IOException {
        this.write(out, this.invoke(mtd));
    }

    private void move(WpdContent wc, ByteArrayOutputStream out) {
        byte[] bs = out.toByteArray();
        if (bs.length > 0) {
            wc.add(bs);
            out.reset();
        }
    }

    private void writeAppInfo(OutputStream out, WebApp wapp) throws IOException, ServletException {
        String deviceType;
        Object[][] infs;
        StringBuffer sb = new StringBuffer(256);
        sb.append("\nzkver('").append(wapp.getVersion()).append("','").append(wapp.getBuild());
        Provider provider = this.getProvider();
        if (provider != null) {
            ServletContext ctx = this.getServletContext();
            String s = Encodes.encodeURL((ServletContext)ctx, (ServletRequest)provider.request, (ServletResponse)provider.response, (String)"/");
            int j = s.lastIndexOf(47);
            if (j >= 0) {
                s = s.substring(0, j) + s.substring(j + 1);
            }
            sb.append("','").append(s).append("','").append(Encodes.encodeURL((ServletContext)ctx, (ServletRequest)provider.request, (ServletResponse)provider.response, (String)wapp.getUpdateURI(false)));
        } else {
            sb.append("','','");
        }
        sb.append("',{");
        for (LanguageDefinition langdef : LanguageDefinition.getByDeviceType(this.getDeviceType())) {
            for (Map.Entry<String, String> me : langdef.getJavaScriptModules().entrySet()) {
                sb.append('\'').append((Object)me.getKey()).append("':'").append((Object)me.getValue()).append("',");
            }
            WpdExtendlet.removeLast(sb, ',');
        }
        sb.append("},{");
        if (WebApps.getFeature("ee")) {
            sb.append("ed:'e',");
        } else if (WebApps.getFeature("pe")) {
            sb.append("ed:'p',");
        }
        Configuration config = wapp.getConfiguration();
        int v = config.getProcessingPromptDelay();
        if (v != 900) {
            sb.append("pd:").append(v).append(',');
        }
        if ((v = config.getTooltipDelay()) != 800) {
            sb.append("td:").append(v).append(',');
        }
        if ((v = config.getResendDelay()) > 0) {
            sb.append("rd:").append(v).append(',');
        }
        if (config.isTimerKeepAlive()) {
            sb.append("ta:1,");
        }
        if (config.isDebugJS()) {
            sb.append("dj:1,");
        }
        if (config.isKeepDesktopAcrossVisits()) {
            sb.append("kd:1,");
        }
        if (config.getPerformanceMeter() != null) {
            sb.append("pf:1,");
        }
        if ((infs = config.getClientErrorReloads(deviceType = this.getDeviceType(), null)) != null) {
            sb.append("eu:{");
            this.outErrReloads(config, sb, infs);
            sb.append("},");
        }
        if ((infs = config.getClientErrorReloads(deviceType, "server-push")) != null) {
            sb.append("eup:{");
            this.outErrReloads(config, sb, infs);
            sb.append("},");
        }
        WpdExtendlet.removeLast(sb, ',');
        sb.append("});");
        this.write(out, sb.toString());
    }

    private void outErrReloads(Configuration config, StringBuffer sb, Object[][] infs) {
        for (int j = 0; j < infs.length; ++j) {
            if (j > 0) {
                sb.append(',');
            }
            sb.append('\'').append(infs[j][0]).append("':'");
            String uri = ((URIInfo)infs[j][1]).uri;
            if (uri.length() > 0) {
                try {
                    Provider provider = this.getProvider();
                    uri = Encodes.encodeURL((ServletContext)this.getServletContext(), (ServletRequest)provider.request, (ServletResponse)provider.response, (String)uri);
                }
                catch (ServletException ex) {
                    throw new UiException("Unable to encode " + uri, (Throwable)ex);
                }
            }
            sb.append(Strings.escape((String)uri, (String)"'\\")).append('\'');
        }
    }

    private static void removeLast(StringBuffer sb, char cc) {
        if (sb.charAt(sb.length() - 1) == cc) {
            sb.setLength(sb.length() - 1);
        }
    }

    private static String outMain(String main, Map<String, String[]> params) {
        StringBuffer sb = new StringBuffer("\nzkamn('");
        int j = main.lastIndexOf(46);
        if (j >= 0) {
            sb.append(main.substring(0, j));
        }
        sb.append("',function(){\n").append(main).append(".main(");
        LinkedHashMap<String, String[]> ms = new LinkedHashMap<String, String[]>();
        for (Map.Entry<String, String[]> me : params.entrySet()) {
            String nm = me.getKey();
            if ("main".equals(nm)) continue;
            String[] vals = me.getValue();
            ms.put(nm, (String[])(vals.length == 0 ? null : (vals.length == 1 ? vals[0] : vals)));
        }
        sb.append(JSONObject.toJSONString(ms)).append(")\n})");
        return sb.toString();
    }

    private static String outHost(HttpServletRequest request, WebApp wapp, String clientPackages) {
        String uri;
        StringBuffer sb = new StringBuffer().append("zk.setHost('").append(request.getScheme()).append("://").append(request.getServerName());
        if (request.getServerPort() != 80) {
            sb.append(':').append(request.getServerPort());
        }
        if ((uri = request.getContextPath()) != null && uri.length() > 0) {
            if (uri.charAt(0) != '/') {
                sb.append('/');
            }
            sb.append(uri);
            WpdExtendlet.removeLast(sb, '/');
        }
        return sb.append("','").append(wapp.getUpdateURI(false)).append("',").append(clientPackages).append(");").toString();
    }

    class WpdContent {
        private final String name;
        private final String _dir;
        private final List<Object> _cnt = new LinkedList<Object>();
        private final boolean cacheable;

        private WpdContent(String name, String dir, boolean cacheable) {
            this.name = name;
            this._dir = dir;
            this.cacheable = cacheable;
        }

        private void add(byte[] bs) {
            this._cnt.add(bs);
        }

        private void add(AbstractExtendlet.MethodInfo mtd) {
            this._cnt.add(mtd);
        }

        private void add(String jspath, String browser) {
            this._cnt.add(new String[]{jspath, browser});
        }

        private void addHost(WebApp wapp, String clientPackages) {
            this._cnt.add(new Object[]{wapp, clientPackages});
        }

        byte[] toByteArray(HttpServletRequest request) throws ServletException, IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            String main = request != null ? request.getParameter("main") : null;
            for (Object o : this._cnt) {
                Object[] inf;
                if (o instanceof byte[]) {
                    out.write((byte[])o);
                    continue;
                }
                if (o instanceof AbstractExtendlet.MethodInfo) {
                    WpdExtendlet.this.write(out, (AbstractExtendlet.MethodInfo)o);
                    continue;
                }
                if (o instanceof String[]) {
                    Provider provider;
                    inf = (String[])o;
                    if (inf[1] != null && (provider = WpdExtendlet.this.getProvider()) != null && !Servlets.isBrowser((ServletRequest)provider.request, (String)inf[1]) || WpdExtendlet.this.writeResource(out, (String)inf[0], this._dir, true)) continue;
                    AbstractExtendlet.log.error((String)inf[0] + " not found");
                    continue;
                }
                if (!(o instanceof Object[]) || main == null) continue;
                inf = (Object[])o;
                WpdExtendlet.this.write(out, WpdExtendlet.outHost(request, (WebApp)inf[0], (String)inf[1]));
            }
            if (main != null && main.length() > 0) {
                WpdExtendlet.this.write(out, WpdExtendlet.outMain(main, request.getParameterMap()));
            }
            return out.toByteArray();
        }
    }

    static class ByteContent {
        final byte[] content;
        final boolean cacheable;

        private ByteContent(byte[] cnt, boolean cacheable) {
            this.content = cnt;
            this.cacheable = cacheable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WpdLoader
    extends ExtendletLoader<Object> {
        private WpdLoader() {
        }

        protected Object parse(InputStream is, String path, String orgpath) throws Exception {
            return WpdExtendlet.this.parse(is, path);
        }

        protected ExtendletContext getExtendletContext() {
            return WpdExtendlet.this._webctx;
        }

        protected String getRealPath(String path) {
            int j = path.lastIndexOf(".wpd");
            return path.substring(0, j).replace('.', '/') + "/zk" + path.substring(j);
        }
    }
}

