/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.impl;

import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Threads;
import org.zkoss.util.Locales;
import org.zkoss.util.TimeZones;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventThreadCleanup;
import org.zkoss.zk.ui.event.EventThreadInit;
import org.zkoss.zk.ui.event.EventThreadResume;
import org.zkoss.zk.ui.event.EventThreadSuspend;
import org.zkoss.zk.ui.impl.EventProcessor;
import org.zkoss.zk.ui.sys.EventProcessingThread;
import org.zkoss.zk.ui.sys.ExecutionCtrl;
import org.zkoss.zk.ui.util.Configuration;
import org.zkoss.zk.ui.util.ExecutionMonitor;

public class EventProcessingThreadImpl
extends Thread
implements EventProcessingThread {
    private static final Log log = Log.lookup(EventProcessingThreadImpl.class);
    private EventProcessor _proc;
    private Locale _locale;
    private TimeZone _timeZone;
    private List<EventThreadInit> _evtThdInits;
    private List<EventThreadCleanup> _evtThdCleanups;
    private List<EventThreadResume> _evtThdResumes;
    private List<EventThreadSuspend> _evtThdSuspends;
    private Throwable _ex;
    private boolean _acted;
    private static int _nThd;
    private static int _nBusyThd;
    private final Object _evtmutex = new Object();
    private Object _suspmutex;
    private String _ceased;
    private boolean _silent;
    private transient boolean _suspended;

    public EventProcessingThreadImpl() {
        Threads.setDaemon((Thread)this, (boolean)true);
        this.start();
    }

    public boolean isCeased() {
        return this._ceased != null || !this.isAlive();
    }

    public boolean isSuspended() {
        return this._suspended;
    }

    public synchronized boolean isIdle() {
        return this._proc == null;
    }

    public final Event getEvent() {
        return this._proc.getEvent();
    }

    public final Component getComponent() {
        return this._proc.getComponent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEvent(Component comp, Event event) throws Exception {
        if (event == null || comp == null) {
            throw new IllegalArgumentException("Both comp and event must be specified");
        }
        if (!(Thread.currentThread() instanceof EventProcessingThreadImpl)) {
            throw new IllegalStateException("Only callable when processing an event");
        }
        EventProcessor oldproc = this._proc;
        this._proc = new EventProcessor(this._proc.getDesktop(), comp, event);
        try {
            this.setup();
            this.process0();
        }
        finally {
            this._proc = oldproc;
            if (this._ceased != null) {
                throw new InterruptedException(this._ceased);
            }
            this.setup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cease(String cause) {
        Object object = this._evtmutex;
        synchronized (object) {
            this._ceased = cause != null ? cause : "";
            this._evtmutex.notifyAll();
        }
        if (this._suspmutex != null) {
            object = this._suspmutex;
            synchronized (object) {
                this._suspmutex.notifyAll();
            }
        }
    }

    public void ceaseSilently(String cause) {
        this._silent = true;
        this.cease(cause);
    }

    public static final int getThreadNumber() {
        return _nThd;
    }

    public static final int getThreadNumberInProcessing() {
        return _nBusyThd;
    }

    public static void doSuspend(Object mutex) throws InterruptedException {
        ((EventProcessingThreadImpl)Thread.currentThread()).doSuspend0(mutex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSuspend0(Object mutex) throws InterruptedException {
        if (mutex == null) {
            throw new IllegalArgumentException("null mutex");
        }
        if (this.isIdle()) {
            throw new InternalError("Called without processing event?");
        }
        if (this._suspmutex != null) {
            throw new InternalError("Suspend twice?");
        }
        ExecutionMonitor execmon = null;
        this._suspmutex = mutex;
        try {
            Object object = this._suspmutex;
            synchronized (object) {
                this._suspended = true;
                Execution exec = this.getExecution();
                if (exec != null) {
                    this._acted = false;
                    try {
                        ((ExecutionCtrl)((Object)exec)).onDeactivate();
                    }
                    catch (Throwable ex) {
                        log.warningBriefly("Ignored deactivate failure", ex);
                    }
                }
                Object object2 = this._evtmutex;
                synchronized (object2) {
                    this._evtmutex.notify();
                }
                if (this._ceased == null) {
                    execmon = this._proc.getDesktop().getWebApp().getConfiguration().getExecutionMonitor();
                    if (execmon != null) {
                        execmon.eventSuspend(this.getEvent());
                    }
                    this._suspmutex.wait();
                }
            }
        }
        finally {
            this._suspmutex = null;
            this._suspended = false;
            if (execmon != null) {
                execmon.eventResume(this.getEvent());
            }
        }
        if (this._ceased != null) {
            throw new InterruptedException(this._ceased);
        }
        this.setup();
        Execution exec = this.getExecution();
        if (exec != null) {
            ((ExecutionCtrl)((Object)exec)).onActivate();
            this._acted = true;
        }
        List<EventThreadResume> resumes = this._evtThdResumes;
        this._evtThdResumes = null;
        if (resumes != null && !resumes.isEmpty()) {
            this._proc.getDesktop().getWebApp().getConfiguration().invokeEventThreadResumes(resumes, this.getComponent(), this.getEvent());
        }
    }

    private Execution getExecution() {
        Execution exec = this._proc.getDesktop().getExecution();
        return exec != null ? exec : Executions.getCurrent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doResume() throws InterruptedException {
        if (this.equals(Thread.currentThread())) {
            throw new IllegalStateException("A thread cannot resume itself");
        }
        if (this.isIdle()) {
            throw new InternalError("Called without processing event?");
        }
        if (this._suspmutex == null) {
            throw new InternalError("Resume non-suspended thread?");
        }
        Configuration config = this._proc.getDesktop().getWebApp().getConfiguration();
        Component comp = this.getComponent();
        Event event = this.getEvent();
        try {
            this._evtThdResumes = config.newEventThreadResumes(comp, event);
            Object object = this._suspmutex;
            synchronized (object) {
                this._suspended = false;
                this._suspmutex.notify();
            }
            object = this._evtmutex;
            synchronized (object) {
                if (this._ceased == null && !this.isIdle() && !this._suspended) {
                    this._evtmutex.wait();
                }
            }
        }
        finally {
            this.invokeEventThreadCompletes(config, comp, event);
        }
        this.checkError();
        return this.isIdle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean processEvent(Desktop desktop, Component comp, Event event) {
        if (Thread.currentThread() instanceof EventProcessingThreadImpl) {
            throw new IllegalStateException("processEvent cannot be called in an event thread");
        }
        if (this._ceased != null) {
            throw new InternalError("The event thread has beeing stopped. Cause: " + this._ceased);
        }
        if (this._proc != null) {
            throw new InternalError("reentering processEvent not allowed");
        }
        this._locale = Locales.getCurrent();
        this._timeZone = TimeZones.getCurrent();
        this._ex = null;
        EventProcessor proc = new EventProcessor(desktop, comp, event);
        Configuration config = desktop.getWebApp().getConfiguration();
        this._evtThdInits = config.newEventThreadInits(comp, event);
        try {
            long evtTimeWarn = config.getEventTimeWarning();
            long begt = 0L;
            if (evtTimeWarn > 0L) {
                begt = System.currentTimeMillis();
                evtTimeWarn *= 1000L;
            }
            while (true) {
                Object object = this._evtmutex;
                synchronized (object) {
                    this._proc = proc;
                    this._evtmutex.notify();
                    if (this._ceased == null) {
                        if (evtTimeWarn > 0L) {
                            this._evtmutex.wait(evtTimeWarn);
                        } else {
                            this._evtmutex.wait();
                        }
                        if (this._suspended) {
                            config.invokeEventThreadSuspends(this._evtThdSuspends, comp, event);
                            this._evtThdSuspends = null;
                            break;
                        }
                        if (this._proc == null || this._ceased != null) {
                            break;
                        }
                        if (!this.isAlive()) {
                            throw new UiException("The event processing thread was aborted");
                        }
                        log.warning("The event processing takes more than " + (System.currentTimeMillis() - begt) / 1000L + " seconds: " + proc);
                    }
                }
            }
        }
        catch (InterruptedException ex) {
            throw new UiException(ex);
        }
        finally {
            this.invokeEventThreadCompletes(config, comp, event);
        }
        this.checkError();
        return this.isIdle();
    }

    public void newEventThreadSuspends(Object mutex) {
        if (this._proc == null) {
            throw new IllegalStateException();
        }
        this._evtThdSuspends = this._proc.getDesktop().getWebApp().getConfiguration().newEventThreadSuspends(this.getComponent(), this.getEvent(), mutex);
    }

    private void invokeEventThreadCompletes(Configuration config, Component comp, Event event) throws UiException {
        LinkedList<Throwable> errs = new LinkedList<Throwable>();
        if (this._ex != null) {
            errs.add(this._ex);
        }
        if (this._evtThdCleanups != null && !this._evtThdCleanups.isEmpty()) {
            config.invokeEventThreadCompletes(this._evtThdCleanups, comp, event, errs, this._ceased != null);
        }
        this._evtThdCleanups = null;
        this._ex = errs.isEmpty() ? null : (Throwable)errs.get(0);
    }

    private synchronized void setup() {
        this._proc.setup();
    }

    private synchronized void cleanup() {
        this._proc.cleanup();
        this._proc = null;
    }

    private void checkError() {
        if (this._ex != null) {
            Throwable ex = this._ex;
            this._ex = null;
            throw UiException.Aide.wrap(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        Object object;
        ++_nThd;
        try {
            while (this._ceased == null) {
                Object config;
                block42: {
                    if (!this.isIdle()) {
                        Throwable ex2222;
                        Object var6_7;
                        Execution exec;
                        boolean cleaned;
                        block40: {
                            block39: {
                                config = this._proc.getDesktop().getWebApp().getConfiguration();
                                cleaned = false;
                                ++_nBusyThd;
                                exec = null;
                                Locales.setThreadLocal((Locale)this._locale);
                                TimeZones.setThreadLocal((TimeZone)this._timeZone);
                                this.setup();
                                exec = this.getExecution();
                                if (exec != null) {
                                    ((ExecutionCtrl)((Object)exec)).onActivate();
                                    this._acted = true;
                                }
                                boolean b = ((Configuration)config).invokeEventThreadInits(this._evtThdInits, this.getComponent(), this.getEvent());
                                this._evtThdInits = null;
                                if (!b) break block39;
                                this.process0();
                            }
                            var6_7 = null;
                            --_nBusyThd;
                            if (!cleaned) {
                                this.newEventThreadCleanups((Configuration)config, this._ex);
                            }
                            if (exec == null || !this._acted) break block40;
                            this._acted = false;
                            try {
                                ((ExecutionCtrl)((Object)exec)).onDeactivate();
                            }
                            catch (Throwable ex2222) {
                                log.warningBriefly("Ignored deactivate failure", ex2222);
                            }
                        }
                        this.cleanup();
                        this._locale = null;
                        Locales.setThreadLocal(null);
                        this._timeZone = null;
                        TimeZones.setThreadLocal(null);
                        if (this._ex != null && this._ceased != null) {
                            this._ex = null;
                        }
                        break block42;
                        {
                            catch (Throwable ex3) {
                                cleaned = true;
                                this.newEventThreadCleanups((Configuration)config, ex3);
                                var6_7 = null;
                                --_nBusyThd;
                                if (!cleaned) {
                                    this.newEventThreadCleanups((Configuration)config, this._ex);
                                }
                                if (exec != null && this._acted) {
                                    this._acted = false;
                                    try {
                                        ((ExecutionCtrl)((Object)exec)).onDeactivate();
                                    }
                                    catch (Throwable ex2222) {
                                        log.warningBriefly("Ignored deactivate failure", ex2222);
                                    }
                                }
                                this.cleanup();
                                this._locale = null;
                                Locales.setThreadLocal(null);
                                this._timeZone = null;
                                TimeZones.setThreadLocal(null);
                                if (this._ex != null && this._ceased != null) {
                                    this._ex = null;
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            var6_7 = null;
                            --_nBusyThd;
                            if (!cleaned) {
                                this.newEventThreadCleanups((Configuration)config, this._ex);
                            }
                            if (exec != null && this._acted) {
                                this._acted = false;
                                try {
                                    ((ExecutionCtrl)((Object)exec)).onDeactivate();
                                }
                                catch (Throwable ex2222) {
                                    log.warningBriefly("Ignored deactivate failure", ex2222);
                                }
                            }
                            this.cleanup();
                            this._locale = null;
                            Locales.setThreadLocal(null);
                            this._timeZone = null;
                            TimeZones.setThreadLocal(null);
                            if (this._ex != null && this._ceased != null) {
                                this._ex = null;
                            }
                            throw throwable;
                        }
                    }
                }
                config = this._evtmutex;
                synchronized (config) {
                    this._evtmutex.notify();
                    if (this._ceased == null) {
                        this._evtmutex.wait();
                    }
                }
            }
            Object var10_11 = null;
            --_nThd;
            object = this._evtmutex;
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            --_nThd;
            Object object2 = this._evtmutex;
            synchronized (object2) {
                boolean abnormal;
                boolean bl = abnormal = this._ceased == null;
                if (abnormal) {
                    this._ceased = "Unknow reason";
                }
                this._evtmutex.notify();
            }
            throw throwable;
        }
        synchronized (object) {
            boolean abnormal;
            boolean bl = abnormal = this._ceased == null;
            if (abnormal) {
                this._ceased = "Unknow reason";
            }
            this._evtmutex.notify();
        }
        {
            catch (Throwable ex) {
                if (this._ceased == null) {
                    this._ceased = Exceptions.getMessage((Throwable)ex);
                }
                if (Exceptions.findCause((Throwable)ex, InterruptedException.class) == null) {
                    throw UiException.Aide.wrap(ex);
                }
                Object var10_12 = null;
                --_nThd;
                Object object3 = this._evtmutex;
                synchronized (object3) {
                    boolean abnormal;
                    boolean bl = abnormal = this._ceased == null;
                    if (abnormal) {
                        this._ceased = "Unknow reason";
                    }
                    this._evtmutex.notify();
                }
            }
        }
    }

    private void newEventThreadCleanups(Configuration config, Throwable ex) {
        LinkedList<Throwable> errs = new LinkedList<Throwable>();
        if (ex != null) {
            errs.add(ex);
        }
        this._evtThdCleanups = config.newEventThreadCleanups(this.getComponent(), this.getEvent(), errs, this._ceased != null);
        this._ex = errs.isEmpty() ? null : (Throwable)errs.get(0);
    }

    private void process0() throws Exception {
        if (this._proc == null) {
            throw new IllegalStateException("Not initialized");
        }
        this._proc.process();
    }

    public String toString() {
        return "[" + this.getName() + ": " + this._proc + ", ceased=" + this._ceased + ']';
    }
}

