/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import org.zkoss.util.CacheMap;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.ui.ComponentNotFoundException;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.sys.DesktopCache;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.Configuration;
import org.zkoss.zk.ui.util.DesktopRecycle;
import org.zkoss.zk.ui.util.Monitor;

public class SimpleDesktopCache
implements DesktopCache,
Serializable {
    private static final Log log = Log.lookup(SimpleDesktopCache.class);
    private static final long serialVersionUID = 20060622L;
    private final Cache _desktops;
    private int _nextKey;

    public SimpleDesktopCache(Configuration config) {
        this._desktops = new Cache(config);
        if (!config.isRepeatUuid()) {
            this._nextKey = (int)System.currentTimeMillis() & 0xFFFF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextKey() {
        SimpleDesktopCache simpleDesktopCache = this;
        synchronized (simpleDesktopCache) {
            return this._nextKey++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Desktop getDesktopIfAny(String desktopId) {
        Cache cache = this._desktops;
        synchronized (cache) {
            Desktop desktop;
            boolean old = this._desktops.disableExpunge(true);
            try {
                desktop = (Desktop)this._desktops.get(desktopId);
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this._desktops.disableExpunge(old);
                throw throwable;
            }
            this._desktops.disableExpunge(old);
            return desktop;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Desktop getDesktop(String desktopId) {
        Desktop desktop;
        Cache cache = this._desktops;
        synchronized (cache) {
            desktop = (Desktop)this._desktops.get(desktopId);
        }
        if (desktop == null) {
            throw new ComponentNotFoundException("Desktop not found: " + desktopId);
        }
        return desktop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDesktop(Desktop desktop) {
        Desktop old;
        Cache cache = this._desktops;
        synchronized (cache) {
            old = (Desktop)this._desktops.put(desktop.getId(), desktop);
        }
        if (old != null) {
            this._desktops.put(old.getId(), old);
            log.warning(desktop == old ? "Register a desktop twice: " + desktop : "Replicated ID: " + desktop + "; already used by " + old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDesktop(Desktop desktop) {
        boolean oldexp = this._desktops.disableExpunge(true);
        try {
            Desktop old;
            Cache cache = this._desktops;
            synchronized (cache) {
                old = (Desktop)this._desktops.remove(desktop.getId());
            }
            if (old == null) {
                log.warning("Removing non-existent desktop: " + desktop);
            } else {
                SimpleDesktopCache.desktopDestroyed(desktop);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this._desktops.disableExpunge(oldexp);
            throw throwable;
        }
        this._desktops.disableExpunge(oldexp);
    }

    private static void desktopDestroyed(Desktop desktop) {
        DesktopRecycle dtrc;
        Session sess = desktop.getSession();
        WebApp wapp = desktop.getWebApp();
        ((DesktopCtrl)((Object)desktop)).invokeDesktopCleanups();
        Configuration config = wapp.getConfiguration();
        config.invokeDesktopCleanups(desktop);
        ((WebAppCtrl)((Object)wapp)).getUiEngine().desktopDestroyed(desktop);
        Monitor monitor = desktop.getWebApp().getConfiguration().getMonitor();
        if (monitor != null) {
            try {
                monitor.desktopDestroyed(desktop);
            }
            catch (Throwable ex) {
                log.error(ex);
            }
        }
        if ((dtrc = config.getDesktopRecycle()) != null) {
            try {
                dtrc.afterRemove(sess, desktop);
            }
            catch (Throwable ex) {
                log.error(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionWillPassivate(Session sess) {
        Cache cache = this._desktops;
        synchronized (cache) {
            boolean old = this._desktops.disableExpunge(true);
            try {
                for (Desktop desktop : this._desktops.values()) {
                    ((DesktopCtrl)((Object)desktop)).sessionWillPassivate(sess);
                }
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this._desktops.disableExpunge(old);
                throw throwable;
            }
            this._desktops.disableExpunge(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionDidActivate(Session sess) {
        Cache cache = this._desktops;
        synchronized (cache) {
            boolean old = this._desktops.disableExpunge(true);
            try {
                for (Desktop desktop : this._desktops.values()) {
                    ((DesktopCtrl)((Object)desktop)).sessionDidActivate(sess);
                }
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this._desktops.disableExpunge(old);
                throw throwable;
            }
            this._desktops.disableExpunge(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Cache cache = this._desktops;
        synchronized (cache) {
            if (log.debugable()) {
                log.debug("Invalidated and remove: " + (Object)((Object)this._desktops));
            }
            boolean old = this._desktops.disableExpunge(true);
            try {
                for (Desktop desktop : new ArrayList(this._desktops.values())) {
                    SimpleDesktopCache.desktopDestroyed(desktop);
                }
                this._desktops.clear();
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this._desktops.disableExpunge(old);
                throw throwable;
            }
            this._desktops.disableExpunge(old);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Cache
    extends CacheMap<String, Desktop> {
        private boolean _expungeDisabled;

        private Cache(Configuration config) {
            super(16);
            int v = config.getSessionMaxDesktops();
            this.setMaxSize(v >= 0 ? v : 0x1FFFFFFF);
            v = config.getDesktopMaxInactiveInterval();
            this.setLifetime(v >= 0 ? v * 1000 : 0x1FFFFFFF);
        }

        private synchronized boolean disableExpunge(boolean disable) {
            boolean old = this._expungeDisabled;
            this._expungeDisabled = disable;
            return old;
        }

        protected boolean shallExpunge() {
            return !this._expungeDisabled && (super.shallExpunge() || this.sizeWithoutExpunge() > this.getMaxSize() << 2);
        }

        protected int canExpunge(CacheMap.Value v) {
            if (((Desktop)v.getValue()).getExecution() != null) {
                return 0;
            }
            return super.canExpunge(v);
        }

        protected void onExpunge(CacheMap.Value v) {
            super.onExpunge(v);
            SimpleDesktopCache.desktopDestroyed((Desktop)v.getValue());
            if (log.debugable()) {
                log.debug("Expunge desktop: " + v.getValue());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            boolean old = this.disableExpunge(true);
            try {
                s.defaultReadObject();
                Object var4_3 = null;
                this.disableExpunge(old);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.disableExpunge(old);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void writeObject(ObjectOutputStream s) throws IOException {
            boolean old = this.disableExpunge(true);
            try {
                s.defaultWriteObject();
                Object var4_3 = null;
                this.disableExpunge(old);
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.disableExpunge(old);
                throw throwable;
            }
        }
    }
}

