/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.impl;

import org.zkoss.lang.Classes;
import org.zkoss.lang.Library;
import org.zkoss.util.logging.Log;
import org.zkoss.util.resource.ClassLocator;
import org.zkoss.util.resource.XMLResourcesLocator;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.impl.DesktopImpl;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.Composer;

public class Utils {
    private static final Log log = Log.lookup(Utils.class);
    private static XMLResourcesLocator _xmlloc;

    public static boolean markClientInfoPerDesktop(Desktop desktop, String key) {
        return !(desktop instanceof DesktopImpl) || ((DesktopImpl)desktop).markClientInfoPerDesktop(key);
    }

    public static XMLResourcesLocator getXMLResourcesLocator() {
        if (_xmlloc == null) {
            String clsnm = Library.getProperty((String)"org.zkoss.zk.ui.sys.XMLResourcesLocator.class");
            if (clsnm != null) {
                try {
                    _xmlloc = (XMLResourcesLocator)Classes.newInstanceByThread((String)clsnm);
                    return _xmlloc;
                }
                catch (Throwable ex) {
                    log.warningBriefly("Unable to load " + clsnm, ex);
                }
            }
            _xmlloc = new ClassLocator();
        }
        return _xmlloc;
    }

    public static Composer newComposer(Page page, Object o) throws Exception {
        Class cls;
        if (o instanceof String) {
            String clsnm = ((String)o).trim();
            if (page != null) {
                return ((WebAppCtrl)((Object)page.getDesktop().getWebApp())).getUiFactory().newComposer(page, clsnm);
            }
            cls = Classes.forNameByThread((String)clsnm);
        } else if (o instanceof Class) {
            cls = (Class)o;
            if (page != null) {
                return ((WebAppCtrl)((Object)page.getDesktop().getWebApp())).getUiFactory().newComposer(page, cls);
            }
        } else {
            return (Composer)o;
        }
        return (Composer)cls.newInstance();
    }
}

