/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.metainfo;

import java.io.File;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.zkoss.idom.Attribute;
import org.zkoss.idom.CData;
import org.zkoss.idom.Document;
import org.zkoss.idom.Element;
import org.zkoss.idom.Item;
import org.zkoss.idom.Namespace;
import org.zkoss.idom.ProcessingInstruction;
import org.zkoss.idom.Text;
import org.zkoss.idom.input.SAXBuilder;
import org.zkoss.lang.ClassResolver;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Library;
import org.zkoss.lang.PotentialDeadLockException;
import org.zkoss.util.CollectionsX;
import org.zkoss.util.logging.Log;
import org.zkoss.util.resource.Locator;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.xel.Function;
import org.zkoss.xel.taglib.Taglib;
import org.zkoss.xel.util.Evaluators;
import org.zkoss.xel.util.MethodFunction;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Components;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.impl.RequestInfoImpl;
import org.zkoss.zk.ui.impl.ZScriptInitiator;
import org.zkoss.zk.ui.metainfo.AttributesInfo;
import org.zkoss.zk.ui.metainfo.ComponentDefinition;
import org.zkoss.zk.ui.metainfo.ComponentInfo;
import org.zkoss.zk.ui.metainfo.DefinitionNotFoundException;
import org.zkoss.zk.ui.metainfo.ForwardInfo;
import org.zkoss.zk.ui.metainfo.FunctionMapperInfo;
import org.zkoss.zk.ui.metainfo.HeaderInfo;
import org.zkoss.zk.ui.metainfo.InitiatorInfo;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.metainfo.NativeInfo;
import org.zkoss.zk.ui.metainfo.NodeInfo;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.metainfo.ResponseHeaderInfo;
import org.zkoss.zk.ui.metainfo.TemplateInfo;
import org.zkoss.zk.ui.metainfo.TextInfo;
import org.zkoss.zk.ui.metainfo.VariableResolverInfo;
import org.zkoss.zk.ui.metainfo.VariablesInfo;
import org.zkoss.zk.ui.metainfo.ZScript;
import org.zkoss.zk.ui.metainfo.ZScriptInfo;
import org.zkoss.zk.ui.metainfo.ZkInfo;
import org.zkoss.zk.ui.metainfo.impl.AnnotationHelper;
import org.zkoss.zk.ui.metainfo.impl.ComponentDefinitionImpl;
import org.zkoss.zk.ui.sys.UiFactory;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.ConditionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser {
    private static final Log log = Log.lookup(Parser.class);
    private final WebApp _wapp;
    private final Locator _locator;
    private static Boolean _trimLabel;

    public Parser(WebApp wapp, Locator locator) {
        if (wapp == null) {
            throw new IllegalArgumentException("null");
        }
        this._wapp = wapp;
        this._locator = locator != null ? locator : wapp;
    }

    public PageDefinition parse(File file, String path) throws Exception {
        PageDefinition pgdef = this.parse(new SAXBuilder(true, false, true).build(file), Servlets.getExtension((String)file.getName()));
        pgdef.setRequestPath(path);
        return pgdef;
    }

    public PageDefinition parse(URL url, String path) throws Exception {
        PageDefinition pgdef = this.parse(new SAXBuilder(true, false, true).build(url), Servlets.getExtension((String)url.toExternalForm()));
        pgdef.setRequestPath(path);
        return pgdef;
    }

    public PageDefinition parse(Reader reader, String extension) throws Exception {
        return this.parse(new SAXBuilder(true, false, true).build(reader), extension);
    }

    public PageDefinition parse(Document doc, String extension) throws Exception {
        LinkedList<ProcessingInstruction> pis = new LinkedList<ProcessingInstruction>();
        LinkedList<String[]> imports = new LinkedList<String[]>();
        LinkedList<String> impclses = new LinkedList<String>();
        String lang = null;
        for (Item o : doc.getChildren()) {
            Map params;
            if (!(o instanceof ProcessingInstruction)) continue;
            ProcessingInstruction pi = (ProcessingInstruction)o;
            String target = pi.getTarget();
            if ("page".equals(target)) {
                params = pi.parseData();
                String l = (String)params.remove("language");
                if (l != null) {
                    Parser.noEL("language", l, (Item)pi);
                    lang = l;
                }
                if (params.isEmpty()) continue;
                pis.add(pi);
                continue;
            }
            if ("import".equals(target)) {
                params = pi.parseData();
                String src = (String)params.remove("src");
                String dirs = (String)params.remove("directives");
                String cls = (String)params.remove("class");
                if (src != null) {
                    Parser.noELnorEmpty("src", src, (Item)pi);
                    Parser.noEL("directives", dirs, (Item)pi);
                    imports.add(new String[]{src, dirs});
                }
                if (cls != null) {
                    Parser.noELnorEmpty("class", cls, (Item)pi);
                    impclses.add(cls);
                }
                for (Map.Entry me : params.entrySet()) {
                    String nm = (String)me.getKey();
                    String val = (String)me.getValue();
                    if (val == null) {
                        Parser.noELnorEmpty(nm, nm, (Item)pi);
                        impclses.add(nm);
                        continue;
                    }
                    log.warning("Ignored unknown attribute for import: " + nm + ", " + pi.getLocator());
                }
                continue;
            }
            pis.add(pi);
        }
        LanguageDefinition langdef = extension != null && lang == null ? LanguageDefinition.getByExtension(extension) : LanguageDefinition.lookup(lang);
        PageDefinition pgdef = new PageDefinition(langdef, this.getLocator());
        if (!imports.isEmpty()) {
            RequestInfoImpl ri = new RequestInfoImpl(this._wapp, null, null, null, this.getLocator());
            UiFactory uf = ((WebAppCtrl)((Object)this._wapp)).getUiFactory();
            for (String[] imprt : imports) {
                String path = imprt[0];
                String dirs = imprt[1];
                try {
                    PageDefinition pd = uf.getPageDefinition(ri, path);
                    if (pd == null) {
                        throw new UiException("The imported page not found: " + path);
                    }
                    pgdef.imports(pd, Parser.parseToArray(dirs));
                }
                catch (PotentialDeadLockException ex) {
                    throw new UiException("Recursive import not allowed: " + path, (Throwable)ex);
                }
            }
        }
        for (String impcls : impclses) {
            pgdef.addImportedClass(impcls);
        }
        Iterator it = pis.iterator();
        while (it.hasNext()) {
            this.parse(pgdef, (ProcessingInstruction)it.next());
        }
        Element root = doc.getRootElement();
        if (root != null) {
            this.parseItem(pgdef, pgdef, root, new AnnotationHelper(), false);
        }
        return pgdef;
    }

    private static String[] parseToArray(String s) {
        if (s == null) {
            return null;
        }
        Collection ims = CollectionsX.parse(null, (String)s, (char)',', (boolean)false);
        return ims.toArray(new String[ims.size()]);
    }

    public Locator getLocator() {
        return this._locator;
    }

    private void parse(PageDefinition pgdef, ProcessingInstruction pi) throws Exception {
        String target = pi.getTarget();
        Map params = pi.parseData();
        if ("page".equals(target)) {
            Parser.parsePageDirective(pgdef, pi, params);
        } else if ("init".equals(target)) {
            this.parseInitDirective(pgdef, pi, params);
        } else if ("variable-resolver".equals(target) || "function-mapper".equals(target)) {
            String clsnm = (String)params.remove("class");
            if (Parser.isEmpty(clsnm)) {
                throw new UiException("The class attribute is required, " + pi.getLocator());
            }
            LinkedHashMap<String, String> args = new LinkedHashMap<String, String>(params);
            if ("variable-resolver".equals(target)) {
                pgdef.addVariableResolverInfo(new VariableResolverInfo(clsnm, args));
            } else {
                pgdef.addFunctionMapperInfo(new FunctionMapperInfo(clsnm, args));
            }
        } else if ("component".equals(target)) {
            this.parseComponentDirective(pgdef, pi, params);
        } else if ("taglib".equals(target)) {
            String uri = (String)params.remove("uri");
            String prefix = (String)params.remove("prefix");
            if (!params.isEmpty()) {
                log.warning("Ignored unknown attributes: " + params.keySet() + ", " + pi.getLocator());
            }
            if (uri == null || prefix == null) {
                throw new UiException("Both uri and prefix attribute are required, " + pi.getLocator());
            }
            Parser.noEL("prefix", prefix, (Item)pi);
            Parser.noEL("uri", uri, (Item)pi);
            pgdef.addTaglib(new Taglib(prefix, this.toAbsoluteURI(uri, false)));
        } else if ("evaluator".equals(target)) {
            Parser.parseEvaluatorDirective(pgdef, pi, params);
        } else if ("xel-method".equals(target)) {
            Parser.parseXelMethod(pgdef, pi, params);
        } else if ("link".equals(target) || "meta".equals(target) || "script".equals(target) || "style".equals(target)) {
            pgdef.addHeaderInfo(new HeaderInfo(target, params, ConditionImpl.getInstance((String)params.remove("if"), (String)params.remove("unless"))));
        } else if ("header".equals(target)) {
            pgdef.addResponseHeaderInfo(new ResponseHeaderInfo((String)params.remove("name"), (String)params.remove("value"), (String)params.remove("append"), ConditionImpl.getInstance((String)params.remove("if"), (String)params.remove("unless"))));
        } else if ("root-attributes".equals(target)) {
            for (Map.Entry me : pi.parseData().entrySet()) {
                pgdef.setRootAttribute((String)me.getKey(), (String)me.getValue());
            }
        } else if ("forward".equals(target)) {
            String uri = (String)params.remove("uri");
            String ifc = (String)params.remove("if");
            String unless = (String)params.remove("unless");
            if (!params.isEmpty()) {
                log.warning("Ignored unknown attributes: " + params.keySet() + ", " + pi.getLocator());
            }
            Parser.noEmpty("uri", uri, (Item)pi);
            pgdef.addForwardInfo(new ForwardInfo(uri, ConditionImpl.getInstance(ifc, unless)));
        } else {
            if ("import".equals(target)) {
                throw new UiException("The import directive can be used only at the top level, " + pi.getLocator());
            }
            log.warning("Unknown processing instruction: " + target + ", " + pi.getLocator());
        }
    }

    private void parseInitDirective(PageDefinition pgdef, ProcessingInstruction pi, Map<String, String> params) throws Exception {
        String clsnm = params.remove("class");
        String zsrc = params.remove("zscript");
        LinkedHashMap<String, String> args = new LinkedHashMap<String, String>(params);
        if (clsnm == null) {
            URL url;
            if (zsrc == null) {
                throw new UiException("Either the class or zscript attribute must be specified, " + pi.getLocator());
            }
            this.checkZScriptEnabled(pi.getLocator());
            ZScript zs = null;
            String zslang = pgdef.getZScriptLanguage();
            if (zsrc.indexOf("${") < 0 && (url = this.getLocator().getResource(zsrc)) != null) {
                zs = new ZScript(zslang, url);
            }
            if (zs == null) {
                zs = new ZScript(pgdef.getEvaluatorRef(), zslang, zsrc, this.getLocator());
            }
            pgdef.addInitiatorInfo(new InitiatorInfo(new ZScriptInitiator(zs), args));
        } else {
            if (zsrc != null) {
                throw new UiException("You cannot specify both class and zscript, " + pi.getLocator());
            }
            pgdef.addInitiatorInfo(new InitiatorInfo(clsnm, args));
        }
    }

    private void checkZScriptEnabled(Element el) {
        this.checkZScriptEnabled(el.getLocator());
    }

    private void checkZScriptEnabled(org.zkoss.xml.Locator loc) {
        if (!this._wapp.getConfiguration().isZScriptEnabled()) {
            throw new UiException("zscript is not allowed since <disable-zscript> is configured, " + loc);
        }
    }

    private static void parsePageDirective(PageDefinition pgdef, ProcessingInstruction pi, Map<String, String> params) throws Exception {
        for (Map.Entry me : pi.parseData().entrySet()) {
            String nm = (String)me.getKey();
            String val = (String)me.getValue();
            if ("language".equals(nm)) {
                if (pi.getParent() instanceof Document) continue;
                log.warning("Ignored language attribute since the page directive is not at the top level, " + pi.getLocator());
                continue;
            }
            if ("title".equals(nm)) {
                pgdef.setTitle(val);
                continue;
            }
            if ("style".equals(nm)) {
                pgdef.setStyle(val);
                continue;
            }
            if ("id".equals(nm)) {
                pgdef.setId(val);
                continue;
            }
            if ("widgetClass".equals(nm)) {
                pgdef.setWidgetClass(val);
                continue;
            }
            if ("zscriptLanguage".equals(nm) || "zscript-language".equals(nm)) {
                Parser.noELnorEmpty("zscriptLanguage", val, (Item)pi);
                pgdef.setZScriptLanguage(val);
                continue;
            }
            if ("cacheable".equals(nm)) {
                Parser.noELnorEmpty("cacheable", val, (Item)pi);
                pgdef.setCacheable("true".equals(val));
                continue;
            }
            if ("automaticTimeout".equals(nm)) {
                Parser.noELnorEmpty("automaticTimeout", val, (Item)pi);
                pgdef.setAutomaticTimeout("true".equals(val));
                continue;
            }
            if ("contentType".equals(nm)) {
                Parser.noEmpty("contentType", val, (Item)pi);
                pgdef.setContentType(val);
                continue;
            }
            if ("docType".equals(nm)) {
                pgdef.setDocType(Parser.isEmpty(val) ? "" : "<!DOCTYPE " + val + '>');
                continue;
            }
            if ("xml".equals(nm)) {
                Parser.noEmpty("xml", val, (Item)pi);
                pgdef.setFirstLine("<?xml " + val + "?>");
                continue;
            }
            if ("complete".equals(nm)) {
                pgdef.setComplete("true".equals(val));
                continue;
            }
            log.warning("Ignored unknown attribute: " + nm + ", " + pi.getLocator());
        }
    }

    private void parseComponentDirective(PageDefinition pgdef, ProcessingInstruction pi, Map<String, String> params) throws Exception {
        ComponentDefinition compdef;
        LanguageDefinition langdef;
        String name = params.remove("name");
        Parser.noELnorEmpty("name", name, (Item)pi);
        String macroURI = params.remove("macroURI");
        if (macroURI == null) {
            macroURI = params.remove("macro-uri");
        }
        String extds = params.remove("extends");
        String clsnm = params.remove("class");
        String lang = params.remove("language");
        LanguageDefinition languageDefinition = langdef = lang != null ? LanguageDefinition.lookup(lang) : pgdef.getLanguageDefinition();
        if (macroURI != null) {
            String inline = params.remove("inline");
            Parser.noEL("inline", inline, (Item)pi);
            Parser.noEL("macroURI", macroURI, (Item)pi);
            boolean bInline = "true".equals(inline);
            compdef = langdef.getMacroDefinition(name, this.toAbsoluteURI(macroURI, false), bInline, pgdef);
            if (!Parser.isEmpty(clsnm)) {
                if (bInline) {
                    throw new UiException("class not allowed with inline macros, " + pi.getLocator());
                }
                Parser.noEL("class", clsnm, (Item)pi);
                compdef.setImplementationClass(clsnm);
            }
        } else {
            ComponentDefinition ref = null;
            if (extds != null) {
                Parser.noEL("extends", extds, (Item)pi);
                ref = langdef.getComponentDefinition(extds);
            } else {
                try {
                    Class cls = pgdef.getImportedClassResolver().resolveClass(clsnm);
                    if (lang != null) {
                        ref = langdef.getComponentDefinition(cls);
                    } else {
                        ref = pgdef.getComponentDefinition(cls, true);
                        if (ref == null) {
                            ref = Components.getDefinitionByDeviceType(langdef.getDeviceType(), cls);
                        }
                    }
                }
                catch (Throwable ex) {
                    // empty catch block
                }
            }
            if (ref != null) {
                if (ref.isMacro()) {
                    throw new UiException("Unable to extend from a macro component, " + pi.getLocator());
                }
                compdef = ref.clone(null, name);
                if (!Parser.isEmpty(clsnm)) {
                    Parser.noEL("class", clsnm, (Item)pi);
                    compdef.setImplementationClass(clsnm);
                }
            } else {
                Parser.noELnorEmpty("class", clsnm, (Item)pi);
                ComponentDefinitionImpl cdi = new ComponentDefinitionImpl(null, pgdef, name, (Class<? extends Component>)null);
                cdi.setCurrentDirectory(this.getLocator().getDirectory());
                compdef = cdi;
                compdef.setImplementationClass(clsnm);
            }
        }
        String wgtnm = params.remove("widgetClass");
        if (wgtnm == null) {
            wgtnm = params.remove("widget-class");
        }
        if (wgtnm != null) {
            compdef.setDefaultWidgetClass(wgtnm);
        }
        pgdef.addComponentDefinition(compdef);
        String o = params.remove("moldURI");
        if (o == null) {
            o = params.remove("mold-uri");
        }
        if (o != null) {
            throw new UnsupportedOperationException("moldURI not supported in 5.0. Use <?script?> or lang-addon.xml instead, " + pi.getLocator());
        }
        o = params.remove("cssURI");
        if (o != null) {
            throw new UnsupportedOperationException("cssURI not supported in 5.0. Use <?link?> or lang-addon.xml instead, " + pi.getLocator());
        }
        compdef.setApply(params.remove("apply"));
        for (Map.Entry<String, String> me : params.entrySet()) {
            compdef.addProperty(me.getKey(), me.getValue());
        }
    }

    private static void parseEvaluatorDirective(PageDefinition pgdef, ProcessingInstruction pi, Map<String, String> params) throws Exception {
        String clsnm = params.remove("class");
        if (clsnm != null && clsnm.length() > 0) {
            Parser.noELnorEmpty("class", clsnm, (Item)pi);
            pgdef.setExpressionFactoryClass(pgdef.getImportedClassResolver().resolveClass(clsnm));
        } else {
            String nm = params.remove("name");
            if (nm != null) {
                pgdef.setExpressionFactoryClass(Evaluators.getEvaluatorClass((String)nm));
            }
        }
        String imports = params.remove("import");
        if (imports != null && imports.length() > 0) {
            Collection ims = CollectionsX.parse(null, (String)imports, (char)',', (boolean)false);
            for (String im : ims) {
                int k = im.indexOf(61);
                String nm = k > 0 ? im.substring(0, k).trim() : null;
                String cn = (k >= 0 ? im.substring(k + 1) : im).trim();
                if (cn.length() == 0) continue;
                if (nm == null || nm.length() == 0) {
                    int j = cn.lastIndexOf(46);
                    nm = j >= 0 ? cn.substring(j + 1) : cn;
                }
                pgdef.addExpressionImport(nm, Classes.forNameByThread((String)cn));
            }
        }
    }

    private static void parseXelMethod(PageDefinition pgdef, ProcessingInstruction pi, Map<String, String> params) throws Exception {
        Method mtd;
        String prefix = params.remove("prefix");
        Parser.noELnorEmpty("prefix", prefix, (Item)pi);
        String nm = params.remove("name");
        Parser.noELnorEmpty("name", nm, (Item)pi);
        String clsnm = params.remove("class");
        Parser.noELnorEmpty("class", clsnm, (Item)pi);
        String sig = params.remove("signature");
        Parser.noELnorEmpty("signature", sig, (Item)pi);
        try {
            ClassResolver clsresolver = pgdef.getImportedClassResolver();
            Class cls = clsresolver.resolveClass(clsnm);
            mtd = Classes.getMethodBySignature((Class)cls, (String)sig, null, (ClassResolver)clsresolver);
        }
        catch (ClassNotFoundException ex) {
            throw new UiException("Class not found: " + clsnm + ", " + pi.getLocator());
        }
        catch (Exception ex) {
            throw new UiException("Method not found: " + sig + " in " + clsnm + ", " + pi.getLocator());
        }
        if ((mtd.getModifiers() & 8) == 0) {
            throw new UiException("Not a static method: " + mtd + ", " + pi.getLocator());
        }
        pgdef.addXelMethod(prefix, nm, (Function)new MethodFunction(mtd));
    }

    private static void noELnorEmpty(String nm, String val, Item item) throws UiException {
        if (Parser.isEmpty(val)) {
            throw new UiException(nm + " cannot be empty, " + item.getLocator());
        }
        Parser.noEL(nm, val, item);
    }

    private static void noEL(String nm, String val, Item item) throws UiException {
        if (val != null && val.indexOf("${") >= 0) {
            throw new UiException(nm + " does not support EL expressions, " + item.getLocator());
        }
    }

    private static void noEmpty(String nm, String val, Item item) throws UiException {
        if (val != null && val.length() == 0) {
            throw new UiException(nm + " cannot be empty, " + item.getLocator());
        }
    }

    private String toAbsoluteURI(String uri, boolean allowEL) {
        String dir;
        char cc;
        if (!(uri == null || uri.length() <= 0 || (cc = uri.charAt(0)) == '/' || cc == '~' || allowEL && uri.indexOf("${") >= 0 || Servlets.isUniversalURL((String)uri) || (dir = this.getLocator().getDirectory()) == null || dir.length() <= 0)) {
            return dir.charAt(dir.length() - 1) == '/' ? dir + uri : dir + '/' + uri;
        }
        return uri;
    }

    private void parseItems(PageDefinition pgdef, NodeInfo parent, Collection items, AnnotationHelper annHelper, boolean bNativeContent) throws Exception {
        String trimLabel;
        LanguageDefinition parentlang = Parser.getLanguageDefinition(parent);
        if (parentlang == null) {
            parentlang = pgdef.getLanguageDefinition();
        }
        boolean bZkSwitch = Parser.isZkSwitch(parent);
        ComponentInfo pi = null;
        String textAs = null;
        StringBuffer textAsBuffer = null;
        for (NodeInfo p = parent; p != null; p = p.getParent()) {
            if (!(p instanceof ComponentInfo)) continue;
            pi = (ComponentInfo)p;
            textAs = pi.getTextAs();
            if (textAs == null || pi != parent) break;
            textAsBuffer = new StringBuffer();
            break;
        }
        for (Object o : items) {
            if (o instanceof Element) {
                this.parseItem(pgdef, parent, (Element)o, annHelper, bNativeContent);
                continue;
            }
            if (o instanceof ProcessingInstruction) {
                this.parse(pgdef, (ProcessingInstruction)o);
                continue;
            }
            if (!(o instanceof Text) && !(o instanceof CData)) continue;
            String label = ((Item)o).getText();
            String trimLabel2 = label.trim();
            if (label.length() == 0) continue;
            if (bZkSwitch) {
                if (trimLabel2.length() == 0) continue;
                throw new UiException("Only <zk> can be used in <zk switch>, " + ((Item)o).getLocator());
            }
            if (trimLabel2.length() == 0 && pi != null && !pi.isBlankPreserved() && !(pi instanceof NativeInfo)) continue;
            if (pi instanceof NativeInfo) {
                new TextInfo(parent, label);
                continue;
            }
            if (textAs != null) {
                if (trimLabel2.length() == 0) continue;
                if (textAsBuffer != null) {
                    textAsBuffer.append(label);
                    continue;
                }
                if (parent instanceof TemplateInfo) continue;
                throw new UnsupportedOperationException("Not allowed in text-as, " + ((Item)o).getParent().getLocator());
            }
            if (Parser.isTrimLabel() && !parentlang.isRawLabel()) {
                if (trimLabel2.length() == 0) continue;
                label = trimLabel2;
            }
            ComponentInfo labelInfo = parentlang.newLabelInfo(parent, label);
            if (trimLabel2.length() != 0) continue;
            labelInfo.setReplaceableText(label);
        }
        if (textAsBuffer != null && (trimLabel = textAsBuffer.toString().trim()).length() != 0) {
            pi.addProperty(textAs, trimLabel, null);
        }
    }

    private static boolean isTrimLabel() {
        if (_trimLabel == null) {
            String s = Library.getProperty((String)"org.zkoss.zk.ui.parser.trimLabel");
            _trimLabel = s != null && s.length() > 0;
        }
        return _trimLabel;
    }

    private static final LanguageDefinition getLanguageDefinition(NodeInfo node) {
        while (node != null) {
            if (node instanceof ComponentInfo) {
                LanguageDefinition langdef = ((ComponentInfo)node).getLanguageDefinition();
                if (langdef != null) {
                    return langdef;
                }
            } else if (node instanceof PageDefinition) {
                return ((PageDefinition)node).getLanguageDefinition();
            }
            node = node.getParent();
        }
        return null;
    }

    private void parseItem(PageDefinition pgdef, NodeInfo parent, Element el, AnnotationHelper annHelper, boolean bNativeContent) throws Exception {
        String nm = el.getLocalName();
        Namespace ns = el.getNamespace();
        String pref = ns != null ? ns.getPrefix() : "";
        String uri = ns != null ? ns.getURI() : "";
        LanguageDefinition langdef = pgdef.getLanguageDefinition();
        if ("zscript".equals(nm) && Parser.isZkElement(langdef, nm, pref, uri)) {
            this.checkZScriptEnabled(el);
            this.parseZScript(parent, el, annHelper);
        } else if ("attribute".equals(nm) && Parser.isZkElement(langdef, nm, pref, uri, bNativeContent)) {
            if (!(parent instanceof ComponentInfo)) {
                throw new UiException("<attribute> cannot be the root element, " + el.getLocator());
            }
            this.parseAttribute(pgdef, (ComponentInfo)parent, el, annHelper);
        } else if ("custom-attributes".equals(nm) && Parser.isZkElement(langdef, nm, pref, uri, bNativeContent)) {
            Parser.parseCustomAttributes(langdef, parent, el, annHelper);
        } else if ("variables".equals(nm) && Parser.isZkElement(langdef, nm, pref, uri, bNativeContent)) {
            Parser.parseVariables(langdef, parent, el, annHelper);
        } else if ("http://www.zkoss.org/2005/zk/annotation".equals(uri) || "annotation".equals(uri)) {
            Parser.parseAnnotation(el, annHelper);
        } else if ("template".equals(nm) && Parser.isZkElement(langdef, nm, pref, uri, bNativeContent)) {
            this.parseItems(pgdef, Parser.parseTemplate(parent, el, annHelper), el.getChildren(), annHelper, bNativeContent);
        } else if ("zk".equals(nm) && Parser.isZkElement(langdef, nm, pref, uri)) {
            this.parseItems(pgdef, Parser.parseZk(parent, el, annHelper), el.getChildren(), annHelper, bNativeContent);
        } else {
            ComponentInfo compInfo;
            boolean bNative;
            if (Parser.isZkSwitch(parent)) {
                throw new UiException("Only <zk> can be used in <zk switch>, " + el.getLocator());
            }
            boolean prefRequired = uri.startsWith("native:");
            boolean bl = bNative = bNativeContent || prefRequired || "http://www.zkoss.org/2005/zk/native".equals(uri) || "native".equals(uri);
            if (!bNative && langdef.isNative() && !langdef.getNamespace().equals(uri)) {
                prefRequired = "".equals(pref) && "".equals(uri) || !LanguageDefinition.exists(uri);
                bNative = prefRequired;
            }
            if (bNative) {
                if (annHelper.clear()) {
                    log.warning("Annotations are ignored since native doesn't support them, " + el.getLocator());
                }
                NativeInfo ni = new NativeInfo(parent, langdef.getNativeDefinition(), prefRequired && pref.length() > 0 ? pref + ":" + nm : nm);
                compInfo = ni;
                Collection dns = el.getDeclaredNamespaces();
                if (!dns.isEmpty()) {
                    Parser.addDeclaredNamespace(ni, dns, langdef);
                }
            } else {
                ComponentDefinition compdef;
                boolean defaultNS = Parser.isDefaultNS(langdef, pref, uri);
                LanguageDefinition complangdef = defaultNS ? langdef : LanguageDefinition.lookup(uri);
                ComponentDefinition componentDefinition = compdef = defaultNS ? pgdef.getComponentDefinitionMap().get(nm) : null;
                if (compdef != null) {
                    compInfo = new ComponentInfo(parent, compdef);
                } else if (complangdef.hasComponentDefinition(nm)) {
                    compdef = complangdef.getComponentDefinition(nm);
                    compInfo = new ComponentInfo(parent, compdef);
                    langdef = complangdef;
                } else {
                    compdef = complangdef.getDynamicTagDefinition();
                    if (compdef == null) {
                        throw new DefinitionNotFoundException("Component definition not found: " + nm + " in " + complangdef + ", " + el.getLocator());
                    }
                    compInfo = new ComponentInfo(parent, compdef, nm);
                    langdef = complangdef;
                }
                String use = el.getAttributeValue("use");
                if (use != null && (use = use.trim()).length() != 0) {
                    compInfo.setImplementation(use);
                }
            }
            String ifc = null;
            String unless = null;
            String forEach = null;
            String forEachBegin = null;
            String forEachEnd = null;
            AnnotationHelper attrAnnHelper = null;
            for (Attribute attr : el.getAttributeItems()) {
                String attvaltrim;
                String attPref;
                Namespace attrns = attr.getNamespace();
                String attURI = attrns != null ? attrns.getURI() : "";
                String attnm = attr.getLocalName();
                String attval = attr.getValue();
                if ("http://www.zkoss.org/2005/zk/annotation".equals(attURI) || "annotation".equals(attURI)) {
                    String attvaltrim2;
                    if (attrAnnHelper == null) {
                        attrAnnHelper = new AnnotationHelper();
                    }
                    if ((attvaltrim2 = attval.trim()).startsWith("@")) {
                        Parser.applyAttrAnnot(attrAnnHelper, compInfo, attnm, attvaltrim2, true);
                        continue;
                    }
                    attrAnnHelper.addByRawValue(attnm, attvaltrim2);
                    continue;
                }
                if ("apply".equals(attnm) && Parser.isZkAttr(langdef, attrns)) {
                    compInfo.setApply(attval);
                    continue;
                }
                if ("forward".equals(attnm) && Parser.isZkAttr(langdef, attrns)) {
                    compInfo.setForward(attval);
                    continue;
                }
                if ("if".equals(attnm) && Parser.isZkAttr(langdef, attrns)) {
                    ifc = attval;
                    continue;
                }
                if ("unless".equals(attnm) && Parser.isZkAttr(langdef, attrns)) {
                    unless = attval;
                    continue;
                }
                if ("forEach".equals(attnm) && Parser.isZkAttr(langdef, attrns)) {
                    forEach = attval;
                    continue;
                }
                if ("forEachBegin".equals(attnm) && Parser.isZkAttr(langdef, attrns)) {
                    forEachBegin = attval;
                    continue;
                }
                if ("forEachEnd".equals(attnm) && Parser.isZkAttr(langdef, attrns)) {
                    forEachEnd = attval;
                    continue;
                }
                if ("fulfill".equals(attnm) && Parser.isZkAttr(langdef, attrns, bNativeContent)) {
                    compInfo.setFulfill(attval);
                    continue;
                }
                if ("use".equals(attnm) && Parser.isZkAttr(langdef, attrns, bNativeContent) || "xmlns".equals(attPref = attrns != null ? attrns.getPrefix() : "") || "xmlns".equals(attnm) && "".equals(attPref) || "http://www.w3.org/2001/XMLSchema-instance".equals(attURI)) continue;
                if (!bNativeContent && AnnotationHelper.isAnnotation(attvaltrim = attval.trim())) {
                    if (attrAnnHelper == null) {
                        attrAnnHelper = new AnnotationHelper();
                    }
                    Parser.applyAttrAnnot(attrAnnHelper, compInfo, attnm, attvaltrim, true);
                    continue;
                }
                this.addAttribute(compInfo, attrns, attnm, attval, null, attr.getLocator());
                if (attrAnnHelper == null) continue;
                attrAnnHelper.applyAnnotations(compInfo, attnm, true);
            }
            compInfo.setCondition(ConditionImpl.getInstance(ifc, unless));
            compInfo.setForEach(forEach, forEachBegin, forEachEnd);
            annHelper.applyAnnotations(compInfo, null, true);
            List items = el.getChildren();
            String textAs = null;
            if (!bNativeContent && !items.isEmpty() && (textAs = compInfo.getTextAs()) != null) {
                String xmlFound = null;
                String zkElem = null;
                boolean empty = true;
                Iterator it = items.iterator();
                while (true) {
                    if (zkElem != null && xmlFound != null) {
                        throw new UnsupportedOperationException("Unable to handle XML fragment, <" + xmlFound + ">, with <" + zkElem + ">. Please use CDATA instead, " + (it.hasNext() ? ((Item)it.next()).getLocator() : el.getLocator()));
                    }
                    if (!it.hasNext()) break;
                    Item o = (Item)it.next();
                    if (empty) {
                        boolean bl2 = empty = (o instanceof Text || o instanceof CData) && o.getText().trim().length() == 0;
                    }
                    if (!(o instanceof Element)) continue;
                    String n = ((Element)o).getName();
                    if ("attribute".equals(n) || "custom-attributes".equals(n) || "variables".equals(n) || "template".equals(n) || "zscript".equals(n)) {
                        zkElem = n;
                        textAs = null;
                        continue;
                    }
                    xmlFound = n;
                }
                if (empty) {
                    textAs = null;
                }
            }
            if (textAs != null) {
                this.parseAsProperty(pgdef, compInfo, textAs, items, annHelper, null);
            } else {
                this.parseItems(pgdef, compInfo, items, annHelper, bNativeContent);
            }
            if (compInfo instanceof NativeInfo && !compInfo.getChildren().isEmpty()) {
                Parser.optimizeNativeInfos((NativeInfo)compInfo);
            }
        }
    }

    private void parseAsProperty(PageDefinition pgdef, ComponentInfo compInfo, String name, Collection items, AnnotationHelper annHelper, ConditionImpl cond) throws Exception {
        NativeInfo nativeInfo = new NativeInfo(compInfo.getEvaluatorRef(), pgdef.getLanguageDefinition().getNativeDefinition(), "");
        this.parseItems(pgdef, nativeInfo, items, annHelper, true);
        compInfo.addProperty(name, nativeInfo, cond);
    }

    private static void applyAttrAnnot(AnnotationHelper attrAnnHelper, ComponentInfo compInfo, String nm, String val, boolean selfAllowed) {
        attrAnnHelper.addByCompoundValue(val.trim());
        attrAnnHelper.applyAnnotations(compInfo, (String)(selfAllowed && "self".equals(nm) ? null : nm), true);
    }

    private static void warnWrongZkAttr(Attribute attr) {
        log.warning("Attribute " + attr.getName() + " ignored in <zk>, " + attr.getLocator());
    }

    private static boolean isZkSwitch(NodeInfo nodeInfo) {
        return nodeInfo instanceof ZkInfo && ((ZkInfo)nodeInfo).withSwitch();
    }

    private void parseZScript(NodeInfo parent, Element el, AnnotationHelper annHelper) {
        String script;
        if (el.getAttributeItem("forEach") != null) {
            throw new UiException("forEach not applicable to <zscript>, " + el.getLocator());
        }
        if (annHelper.clear()) {
            log.warning("Annotations are ignored since <zscript> doesn't support them, " + el.getLocator());
        }
        String ifc = el.getAttributeValue("if");
        String unless = el.getAttributeValue("unless");
        String zsrc = el.getAttributeValue("src");
        boolean deferred = "true".equals(el.getAttributeValue("deferred"));
        String zslang = el.getAttributeValue("language");
        if (zslang == null) {
            zslang = parent.getPageDefinition().getZScriptLanguage();
        } else {
            Parser.noEmpty("language", zslang, (Item)el);
            Parser.noEL("language", zslang, (Item)el);
        }
        ConditionImpl cond = ConditionImpl.getInstance(ifc, unless);
        if (!Parser.isEmpty(zsrc)) {
            URL url;
            ZScriptInfo zs = null;
            if (zsrc.indexOf("${") < 0 && (url = this.getLocator().getResource(zsrc)) != null) {
                zs = new ZScriptInfo(parent, zslang, url, cond);
            }
            if (zs == null) {
                zs = new ZScriptInfo(parent, zslang, zsrc, this.getLocator(), cond);
            }
            if (deferred) {
                zs.setDeferred(true);
            }
        }
        if (!Parser.isEmpty((script = el.getText(false)).trim())) {
            int lno;
            org.zkoss.xml.Locator l = el.getLocator();
            int n = lno = l != null ? l.getLineNumber() : 0;
            if (lno > 1) {
                StringBuffer sb = new StringBuffer(lno);
                while (--lno > 0) {
                    sb.append('\n');
                }
                script = sb.toString() + script;
            }
            ZScriptInfo zs = new ZScriptInfo(parent, zslang, script, cond);
            if (deferred) {
                zs.setDeferred(true);
            }
        }
    }

    private void parseAttribute(PageDefinition pgdef, ComponentInfo parent, Element el, AnnotationHelper annHelper) throws Exception {
        Attribute attr;
        if (el.getAttributeItem("forEach") != null) {
            throw new UiException("forEach not applicable to attribute, " + el.getLocator());
        }
        String elFound = null;
        for (Object o : el.getChildren()) {
            if (!(o instanceof Element)) continue;
            elFound = ((Element)o).getName();
            break;
        }
        if ((attr = el.getAttributeItem(null, "name", 0)) == null) {
            throw new UiException("The name attribute required, " + el.getLocator());
        }
        String attnm = attr.getValue();
        Parser.noEmpty("name", attnm, (Item)el);
        ConditionImpl cond = ConditionImpl.getInstance(el.getAttributeValue("if"), el.getAttributeValue("unless"));
        if (elFound != null) {
            if (Events.isValid(attnm)) {
                throw new UiException("<" + elFound + "> not allowed in an event listener, " + el.getLocator());
            }
            this.parseAsProperty(pgdef, parent, attnm, el.getChildren(), annHelper, cond);
        } else {
            String trim = el.getAttributeValue("trim");
            Parser.noEL("trim", trim, (Item)el);
            String attval = el.getText(trim != null && "true".equals(trim));
            this.addAttribute(parent, attr.getNamespace(), attnm, attval, cond, el.getLocator());
        }
        annHelper.applyAnnotations(parent, attnm, true);
    }

    private static void parseCustomAttributes(LanguageDefinition langdef, NodeInfo parent, Element el, AnnotationHelper annHelper) throws Exception {
        if (parent instanceof PageDefinition) {
            throw new UiException("<custom-attributes> must be used under a component, " + el.getLocator());
        }
        if (annHelper.clear()) {
            log.warning("Annotations are ignored since <custom-attributes> doesn't support them, " + el.getLocator());
        }
        String ifc = null;
        String unless = null;
        String scope = null;
        String composite = null;
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        AnnotationHelper attrAnnHelper = null;
        for (Attribute attr : el.getAttributeItems()) {
            String attvaltrim;
            Namespace attrns = attr.getNamespace();
            String attnm = attr.getLocalName();
            String attval = attr.getValue();
            if ("if".equals(attnm) && Parser.isZkElementAttr(langdef, attrns)) {
                ifc = attval;
                continue;
            }
            if ("unless".equals(attnm) && Parser.isZkElementAttr(langdef, attrns)) {
                unless = attval;
                continue;
            }
            if ("scope".equals(attnm) && Parser.isZkElementAttr(langdef, attrns)) {
                scope = attval;
                continue;
            }
            if ("composite".equals(attnm) && Parser.isZkElementAttr(langdef, attrns)) {
                composite = attval;
                continue;
            }
            if ("forEach".equals(attnm) && Parser.isZkElementAttr(langdef, attrns)) {
                throw new UiException("forEach not applicable to <custom-attributes>, " + el.getLocator());
            }
            if (parent instanceof ComponentInfo && AnnotationHelper.isAnnotation(attvaltrim = attval.trim())) {
                if (attrAnnHelper == null) {
                    attrAnnHelper = new AnnotationHelper();
                }
                Parser.applyAttrAnnot(attrAnnHelper, (ComponentInfo)parent, attnm, attvaltrim, false);
                continue;
            }
            attrs.put(attnm, attval);
        }
        if (!attrs.isEmpty()) {
            new AttributesInfo(parent, attrs, scope, composite, ConditionImpl.getInstance(ifc, unless));
        }
    }

    private static void parseVariables(LanguageDefinition langdef, NodeInfo parent, Element el, AnnotationHelper annHelper) throws Exception {
        if (annHelper.clear()) {
            log.warning("Annotations are ignored since <variables> doesn't support them, " + el.getLocator());
        }
        String ifc = null;
        String unless = null;
        String composite = null;
        boolean local = false;
        LinkedHashMap<String, String> vars = new LinkedHashMap<String, String>();
        for (Attribute attr : el.getAttributeItems()) {
            Namespace attrns = attr.getNamespace();
            String attnm = attr.getLocalName();
            String attval = attr.getValue();
            if ("if".equals(attnm) && Parser.isZkElementAttr(langdef, attrns)) {
                ifc = attval;
                continue;
            }
            if ("unless".equals(attnm) && Parser.isZkElementAttr(langdef, attrns)) {
                unless = attval;
                continue;
            }
            if ("local".equals(attnm) && Parser.isZkElementAttr(langdef, attrns)) {
                local = "true".equals(attval);
                continue;
            }
            if ("composite".equals(attnm) && Parser.isZkElementAttr(langdef, attrns)) {
                composite = attval;
                continue;
            }
            if ("forEach".equals(attnm) && Parser.isZkElementAttr(langdef, attrns)) {
                throw new UiException("forEach not applicable to <variables>, " + el.getLocator());
            }
            vars.put(attnm, attval);
        }
        if (!vars.isEmpty()) {
            new VariablesInfo(parent, vars, local, composite, ConditionImpl.getInstance(ifc, unless));
        }
    }

    private static void parseAnnotation(Element el, AnnotationHelper annHelper) throws Exception {
        if (!el.getElements().isEmpty()) {
            throw new UiException("Child elements are not allowed for the annotations, " + el.getLocator());
        }
        LinkedHashMap<String, Object> attrs = new LinkedHashMap<String, Object>();
        for (Attribute attr : el.getAttributeItems()) {
            attrs.put(attr.getLocalName(), AnnotationHelper.parseAttributeValue(attr.getValue().trim()));
        }
        annHelper.add(el.getLocalName(), attrs);
    }

    private static TemplateInfo parseTemplate(NodeInfo parent, Element el, AnnotationHelper annHelper) throws Exception {
        if (annHelper.clear()) {
            log.warning("Annotations are ignored since <template> doesn't support them, " + el.getLocator());
        }
        if (el.getAttributeItem("forEach") != null) {
            log.warning("forEach is ignored since <template> doesn't support it, " + el.getLocator());
        }
        String ifc = null;
        String unless = null;
        String name = null;
        String src = null;
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        for (Attribute attr : el.getAttributeItems()) {
            String attPref;
            Namespace attrns = attr.getNamespace();
            String attURI = attrns != null ? attrns.getURI() : "";
            String attnm = attr.getLocalName();
            String attval = attr.getValue();
            if ("name".equals(attnm)) {
                name = attval;
                continue;
            }
            if ("src".equals(attnm)) {
                src = attval;
                continue;
            }
            if ("if".equals(attnm)) {
                ifc = attval;
                continue;
            }
            if ("unless".equals(attnm)) {
                unless = attval;
                continue;
            }
            String string = attPref = attrns != null ? attrns.getPrefix() : null;
            if ("xmlns".equals(attnm) || "xml".equals(attnm) || attURI.indexOf("w3.org") >= 0 || attPref != null && ("xmlns".equals(attPref) || "xml".equals(attPref))) continue;
            params.put(attnm, attval);
        }
        if (name == null) {
            throw new UiException("The name attribute required, " + el.getLocator());
        }
        return new TemplateInfo(parent, name, src, params, ConditionImpl.getInstance(ifc, unless));
    }

    private static ZkInfo parseZk(NodeInfo parent, Element el, AnnotationHelper annHelper) throws Exception {
        if (annHelper.clear()) {
            log.warning("Annotations are ignored since <zk> doesn't support them, " + el.getLocator());
        }
        ZkInfo zi = new ZkInfo(parent, null);
        String ifc = null;
        String unless = null;
        String forEach = null;
        String forEachBegin = null;
        String forEachEnd = null;
        for (Attribute attr : el.getAttributeItems()) {
            String attPref;
            Namespace attrns = attr.getNamespace();
            String attURI = attrns != null ? attrns.getURI() : "";
            String attnm = attr.getLocalName();
            String attval = attr.getValue();
            if ("if".equals(attnm) || "when".equals(attnm)) {
                ifc = attval;
                continue;
            }
            if ("unless".equals(attnm)) {
                unless = attval;
                continue;
            }
            if ("forEach".equals(attnm)) {
                forEach = attval;
                continue;
            }
            if ("forEachBegin".equals(attnm)) {
                forEachBegin = attval;
                continue;
            }
            if ("forEachEnd".equals(attnm)) {
                forEachEnd = attval;
                continue;
            }
            if ("switch".equals(attnm) || "choose".equals(attnm)) {
                if (Parser.isZkSwitch(parent)) {
                    throw new UiException("<zk " + attnm + "> cannot be used in <zk switch/choose>, " + el.getLocator());
                }
                zi.setSwitch(attval);
                continue;
            }
            if ("case".equals(attnm)) {
                if (!Parser.isZkSwitch(parent)) {
                    throw new UiException("<zk case> can be used only in <zk switch>, " + attr.getLocator());
                }
                zi.setCase(attval);
                continue;
            }
            String string = attPref = attrns != null ? attrns.getPrefix() : null;
            if ("xmlns".equals(attnm) || "xml".equals(attnm) || attURI.indexOf("w3.org") >= 0 || attPref != null && ("xmlns".equals(attPref) || "xml".equals(attPref))) continue;
            Parser.warnWrongZkAttr(attr);
        }
        zi.setCondition(ConditionImpl.getInstance(ifc, unless));
        zi.setForEach(forEach, forEachBegin, forEachEnd);
        return zi;
    }

    private static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    private static final boolean isDefaultNS(LanguageDefinition langdef, String pref, String uri) {
        return !langdef.isNative() && "".equals(pref) && "".equals(uri) || langdef.getNamespace().equals(uri);
    }

    private static final boolean isZkElement(LanguageDefinition langdef, String nm, String pref, String uri, boolean bNativeContent) {
        if (Parser.isDefaultNS(langdef, pref, uri)) {
            return !bNativeContent && !langdef.hasComponentDefinition(nm);
        }
        return "http://www.zkoss.org/2005/zk".equals(uri) || "zk".equals(uri);
    }

    private static final boolean isZkElement(LanguageDefinition langdef, String nm, String pref, String uri) {
        return Parser.isZkElement(langdef, nm, pref, uri, false);
    }

    private static final boolean isZkAttr(LanguageDefinition langdef, Namespace attrns, boolean bNativeContent) {
        if ((bNativeContent || langdef.isNative()) && attrns != null && "".equals(attrns.getPrefix())) {
            return false;
        }
        return Parser.isZkElementAttr(langdef, attrns);
    }

    private static final boolean isZkAttr(LanguageDefinition langdef, Namespace attrns) {
        return Parser.isZkAttr(langdef, attrns, false);
    }

    private static final boolean isZkElementAttr(LanguageDefinition langdef, Namespace attrns) {
        if (attrns == null || "".equals(attrns.getPrefix())) {
            return true;
        }
        String uri = attrns.getURI();
        return "http://www.zkoss.org/2005/zk".equals(uri) || "zk".equals(uri) || langdef.getNamespace().equals(uri);
    }

    private void addAttribute(ComponentInfo compInfo, Namespace attrns, String name, String value, ConditionImpl cond, org.zkoss.xml.Locator xl) throws Exception {
        if (Events.isValid(name)) {
            boolean bZkAttr;
            boolean bl = bZkAttr = attrns == null;
            if (!bZkAttr) {
                String uri = attrns.getURI();
                if ("http://www.zkoss.org/2005/zk/client".equals(uri) || "client".equals(uri)) {
                    compInfo.addWidgetListener(name, value, cond);
                    return;
                }
                if ("http://www.zkoss.org/2005/zk/client/attribute".equals(uri) || "client/attribute".equals(uri)) {
                    compInfo.addWidgetAttribute(name, value, cond);
                    return;
                }
                String pref = attrns.getPrefix();
                LanguageDefinition langdef = compInfo.getLanguageDefinition();
                if (langdef == null) {
                    bZkAttr = true;
                } else if (Parser.isDefaultNS(langdef, pref, uri)) {
                    bZkAttr = !langdef.isDynamicReservedAttributes("[event]");
                } else {
                    boolean bl2 = bZkAttr = "http://www.zkoss.org/2005/zk".equals(uri) || "zk".equals(uri);
                }
            }
            if (bZkAttr) {
                this.checkZScriptEnabled(xl);
                int lno = xl != null ? xl.getLineNumber() : 0;
                ZScript zscript = ZScript.parseContent(value, lno);
                if (zscript.getLanguage() == null) {
                    zscript.setLanguage(compInfo.getPageDefinition().getZScriptLanguage());
                }
                compInfo.addEventHandler(name, zscript, cond);
                return;
            }
        } else {
            String uri = attrns.getURI();
            if ("http://www.zkoss.org/2005/zk/client".equals(uri) || "client".equals(uri)) {
                if (name.length() == 0) {
                    throw new UiException("Client attribute name required, " + xl);
                }
                if ("use".equals(name)) {
                    if (cond != null) {
                        throw new UnsupportedOperationException("if and unless not allowed for w:use, " + xl);
                    }
                    compInfo.setWidgetClass(value);
                } else {
                    compInfo.addWidgetOverride(name, value, cond);
                }
                return;
            }
            if ("http://www.zkoss.org/2005/zk/client/attribute".equals(uri) || "client/attribute".equals(uri)) {
                compInfo.addWidgetAttribute(name, value, cond);
                return;
            }
        }
        compInfo.addProperty(name, value, cond);
    }

    private static void addDeclaredNamespace(NativeInfo nativeInfo, Collection<Namespace> namespaces, LanguageDefinition langdef) {
        for (Namespace ns : namespaces) {
            String uri = ns.getURI();
            boolean bNatPrefix = uri.startsWith("native:");
            if (!bNatPrefix && (!langdef.isNative() || "http://www.zkoss.org/2005/zk".equals(uri) || "zk".equals(uri) || "http://www.zkoss.org/2005/zk/annotation".equals(uri) || "annotation".equals(uri) || "http://www.zkoss.org/2005/zk/native".equals(uri) || "native".equals(uri) || langdef.getNamespace().equals(uri))) continue;
            nativeInfo.addDeclaredNamespace(new Namespace(ns.getPrefix(), bNatPrefix ? uri.substring("native:".length()) : uri));
        }
    }

    private static void optimizeNativeInfos(NativeInfo compInfo) {
        NativeInfo childInfo;
        Object o;
        Iterator it;
        int sz;
        Iterator it2 = compInfo.getChildren().iterator();
        while (it2.hasNext()) {
            NodeInfo o2 = (NodeInfo)it2.next();
            if (o2 instanceof NativeInfo) {
                NativeInfo childInfo2 = (NativeInfo)o2;
                if (!childInfo2.getChildren().isEmpty()) break;
                childInfo2.setParentDirectly(null);
            } else if (o2 instanceof ComponentInfo) break;
            compInfo.addPrologChild(o2);
            it2.remove();
        }
        if ((sz = compInfo.getChildren().size()) >= 0) {
            it = compInfo.getChildren().listIterator(sz);
            while (it.hasPrevious()) {
                o = it.previous();
                if (o instanceof NativeInfo) {
                    childInfo = (NativeInfo)o;
                    if (!childInfo.getChildren().isEmpty()) {
                        it.next();
                        break;
                    }
                    childInfo.setParentDirectly(null);
                    continue;
                }
                if (!(o instanceof ComponentInfo)) continue;
                it.next();
                break;
            }
            while (it.hasNext()) {
                o = (NodeInfo)it.next();
                compInfo.addEpilogChild((NodeInfo)o);
                it.remove();
            }
        }
        if (compInfo.getChildren().size() == 1 && compInfo.getSplitChild() == null && (o = (it = compInfo.getChildren().iterator()).next()) instanceof NativeInfo && !(childInfo = (NativeInfo)o).withForEach()) {
            childInfo.setParentDirectly(null);
            compInfo.setSplitChild(childInfo);
            it.remove();
            it = new ArrayList(childInfo.getChildren()).iterator();
            while (it.hasNext()) {
                compInfo.appendChild((NodeInfo)it.next());
            }
        }
    }
}

