/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.metainfo.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.zkoss.lang.Strings;
import org.zkoss.util.Maps;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.metainfo.ComponentInfo;
import org.zkoss.zk.ui.sys.ComponentCtrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationHelper {
    final List<AnnotInfo> _annots = new LinkedList<AnnotInfo>();

    public static boolean isAnnotation(String val) {
        int len = val.length();
        if (len >= 4 && (len = (val = val.trim()).length()) >= 4 && val.charAt(0) == '@') {
            if (val.charAt(1) == '{') {
                if (val.charAt(len - 1) == '}') {
                    return true;
                }
            } else if (val.charAt(len - 1) == ')' && val.indexOf(40, 1) > 0) {
                char cc = val.charAt(Strings.skipWhitespaces((CharSequence)val, (int)1));
                return cc >= 'A' && cc <= 'Z' || cc >= 'a' && cc <= 'z' || cc >= '0' && cc <= '9' || cc == '_' || cc == '$';
            }
        }
        return false;
    }

    public void add(String annotName, Map<String, Object> annotAttrs) {
        if (annotName == null || annotName.length() == 0) {
            throw new IllegalArgumentException("empty");
        }
        this._annots.add(new AnnotInfo(annotName, annotAttrs));
    }

    public void addByRawValue(String annotName, String rval) {
        this.addByRawValueInFormat1(annotName, rval);
    }

    public void addByCompoundValue(String cval) {
        int len = cval.length();
        if (cval.charAt(1) == '{' && cval.charAt(len - 1) == '}') {
            this.addInFormat1(cval.substring(2, len - 1));
            return;
        }
        int j = 0;
        while (j >= 0) {
            int k;
            if ((k = cval.indexOf(40, ++j)) < 0) {
                throw AnnotationHelper.wrongAnnotationException(cval, "( expected");
            }
            String annotName = cval.substring(j, k).trim();
            j = ++k;
            StringBuffer sb = new StringBuffer(len);
            char quot = '\u0000';
            while (true) {
                if (j >= len) {
                    throw AnnotationHelper.wrongAnnotationException(cval, ") expected");
                }
                char cc = cval.charAt(j);
                if (quot == '\u0000') {
                    if (cc == ')') break;
                    if (cc == '\'' || cc == '\"') {
                        quot = cc;
                    }
                } else if (cc == quot) {
                    quot = '\u0000';
                }
                sb.append(cc);
                if (cc == '\\' && j < len - 1) {
                    sb.append(cval.charAt(++j));
                }
                ++j;
            }
            this.addByRawValueInFormat2(annotName, sb.toString().trim());
            j = cval.indexOf(64, j);
        }
    }

    private void addByRawValueInFormat2(String annotName, String rval) {
        LinkedHashMap<String, Object> attrs = new LinkedHashMap<String, Object>(4);
        int len = rval.length();
        StringBuffer sb = new StringBuffer(len);
        String nm = null;
        char quot = '\u0000';
        int j = 0;
        while (true) {
            block19: {
                char cc;
                block23: {
                    block20: {
                        block22: {
                            block21: {
                                if (j >= len) {
                                    if (quot != '\u0000') {
                                        throw AnnotationHelper.wrongAnnotationException(rval, quot + " expected (not paired)");
                                    }
                                    String val = sb.toString().trim();
                                    if (nm == null && val.length() <= 0) break;
                                    attrs.put(nm, val);
                                    break;
                                }
                                cc = rval.charAt(j);
                                if (quot != '\u0000') break block20;
                                if (cc != ',') break block21;
                                String val = sb.toString().trim();
                                if (nm == null && val.length() == 0) {
                                    throw AnnotationHelper.wrongAnnotationException(rval, "nothing before comma (,)");
                                }
                                attrs.put(nm, val);
                                nm = null;
                                sb.setLength(0);
                                break block19;
                            }
                            if (cc != '=') break block22;
                            if (nm != null) {
                                throw AnnotationHelper.wrongAnnotationException(rval, "comman (,) missed between two equal sign (=)");
                            }
                            nm = sb.toString().trim();
                            sb.setLength(0);
                            break block19;
                        }
                        if (cc == '\'' || cc == '\"') {
                            quot = cc;
                        } else if (cc == '{' && (sb.length() == 0 || sb.toString().trim().length() == 0)) {
                            int k = ++j;
                            while (true) {
                                if (j >= len) {
                                    throw AnnotationHelper.wrongAnnotationException(rval, "} expected");
                                }
                                cc = rval.charAt(j);
                                if (quot == '\u0000') {
                                    if (cc == '}') {
                                        attrs.put(nm, AnnotationHelper.parseValueArray(rval.substring(k, j).trim()));
                                        j = Strings.skipWhitespaces((CharSequence)rval, (int)(j + 1));
                                        if (j < len && rval.charAt(j) != ',') {
                                            throw AnnotationHelper.wrongAnnotationException(rval, rval.charAt(j) + " unexpected");
                                        }
                                        nm = null;
                                        sb.setLength(0);
                                        break block19;
                                    }
                                    if (cc == '\'' || cc == '\"') {
                                        quot = cc;
                                    }
                                } else if (cc == quot) {
                                    quot = '\u0000';
                                }
                                if (cc == '\\' && j < len - 1) {
                                    ++j;
                                }
                                ++j;
                            }
                        }
                        break block23;
                    }
                    if (cc == quot) {
                        quot = '\u0000';
                    }
                }
                sb.append(cc);
                if (cc == '\\' && j < len - 1) {
                    sb.append(rval.charAt(++j));
                }
            }
            ++j;
        }
        this.add(annotName, attrs);
    }

    public static Object parseAttributeValue(String val) {
        int len = val.length();
        if (len >= 2 && val.charAt(0) == '{' && val.charAt(len - 1) == '}') {
            return AnnotationHelper.parseValueArray(val.substring(1, len - 1));
        }
        return val;
    }

    private static String[] parseValueArray(String rval) {
        ArrayList<String> attrs = new ArrayList<String>();
        int len = rval.length();
        char quot = '\u0000';
        StringBuffer sb = new StringBuffer(len);
        int j = 0;
        while (true) {
            block8: {
                char cc;
                block9: {
                    block6: {
                        block7: {
                            if (j >= len) {
                                if (quot != '\u0000') {
                                    throw AnnotationHelper.wrongAnnotationException(rval, quot + " expected (not paired)");
                                }
                                String val = sb.toString().trim();
                                if (val.length() <= 0) break;
                                attrs.add(val);
                                break;
                            }
                            cc = rval.charAt(j);
                            if (quot != '\u0000') break block6;
                            if (cc != ',') break block7;
                            attrs.add(sb.toString().trim());
                            sb.setLength(0);
                            break block8;
                        }
                        if (cc == '\'' || cc == '\"') {
                            quot = cc;
                        }
                        break block9;
                    }
                    if (cc == quot) {
                        quot = '\u0000';
                    }
                }
                sb.append(cc);
                if (cc == '\\' && j < len - 1) {
                    sb.append(rval.charAt(++j));
                }
            }
            ++j;
        }
        return attrs.toArray(new String[attrs.size()]);
    }

    private static UiException wrongAnnotationException(String cval, String reason) {
        return new UiException("Illegal annotation, " + reason + ": " + cval);
    }

    private void addInFormat1(String cval) {
        char[] seps1 = new char[]{'(', ' '};
        char[] seps2 = new char[]{')'};
        int j = 0;
        int len = cval.length();
        while (j < len) {
            int k = Strings.nextSeparator((String)cval, (int)(j = Strings.skipWhitespaces((CharSequence)cval, (int)j)), (char[])seps1, (boolean)true, (boolean)true, (boolean)false);
            if (k < len && cval.charAt(k) == '(') {
                String rv;
                String nm = cval.substring(j, k).trim();
                if (nm.length() == 0) {
                    nm = "default";
                }
                if ((rv = ((k = Strings.nextSeparator((String)cval, (int)(j = k + 1), (char[])seps2, (boolean)true, (boolean)true, (boolean)false)) < len ? cval.substring(j, k) : cval.substring(j)).trim()).length() > 0) {
                    this.addByRawValueInFormat1(nm, rv);
                } else {
                    this.add(nm, null);
                }
            } else {
                String rv = (k < len ? cval.substring(j, k) : cval.substring(j)).trim();
                if (rv.length() > 0) {
                    this.addByRawValueInFormat1("default", rv);
                }
            }
            j = k + 1;
        }
    }

    private void addByRawValueInFormat1(String annotName, String rval) {
        Map attrs = Maps.parse(null, (String)rval, (char)',', (char)'\'', (boolean)true);
        this.add(annotName, attrs);
    }

    public void applyAnnotations(ComponentInfo compInfo, String propName, boolean clear) {
        for (AnnotInfo info : this._annots) {
            if (propName != null) {
                compInfo.addAnnotation(propName, info.name, info.attrs);
                continue;
            }
            compInfo.addAnnotation(info.name, info.attrs);
        }
        if (clear) {
            this._annots.clear();
        }
    }

    public void applyAnnotations(Component comp, String propName, boolean clear) {
        for (AnnotInfo info : this._annots) {
            ComponentCtrl ctrl = (ComponentCtrl)((Object)comp);
            if (propName != null) {
                ctrl.addAnnotation(propName, info.name, info.attrs);
                continue;
            }
            ctrl.addAnnotation(info.name, info.attrs);
        }
        if (clear) {
            this._annots.clear();
        }
    }

    public boolean clear() {
        if (!this._annots.isEmpty()) {
            this._annots.clear();
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AnnotInfo {
        private final String name;
        private final Map<String, Object> attrs;

        private AnnotInfo(String name, Map<String, Object> attrs) {
            this.name = name;
            this.attrs = attrs;
        }
    }
}

