/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.ui.select.impl;

import java.util.ArrayList;
import org.zkoss.zk.ui.select.impl.ParseException;
import org.zkoss.zk.ui.select.impl.SimpleSelectorSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Selector
extends ArrayList<SimpleSelectorSequence> {
    private static final long serialVersionUID = -9125226126564264333L;
    private final int _selectorIndex;

    public Selector(int selectorIndex) {
        this._selectorIndex = selectorIndex;
    }

    public void attachCombinator(Combinator combinator) {
        if (this.isEmpty()) {
            throw new ParseException("Cannot have combinator prior to the first sequence of simple selectors.");
        }
        ((SimpleSelectorSequence)this.get(this.size() - 1)).setCombinator(combinator);
    }

    public int getSelectorIndex() {
        return this._selectorIndex;
    }

    public Combinator getCombinator(int index) {
        return ((SimpleSelectorSequence)this.get(index)).getCombinator();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            SimpleSelectorSequence seq = (SimpleSelectorSequence)this.get(i);
            sb.append(seq);
            if (i >= size - 1) continue;
            sb.append((Object)seq.getCombinator());
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Combinator {
        DESCENDANT(" "),
        CHILD(" > "),
        ADJACENT_SIBLING(" + "),
        GENERAL_SIBLING(" ~ ");

        private final String _str;

        private Combinator(String str) {
            this._str = str;
        }

        public String toString() {
            return this._str;
        }
    }
}

