/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zk.xel.impl;

import java.util.Collections;
import org.zkoss.util.resource.Labels;
import org.zkoss.xel.VariableResolver;
import org.zkoss.xel.VariableResolverX;
import org.zkoss.xel.XelContext;
import org.zkoss.xel.XelException;
import org.zkoss.xel.util.Evaluators;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.sys.ExecutionCtrl;

public class ExecutionResolver
implements VariableResolverX {
    private final VariableResolver _parent;
    private final Execution _exec;
    private Object _self;

    public ExecutionResolver(Execution exec, VariableResolver parent) {
        if (exec == null) {
            throw new NullPointerException();
        }
        this._exec = exec;
        this._parent = parent;
    }

    public void setSelf(Object self) {
        this._self = self;
    }

    public Object getSelf() {
        return this._self;
    }

    public Object resolveVariable(String name) throws XelException {
        return this.resolveVariable(null, null, name);
    }

    public Object resolveVariable(XelContext ctx, Object base, Object onm) {
        Object o;
        if (base != null) {
            Object o2 = ((ExecutionCtrl)((Object)this._exec)).getExtraXelVariable(ctx, base, onm);
            if (o2 != null) {
                return o2;
            }
            Page page = ((ExecutionCtrl)((Object)this._exec)).getCurrentPage();
            return page != null ? page.getXelVariable(ctx, base, onm, true) : null;
        }
        if (onm == null) {
            return null;
        }
        String name = onm.toString();
        if (name == null || name.length() == 0) {
            return null;
        }
        if ("arg".equals(name)) {
            return this._exec.getArg();
        }
        if ("componentScope".equals(name)) {
            if (this._self instanceof Component) {
                return ((Component)this._self).getAttributes(0);
            }
            return Collections.EMPTY_MAP;
        }
        if ("desktopScope".equals(name)) {
            return this._exec.getDesktop().getAttributes();
        }
        if ("desktop".equals(name)) {
            return this._exec.getDesktop();
        }
        if ("execution".equals(name)) {
            return this._exec;
        }
        if ("pageScope".equals(name)) {
            if (this._self instanceof Component) {
                return ((Component)this._self).getAttributes(2);
            }
            if (this._self instanceof Page) {
                return ((Page)this._self).getAttributes();
            }
            Page page = ((ExecutionCtrl)((Object)this._exec)).getCurrentPage();
            return page != null ? page.getAttributes() : Collections.EMPTY_MAP;
        }
        if ("page".equals(name)) {
            if (this._self instanceof Component) {
                return ExecutionResolver.getPage((Component)this._self);
            }
            if (this._self instanceof Page) {
                return (Page)this._self;
            }
            return ((ExecutionCtrl)((Object)this._exec)).getCurrentPage();
        }
        if ("requestScope".equals(name)) {
            return this._exec.getAttributes();
        }
        if ("self".equals(name)) {
            return this._self;
        }
        if ("sessionScope".equals(name)) {
            return this._exec.getDesktop().getSession().getAttributes();
        }
        if ("session".equals(name)) {
            return this._exec.getDesktop().getSession();
        }
        if ("spaceOwner".equals(name)) {
            if (this._self instanceof Component) {
                return ((Component)this._self).getSpaceOwner();
            }
            if (this._self instanceof Page) {
                return (Page)this._self;
            }
            return null;
        }
        if ("spaceScope".equals(name)) {
            if (this._self instanceof Component) {
                return ((Component)this._self).getAttributes(1);
            }
            if (this._self instanceof Page) {
                return ((Page)this._self).getAttributes();
            }
            return Collections.EMPTY_MAP;
        }
        if ("param".equals(name) || "paramValues".equals(name)) {
            return Evaluators.resolveVariable((VariableResolver)this._parent, (String)name);
        }
        if (this._self instanceof Component) {
            Object o3;
            Component comp = (Component)this._self;
            Page page = ExecutionResolver.getPage(comp);
            if (page != null && (o3 = page.getZScriptVariable(comp, name)) != null) {
                return o3;
            }
            o3 = ((ExecutionCtrl)((Object)this._exec)).getExtraXelVariable(name);
            if (o3 != null) {
                return o3;
            }
            o3 = this._exec.getAttribute(name);
            if (o3 != null) {
                return o3;
            }
            o3 = comp.getAttributeOrFellow(name, true);
            if (o3 != null) {
                return o3;
            }
            if (page != null && (o3 = page.getXelVariable(ctx, null, name, true)) != null) {
                return o3;
            }
        } else {
            Page page = this._self instanceof Page ? (Page)this._self : ((ExecutionCtrl)((Object)this._exec)).getCurrentPage();
            if (page != null) {
                Object o4 = page.getZScriptVariable(name);
                if (o4 != null) {
                    return o4;
                }
                o4 = ((ExecutionCtrl)((Object)this._exec)).getExtraXelVariable(name);
                if (o4 != null) {
                    return o4;
                }
                o4 = this._exec.getAttribute(name);
                if (o4 != null) {
                    return o4;
                }
                o4 = page.getAttributeOrFellow(name, true);
                if (o4 != null) {
                    return o4;
                }
                o4 = page.getXelVariable(ctx, null, name, true);
                if (o4 != null) {
                    return o4;
                }
            } else {
                Object o5 = this._exec.getAttribute(name, true);
                if (o5 != null) {
                    return o5;
                }
            }
        }
        if ((o = Evaluators.resolveVariable((VariableResolver)this._parent, (String)name)) != null) {
            return o;
        }
        if ("labels".equals(name)) {
            return Labels.getSegmentedLabels();
        }
        return null;
    }

    private static Page getPage(Component comp) {
        Page page = comp.getPage();
        if (page != null) {
            return page;
        }
        Execution exec = Executions.getCurrent();
        return exec != null ? ((ExecutionCtrl)((Object)exec)).getCurrentPage() : null;
    }

    public String toString() {
        return "[ExecutionResolver: " + this._self + ']';
    }
}

