/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkplus.databind;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.metainfo.Annotation;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zkplus.databind.DataBinder;

public class AnnotateDataBinder
extends DataBinder {
    private static final long serialVersionUID = 200808191510L;

    public AnnotateDataBinder() {
    }

    public AnnotateDataBinder(Desktop desktop) {
        this.init(desktop, true);
    }

    public AnnotateDataBinder(Page page) {
        this.init(page, true);
    }

    public AnnotateDataBinder(Component comp) {
        this.init(comp, true);
    }

    public AnnotateDataBinder(Component[] comps) {
        this.init(comps, true);
    }

    public AnnotateDataBinder(Desktop desktop, boolean defaultConfig) {
        this.init(desktop, defaultConfig);
    }

    public AnnotateDataBinder(Page page, boolean defaultConfig) {
        this.init(page, defaultConfig);
    }

    public AnnotateDataBinder(Component[] comps, boolean defaultConfig) {
        this.init(comps, defaultConfig);
    }

    public AnnotateDataBinder(Component comp, boolean defaultConfig) {
        this.init(comp, defaultConfig);
    }

    public void init(Desktop desktop, boolean defaultConfig) {
        this.setDefaultConfig(defaultConfig);
        Iterator it = desktop.getComponents().iterator();
        while (it.hasNext()) {
            this.loadAnnotations((Component)it.next());
        }
    }

    public void init(Page page, boolean defaultConfig) {
        this.setDefaultConfig(defaultConfig);
        Iterator it = page.getRoots().iterator();
        while (it.hasNext()) {
            this.loadAnnotations((Component)it.next());
        }
    }

    public void init(Component[] comps, boolean defaultConfig) {
        this.setDefaultConfig(defaultConfig);
        for (int j = 0; j < comps.length; ++j) {
            this.loadAnnotations(comps[j]);
        }
    }

    public void init(Component comp, boolean defaultConfig) {
        this.setDefaultConfig(defaultConfig);
        this.loadAnnotations(comp);
    }

    private void loadAnnotations(Component comp) {
        this.loadComponentAnnotation(comp);
        this.loadComponentPropertyAnnotation(comp);
        List children = comp.getChildren();
        Iterator it = children.iterator();
        while (it.hasNext()) {
            this.loadAnnotations((Component)it.next());
        }
    }

    private void loadComponentPropertyAnnotation(Component comp) {
        this.loadComponentPropertyAnnotationByAnnotName(comp, "default");
        this.loadComponentPropertyAnnotationByAnnotName(comp, "bind");
    }

    private void loadComponentPropertyAnnotationByAnnotName(Component comp, String annotName) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        List props = compCtrl.getAnnotatedPropertiesBy(annotName);
        for (String propName : props) {
            Object[] objs = this.loadPropertyAnnotation(comp, propName, annotName);
            this.addBinding(comp, propName, (String)objs[0], (List)objs[1], (List)objs[2], (String)objs[3], (String)objs[4], (Map)objs[5], (List)objs[6], (List)objs[7]);
        }
    }

    private void loadComponentAnnotation(Component comp) {
        this.loadComponentAnnotation(comp, "default");
        this.loadComponentAnnotation(comp, "bind");
    }

    private void loadComponentAnnotation(Component comp, String annotName) {
        ComponentCtrl compCtrl = (ComponentCtrl)comp;
        Annotation ann = compCtrl.getAnnotation(annotName);
        if (ann != null) {
            Map attrs = ann.getAttributes();
            for (Map.Entry me : attrs.entrySet()) {
                String attr = (String)me.getKey();
                List<String> expr = AnnotateDataBinder.parseExpression((String)me.getValue(), ";");
                if (expr == null || expr.get(0) == null) {
                    throw new UiException("Cannot find any bean value in the annotation <a:bind " + attr + "=\"\"/> for component " + comp + ", id=" + comp.getId());
                }
                List<String> tags = AnnotateDataBinder.parseExpression(expr.get(0), ":");
                if (tags.size() > 1) {
                    throw new UiException("bean value must be defined as the first statement in the annotation <a:bind " + attr + "=\"\"/> for component " + comp + ", id=" + comp.getId());
                }
                List<String> loadWhenEvents = null;
                List<String> saveWhenEvents = null;
                List<String> loadAfterEvents = null;
                List<String> saveAfterEvents = null;
                String access = null;
                String converter = null;
                HashMap<String, String> args = null;
                for (int j = 1; j < expr.size(); ++j) {
                    List<String> tags2 = AnnotateDataBinder.parseExpression(expr.get(j), ":");
                    if (tags2 == null) continue;
                    if ("converter".equals(tags2.get(0))) {
                        converter = tags2.size() > 1 ? tags2.get(1) : "none";
                        continue;
                    }
                    if ("save-when".equals(tags2.get(0))) {
                        if (tags2.size() > 1 && tags2.get(1) != null) {
                            saveWhenEvents = AnnotateDataBinder.parseExpression(tags2.get(1), ",");
                            continue;
                        }
                        saveWhenEvents.add("none");
                        continue;
                    }
                    if ("load-after".equals(tags2.get(0))) {
                        if (tags2.size() > 1 && tags2.get(1) != null) {
                            loadAfterEvents = AnnotateDataBinder.parseExpression(tags2.get(1), ",");
                            continue;
                        }
                        loadAfterEvents.add("none");
                        continue;
                    }
                    if ("load-when".equals(tags2.get(0))) {
                        if (tags2.size() > 1 && tags2.get(1) != null) {
                            loadWhenEvents = AnnotateDataBinder.parseExpression(tags2.get(1), ",");
                            continue;
                        }
                        loadWhenEvents.add("none");
                        continue;
                    }
                    if ("access".equals(tags2.get(0))) {
                        access = tags2.size() > 1 ? tags2.get(1) : "none";
                        continue;
                    }
                    if ("save-after".equals(tags2.get(0))) {
                        if (tags2.size() > 1 && tags2.get(1) != null) {
                            saveAfterEvents = AnnotateDataBinder.parseExpression(tags2.get(1), ",");
                            continue;
                        }
                        saveAfterEvents.add("none");
                        continue;
                    }
                    if (args == null) {
                        args = new HashMap<String, String>(1);
                    }
                    args.put(tags2.get(0), tags2.get(1));
                }
                if (loadWhenEvents != null && loadWhenEvents.isEmpty()) {
                    loadWhenEvents = null;
                }
                if (saveWhenEvents != null && saveWhenEvents.isEmpty()) {
                    saveWhenEvents = null;
                }
                if (loadAfterEvents != null && loadAfterEvents.isEmpty()) {
                    loadAfterEvents = null;
                }
                if (saveAfterEvents != null && saveAfterEvents.isEmpty()) {
                    saveAfterEvents = null;
                }
                this.addBinding(comp, attr, expr.get(0), loadWhenEvents, saveWhenEvents, access, converter, args, loadAfterEvents, saveAfterEvents);
            }
        }
    }
}

